/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk.reader;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import net.minecraft.core.NextTickListEntry;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.Registry;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.reader.ChunkReader;
import net.minecraft.core.world.data.ChunkNibbleArray;
import net.minecraft.core.world.data.ChunkUnsignedByteArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkReaderVersion2
extends ChunkReader {
    private final ListTag sectionsTag;

    public ChunkReaderVersion2(World world, CompoundTag chunkTag) {
        super(world, chunkTag);
        this.sectionsTag = chunkTag.getList("Sections");
    }

    private CompoundTag findSection(int y) {
        for (Tag<?> tag : this.sectionsTag) {
            CompoundTag cTag;
            int tagY;
            if (!(tag instanceof CompoundTag) || (tagY = (cTag = (CompoundTag)tag).getInteger("yPos")) != y) continue;
            return cTag;
        }
        return null;
    }

    @Override
    public int getX() {
        return this.tag.getInteger("xPos");
    }

    @Override
    public int getZ() {
        return this.tag.getInteger("zPos");
    }

    @Override
    public long getTicksOnUnload() {
        return -1L;
    }

    @Override
    public short @NotNull [] getBlocks(int ySection) {
        short[] blocks = null;
        CompoundTag sectionTag = this.findSection(ySection);
        if (sectionTag != null) {
            blocks = sectionTag.getShortArrayOrDefault("Blocks", null);
        }
        return blocks;
    }

    @Override
    @NotNull
    public ChunkUnsignedByteArray getData(int ySection) {
        byte[] data = null;
        CompoundTag sectionTag = this.findSection(ySection);
        if (sectionTag != null) {
            data = sectionTag.getByteArrayOrDefault("Data", null);
        }
        if (data == null) {
            return null;
        }
        return new ChunkUnsignedByteArray(16, 16, 16, data);
    }

    @Override
    @NotNull
    public ChunkNibbleArray getSkyLight(int ySection) {
        byte[] skylight = null;
        CompoundTag sectionTag = this.findSection(ySection);
        if (sectionTag != null) {
            skylight = sectionTag.getByteArrayOrDefault("SkyLight", null);
        }
        if (skylight == null) {
            return null;
        }
        return new ChunkNibbleArray(16, 16, 16, skylight);
    }

    @Override
    @NotNull
    public ChunkNibbleArray getBlockLight(int ySection) {
        byte[] blocklight = null;
        CompoundTag sectionTag = this.findSection(ySection);
        if (sectionTag != null) {
            blocklight = sectionTag.getByteArrayOrDefault("BlockLight", null);
        }
        if (blocklight == null) {
            return null;
        }
        return new ChunkNibbleArray(16, 16, 16, blocklight);
    }

    @Override
    public short @NotNull [] getHeightMap() {
        return this.tag.getShortArrayOrDefault("HeightMap", null);
    }

    @Override
    public int getAverageBlockHeight() {
        return this.tag.getInteger("AverageBlockHeight");
    }

    @Override
    public boolean getIsTerrainPopulated() {
        return this.tag.getBoolean("TerrainPopulated");
    }

    @Override
    public double[] getTemperatureMap() {
        return this.tag.getDoubleArray("TemperatureMap");
    }

    @Override
    public double[] getHumidityMap() {
        return this.tag.getDoubleArray("HumidityMap");
    }

    @Override
    public byte[] getBiomeMap(int ySection, @NotNull Int2ObjectMap<String> biomeRegistry) {
        byte[] biomeMap = null;
        CompoundTag sectionTag = this.findSection(ySection);
        if (sectionTag != null) {
            biomeMap = sectionTag.getByteArrayOrDefault("BiomeMap", null);
        }
        if (biomeMap == null) {
            biomeMap = new byte[512];
            Arrays.fill(biomeMap, (byte)-1);
        } else {
            for (int i = 0; i < biomeMap.length; ++i) {
                byte oldBiomeId = biomeMap[i];
                if (oldBiomeId < 0) continue;
                try {
                    biomeMap[i] = (byte)Registries.BIOMES.getNumericIdOfItem(Registries.BIOMES.getItem((String)biomeRegistry.get(oldBiomeId)));
                    continue;
                }
                catch (NullPointerException n) {
                    biomeMap[i] = -1;
                }
            }
        }
        return biomeMap;
    }

    @Override
    public Int2ObjectMap<String> getBiomeRegistry() {
        CompoundTag registriesTag = this.tag.getCompoundOrDefault("Registries", null);
        CompoundTag biomesTag = null;
        if (registriesTag != null) {
            biomesTag = registriesTag.getCompoundOrDefault("Biomes", null);
        }
        if (registriesTag == null || biomesTag == null) {
            return null;
        }
        return Registry.readIdMapFromTag(biomesTag);
    }

    @Override
    @Nullable
    public Int2ObjectMap<NextTickListEntry> getTickList() {
        return null;
    }
}

