/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.pos;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.pos.ChunkTilePos;
import net.minecraft.core.world.pos.Pos3i;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class ChunkSectionTilePos
implements Pos3i<ChunkSectionTilePos> {
    public int x;
    public int y;
    public int z;

    public ChunkSectionTilePos(int x, int y, int z) {
        this.x = Integer.remainderUnsigned(x, 16);
        this.y = Integer.remainderUnsigned(y, 16);
        this.z = Integer.remainderUnsigned(z, 16);
    }

    public ChunkSectionTilePos(float x, float y, float z) {
        this(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public ChunkSectionTilePos(double x, double y, double z) {
        this(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public ChunkSectionTilePos(@NotNull ChunkTilePos tilePos) {
        this(tilePos.x, tilePos.y, tilePos.z);
    }

    public ChunkSectionTilePos(@NotNull TilePos tilePos) {
        this(tilePos.x, tilePos.y, tilePos.z);
    }

    public ChunkSectionTilePos(@NotNull Vec3 vec) {
        this(vec.x, vec.y, vec.z);
    }

    public ChunkSectionTilePos(@NotNull Entity entity) {
        this(entity.x, entity.y, entity.z);
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    @Override
    public int z() {
        return this.z;
    }

    @Override
    @NotNull
    public ChunkSectionTilePos add(int x, int y, int z) {
        return new ChunkSectionTilePos(this.x + x, this.y + y, this.z + z);
    }

    @NotNull
    public ChunkTilePos toChunkTilePos(int sectionIndex) {
        return new ChunkTilePos(this.x, this.y + sectionIndex * 16, this.z);
    }

    public boolean inBounds() {
        return this.x >= 0 && this.x < 16 && this.y >= 0 && this.y < 16 && this.z >= 0 && this.z < 16;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChunkSectionTilePos)) {
            return false;
        }
        @NotNull ChunkSectionTilePos other = (ChunkSectionTilePos)obj;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        return MathHelper.cantor(MathHelper.cantor(this.x, this.y), this.z);
    }
}

