/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.achievement.stat;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatBasic;
import net.minecraft.core.achievement.stat.StatMob;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryBlastFurnace;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCrafting;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryFurnace;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryTrommel;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.NamespaceID;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class StatList {
    protected static Map<NamespaceID, Stat> statMap = new HashMap<NamespaceID, Stat>();
    public static List<Stat> registeredStats = new ArrayList<Stat>();
    public static List<Stat> basicStats = new ArrayList<Stat>();
    public static List<Stat> usedItemStats = new ArrayList<Stat>();
    public static final String STAT_USED = "stat_used";
    public static final String STAT_DEPLETED = "stat_broken";
    public static final String STAT_CRAFTED = "stat_crafted";
    public static final String STAT_PICKED_UP = "stat_picked_up";
    public static final String STAT_MINED = "stat_mined";
    public static Stat startGameStat = new StatBasic(NamespaceID.fromPool("minecraft", "start_game"), "stat.startGame").setClientside().registerStat();
    public static Stat createWorldStat = new StatBasic(NamespaceID.fromPool("minecraft", "create_world"), "stat.createWorld").setClientside().registerStat();
    public static Stat loadWorldStat = new StatBasic(NamespaceID.fromPool("minecraft", "load_world"), "stat.loadWorld").setClientside().registerStat();
    public static Stat joinMultiplayerStat = new StatBasic(NamespaceID.fromPool("minecraft", "join_multiplayer"), "stat.joinMultiplayer").setClientside().registerStat();
    public static Stat leaveGameStat = new StatBasic(NamespaceID.fromPool("minecraft", "leave_game"), "stat.leaveGame").setClientside().registerStat();
    public static Stat minutesPlayedStat = new StatBasic(NamespaceID.fromPool("minecraft", "playtime"), "stat.playOneMinute", Stat.statTypeTime).setClientside().registerStat();
    public static Stat distanceWalkedStat = new StatBasic(NamespaceID.fromPool("minecraft", "travel_walk"), "stat.walkOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceSwumStat = new StatBasic(NamespaceID.fromPool("minecraft", "travel_swim"), "stat.swimOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceFallenStat = new StatBasic(NamespaceID.fromPool("minecraft", "travel_fall"), "stat.fallOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceClimbedStat = new StatBasic(NamespaceID.fromPool("minecraft", "travel_climb"), "stat.climbOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceFlownStat = new StatBasic(NamespaceID.fromPool("minecraft", "travel_fly"), "stat.flyOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceDoveStat = new StatBasic(NamespaceID.fromPool("minecraft", "travel_dive"), "stat.diveOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceByMinecartStat = new StatBasic(NamespaceID.fromPool("minecraft", "travel_minecart"), "stat.minecartOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceByBoatStat = new StatBasic(NamespaceID.fromPool("minecraft", "travel_boat"), "stat.boatOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat distanceByPigStat = new StatBasic(NamespaceID.fromPool("minecraft", "travel_pig"), "stat.pigOneCm", Stat.statTypeDistance).setClientside().registerStat();
    public static Stat jumpStat = new StatBasic(NamespaceID.fromPool("minecraft", "jump"), "stat.jump").setClientside().registerStat();
    public static Stat dropStat = new StatBasic(NamespaceID.fromPool("minecraft", "drop"), "stat.drop").setClientside().registerStat();
    public static Stat damageDealtStat = new StatBasic(NamespaceID.fromPool("minecraft", "damage_dealt"), "stat.damageDealt").registerStat();
    public static Stat damageTakenStat = new StatBasic(NamespaceID.fromPool("minecraft", "damage_taken"), "stat.damageTaken").registerStat();
    public static Stat deathsStat = new StatBasic(NamespaceID.fromPool("minecraft", "deaths"), "stat.deaths").registerStat();
    public static Stat mobKillsStat = new StatBasic(NamespaceID.fromPool("minecraft", "kills_mob"), "stat.mobKills").registerStat();
    public static Stat playerKillsStat = new StatBasic(NamespaceID.fromPool("minecraft", "kills_player"), "stat.playerKills").registerStat();
    public static Stat fishCaughtStat = new StatBasic(NamespaceID.fromPool("minecraft", "caught_fish"), "stat.fishCaught").registerStat();
    public static Map<NamespaceID, Stat> mobEncounterStats;
    public static Int2IntMap replacementMap;

    public static void initReplaceMap() {
        for (Item item : Item.itemsList) {
            Item parent;
            if (item == null || (parent = item.getStatParent()) == null) continue;
            if (item.id == parent.id) {
                throw new RuntimeException("Attempted to set '" + String.valueOf(item.namespaceID) + "' parent to itself!");
            }
            replacementMap.put(item.id, parent.id);
        }
    }

    public static void init() {
        StatList.initReplaceMap();
        Achievements.init();
        IntOpenHashSet craftable = new IntOpenHashSet();
        for (RecipeEntryCrafting<?, ?> recipeEntryCrafting : Registries.RECIPES.getAllCraftingRecipes()) {
            if (recipeEntryCrafting.getOutput() instanceof ItemStack) {
                craftable.add(((ItemStack)recipeEntryCrafting.getOutput()).itemID);
                continue;
            }
            if (!(recipeEntryCrafting.getOutput() instanceof IItemConvertible)) continue;
            craftable.add(((Item)recipeEntryCrafting.getOutput()).asItem().id);
        }
        for (RecipeEntryFurnace recipeEntryFurnace : Registries.RECIPES.getAllFurnaceRecipes()) {
            if (recipeEntryFurnace.getOutput() == null) continue;
            craftable.add(((ItemStack)recipeEntryFurnace.getOutput()).itemID);
        }
        for (RecipeEntryBlastFurnace recipeEntryBlastFurnace : Registries.RECIPES.getAllBlastFurnaceRecipes()) {
            if (recipeEntryBlastFurnace.getOutput() == null) continue;
            craftable.add(((ItemStack)recipeEntryBlastFurnace.getOutput()).itemID);
        }
        for (RecipeEntryTrommel recipeEntryTrommel : Registries.RECIPES.getAllTrommelRecipes()) {
            if (recipeEntryTrommel.getOutput() == null) continue;
            WeightedRandomBag bag = (WeightedRandomBag)recipeEntryTrommel.getOutput();
            for (WeightedRandomLootObject o : bag.getEntries()) {
                ItemStack stack = o.getItemStack();
                if (stack == null) continue;
                craftable.add(stack.itemID);
            }
        }
        for (Integer n : craftable) {
            Item.itemsList[n].createStat(STAT_CRAFTED, "stat.craftItem");
        }
        mobEncounterStats = new HashMap<NamespaceID, Stat>();
        for (EntityDispatcher.EntityDispatcherEntry entityDispatcherEntry : EntityDispatcher.getInstance().entries) {
            mobEncounterStats.put(entityDispatcherEntry.namespaceID, new StatMob(NamespaceID.fromPool("minecraft", "encounter_" + entityDispatcherEntry.namespaceID.toString().replace(":", "_")), "stat.encounterMob", entityDispatcherEntry.namespaceID).registerStat());
        }
    }

    @Nullable
    public static Stat getStat(NamespaceID id) {
        return statMap.get(id);
    }

    public static @Unmodifiable Collection<Stat> getAllStats() {
        return Collections.unmodifiableCollection(statMap.values());
    }

    static {
        replacementMap = new Int2IntOpenHashMap();
    }

    public static class StatConverter {
        public static final int OFFSET_OFFSET = 65536;
        public static final int OFFSET_MINED = 0x1000000;
        public static final int OFFSET_CRAFTED = 0x1010000;
        public static final int OFFSET_USED = 0x1020000;
        public static final int OFFSET_DEPLETED = 0x1030000;
        public static final int OFFSET_PICKED_UP = 0x1040000;
        public static final int OFFSET_MOB = 0x1050000;
        public static final int OFFSET_ACHIEVEMENT = 0x500000;

        @Nullable
        public static Stat getStatFromDeprecatedID(int id) {
            switch (id) {
                case 1000: {
                    return startGameStat;
                }
                case 1001: {
                    return createWorldStat;
                }
                case 1002: {
                    return loadWorldStat;
                }
                case 1003: {
                    return joinMultiplayerStat;
                }
                case 1004: {
                    return leaveGameStat;
                }
                case 1100: {
                    return minutesPlayedStat;
                }
                case 2000: {
                    return distanceWalkedStat;
                }
                case 2001: {
                    return distanceSwumStat;
                }
                case 2002: {
                    return distanceFallenStat;
                }
                case 2003: {
                    return distanceClimbedStat;
                }
                case 2004: {
                    return distanceFlownStat;
                }
                case 2005: {
                    return distanceDoveStat;
                }
                case 2006: {
                    return distanceByMinecartStat;
                }
                case 2007: {
                    return distanceByBoatStat;
                }
                case 2008: {
                    return distanceByPigStat;
                }
                case 2010: {
                    return jumpStat;
                }
                case 2011: {
                    return dropStat;
                }
                case 2020: {
                    return damageDealtStat;
                }
                case 2021: {
                    return damageTakenStat;
                }
                case 2022: {
                    return deathsStat;
                }
                case 2023: {
                    return mobKillsStat;
                }
                case 2024: {
                    return playerKillsStat;
                }
                case 2025: {
                    return fishCaughtStat;
                }
            }
            if (0x1000000 <= id && id < 0x1010000) {
                Item i = Item.getItem(id - 0x1000000);
                return i == null ? null : i.getStat(StatList.STAT_MINED);
            }
            if (0x1010000 <= id && id < 0x1020000) {
                Item i = Item.getItem(id - 0x1010000);
                return i == null ? null : i.getStat(StatList.STAT_CRAFTED);
            }
            if (0x1020000 <= id && id < 0x1030000) {
                Item i = Item.getItem(id - 0x1020000);
                return i == null ? null : i.getStat(StatList.STAT_USED);
            }
            if (0x1030000 <= id && id < 0x1040000) {
                Item i = Item.getItem(id - 0x1030000);
                return i == null ? null : i.getStat(StatList.STAT_DEPLETED);
            }
            if (0x1040000 <= id && id < 0x1050000) {
                Item i = Item.getItem(id - 0x1040000);
                return i == null ? null : i.getStat(StatList.STAT_PICKED_UP);
            }
            if (0x1050000 <= id && id < 0x1060000) {
                Class<? extends Entity> c = EntityDispatcher.Legacy.getClassFromID(id - 0x1050000);
                EntityDispatcher.EntityDispatcherEntry<? extends Entity> entry = EntityDispatcher.getInstance().entryForClass(c);
                NamespaceID entityID = entry != null ? entry.namespaceID : null;
                return mobEncounterStats.get(entityID);
            }
            if (0x500000 <= id && id < 0x1000000) {
                int achievementID = id - 0x500000;
                switch (achievementID) {
                    case 0: {
                        return Achievements.OPEN_INVENTORY;
                    }
                    case 1: {
                        return Achievements.MINE_WOOD;
                    }
                    case 2: {
                        return Achievements.BUILD_WORKBENCH;
                    }
                    case 3: {
                        return Achievements.BUILD_PICKAXE;
                    }
                    case 4: {
                        return Achievements.BUILD_FURNACE;
                    }
                    case 5: {
                        return Achievements.ACQUIRE_IRON;
                    }
                    case 6: {
                        return Achievements.BUILD_HOE;
                    }
                    case 7: {
                        return Achievements.MAKE_BREAD;
                    }
                    case 8: {
                        return Achievements.BAKE_CAKE;
                    }
                    case 9: {
                        return Achievements.BUILD_BETTER_PICKAXE;
                    }
                    case 10: {
                        return Achievements.COOK_FISH;
                    }
                    case 11: {
                        return Achievements.ON_A_RAIL;
                    }
                    case 12: {
                        return Achievements.BUILD_SWORD;
                    }
                    case 13: {
                        return Achievements.KILL_ENEMY;
                    }
                    case 14: {
                        return Achievements.KILL_COW;
                    }
                    case 15: {
                        return Achievements.FLY_PIG;
                    }
                    case 16: {
                        return Achievements.GET_SENSED;
                    }
                    case 17: {
                        return Achievements.CRAFT_HANDCANNON;
                    }
                    case 18: {
                        return Achievements.COLLECT_STONE;
                    }
                    case 19: {
                        return Achievements.CRUSH_BLOCKS;
                    }
                    case 20: {
                        return Achievements.REPAIR_ARMOR;
                    }
                    case 21: {
                        return Achievements.GET_CHAINMAIL;
                    }
                    case 22: {
                        return Achievements.OPEN_GUIDEBOOK;
                    }
                    case 23: {
                        return Achievements.CAUGHT_EM_ALL;
                    }
                }
            }
            return null;
        }
    }
}

