/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net;

import java.util.Hashtable;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServerAddress {
    @NotNull
    private final String ipAddress;
    private final int serverPort;

    private ServerAddress(@NotNull String ip, int port) {
        this.ipAddress = ip;
        this.serverPort = port;
    }

    @NotNull
    public String getIP() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.serverPort;
    }

    @Nullable
    public static ServerAddress resolveServerIP(@Nullable String ipToResolve) {
        int port;
        int ipv6End;
        if (ipToResolve == null) {
            return null;
        }
        String[] ipSplit = ipToResolve.split(":");
        if (ipToResolve.startsWith("[") && (ipv6End = ipToResolve.indexOf("]")) > 0) {
            String ipv6IP = ipToResolve.substring(1, ipv6End);
            String port2 = ipToResolve.substring(ipv6End + 1).trim();
            if (port2.startsWith(":")) {
                port2 = port2.substring(1);
                ipSplit = new String[]{ipv6IP, port2};
            } else {
                ipSplit = new String[]{ipv6IP};
            }
        }
        if (ipSplit.length > 2) {
            ipSplit = new String[]{ipToResolve};
        }
        String ip = ipSplit[0];
        int n = port = ipSplit.length > 1 ? ServerAddress.parseIntWithDefault(ipSplit[1], 25565) : 25565;
        if (port == 25565) {
            String[] recordSplit = ServerAddress.resolveSRVRecord(ip);
            ip = recordSplit[0];
            port = ServerAddress.parseIntWithDefault(recordSplit[1], 25565);
        }
        return new ServerAddress(ip, port);
    }

    private static String[] resolveSRVRecord(String ip) {
        try {
            Hashtable<String, String> contextTable = new Hashtable<String, String>();
            contextTable.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            contextTable.put("java.naming.provider.url", "dns:");
            InitialDirContext context = new InitialDirContext(contextTable);
            Attributes attr = context.getAttributes("_minecraft._tcp." + ip, new String[]{"SRV"});
            String[] ipSplit = attr.get("srv").get().toString().split(" ", 4);
            return new String[]{ipSplit[3], ipSplit[2]};
        }
        catch (Throwable t) {
            return new String[]{ip, Integer.toString(25565)};
        }
    }

    private static int parseIntWithDefault(String str, int defaultVal) {
        try {
            return Integer.parseInt(str.trim());
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public String toString() {
        return this.ipAddress + ":" + this.serverPort;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerAddress address = (ServerAddress)o;
        return this.serverPort == address.serverPort && this.ipAddress.equals(address.ipAddress);
    }

    public int hashCode() {
        int result = this.ipAddress.hashCode();
        result = 31 * result + this.serverPort;
        return result;
    }
}

