/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.season.SeasonManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkCache
implements WorldSource {
    @NotNull
    private final ChunkPos origin;
    @NotNull
    private final @NotNull Chunk @NotNull [] @NotNull [] chunkArray;
    @NotNull
    private final World world;

    public ChunkCache(@NotNull World world, @NotNull TilePos min, @NotNull TilePos max) {
        this.world = world;
        this.origin = min.toChunkPos();
        @NotNull ChunkPos chunkMax = max.toChunkPos();
        this.chunkArray = new Chunk[chunkMax.x - this.origin.x + 1][chunkMax.z - this.origin.z + 1];
        for (int x = this.origin.x; x <= chunkMax.x; ++x) {
            for (int z = this.origin.z; z <= chunkMax.z; ++z) {
                this.chunkArray[x - this.origin.x][z - this.origin.z] = this.world.getChunk(new ChunkPos(x, z));
            }
        }
    }

    @Deprecated
    public ChunkCache(@NotNull World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this(world, new TilePos(minX, minY, minZ), new TilePos(maxX, maxY, maxZ));
    }

    @Override
    public int getHeightBlocks() {
        return this.world.getHeightBlocks();
    }

    @Override
    public int getBlockId(@NotNull TilePos tilePos) {
        if (tilePos.y < 0 || tilePos.y >= this.getHeightBlocks()) {
            return 0;
        }
        @NotNull ChunkPos cachePos = tilePos.toChunkPos().sub(this.origin);
        if (cachePos.x < 0 || cachePos.x >= this.chunkArray.length || cachePos.z < 0 || cachePos.z >= this.chunkArray[cachePos.x].length) {
            return 0;
        }
        @NotNull Chunk chunk = this.chunkArray[cachePos.x][cachePos.z];
        return chunk.getBlockID(tilePos.x & 0xF, tilePos.y, tilePos.z & 0xF);
    }

    @Override
    @Nullable
    public Block<?> getBlock(@NotNull TilePos tilePos) {
        return Blocks.getBlock(this.getBlockId(tilePos));
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(@NotNull TilePos tilePos) {
        @NotNull ChunkPos cachePos = tilePos.toChunkPos().sub(this.origin);
        return this.chunkArray[cachePos.x][cachePos.z].getTileEntity(tilePos.x & 0xF, tilePos.y, tilePos.z & 0xF);
    }

    public boolean getBlockLitInteriorSurface(@NotNull TilePos tilePos) {
        if (!tilePos.inBounds(this)) {
            return true;
        }
        return Block.getIsLitInteriorSurface(this.world, tilePos);
    }

    @Deprecated
    public boolean getBlockLitInteriorSurface(int x, int y, int z) {
        return this.getBlockLitInteriorSurface(new TilePos(x, y, z));
    }

    @Override
    public float getBrightness(@NotNull TilePos tilePos, int lightEmission) {
        int lightValue = this.getBlockLightValue(tilePos);
        return this.world.getWorldType().getBrightnessRamp()[Math.max(lightValue, lightEmission)];
    }

    @Override
    public int getLightmapCoord(@NotNull TilePos tilePos, int lightEmission) {
        int skyLight = this.world.getSavedLightValue(LightLayer.Sky, tilePos);
        int blockLight = Math.max(this.world.getSavedLightValue(LightLayer.Block, tilePos), lightEmission);
        if (this.getBlockLitInteriorSurface(tilePos)) {
            skyLight = Math.max(skyLight, this.world.getSavedLightValue(LightLayer.Sky, (TilePos)tilePos.up()));
            skyLight = Math.max(skyLight, this.world.getSavedLightValue(LightLayer.Sky, (TilePos)tilePos.down()));
            skyLight = Math.max(skyLight, this.world.getSavedLightValue(LightLayer.Sky, (TilePos)tilePos.east()));
            skyLight = Math.max(skyLight, this.world.getSavedLightValue(LightLayer.Sky, (TilePos)tilePos.west()));
            skyLight = Math.max(skyLight, this.world.getSavedLightValue(LightLayer.Sky, (TilePos)tilePos.south()));
            skyLight = Math.max(skyLight, this.world.getSavedLightValue(LightLayer.Sky, (TilePos)tilePos.north()));
            blockLight = Math.max(blockLight, this.world.getSavedLightValue(LightLayer.Block, (TilePos)tilePos.up()));
            blockLight = Math.max(blockLight, this.world.getSavedLightValue(LightLayer.Block, (TilePos)tilePos.down()));
            blockLight = Math.max(blockLight, this.world.getSavedLightValue(LightLayer.Block, (TilePos)tilePos.east()));
            blockLight = Math.max(blockLight, this.world.getSavedLightValue(LightLayer.Block, (TilePos)tilePos.west()));
            blockLight = Math.max(blockLight, this.world.getSavedLightValue(LightLayer.Block, (TilePos)tilePos.south()));
            blockLight = Math.max(blockLight, this.world.getSavedLightValue(LightLayer.Block, (TilePos)tilePos.north()));
        }
        return this.getLightmapCoord(skyLight, blockLight);
    }

    @Override
    public int getLightmapCoord(int skyLight, int blockLight) {
        return this.world.getLightmapCoord(skyLight, blockLight);
    }

    @Override
    public float getLightBrightness(@NotNull TilePos tilePos) {
        return this.world.worldType.getBrightnessRamp()[this.getBlockLightValue(tilePos)];
    }

    public int getBlockLightValue(@NotNull TilePos tilePos) {
        return this.getBlockLightValue_do(tilePos, true);
    }

    @Deprecated
    public int getLightValue(int x, int y, int z) {
        return this.getBlockLightValue(new TilePos(x, y, z));
    }

    @Deprecated
    private int getBlockLightValue_do(@NotNull TilePos tilePos, boolean first) {
        if (tilePos.x < -32000000 || tilePos.z < -32000000 || tilePos.x >= 32000000 || tilePos.z > 32000000) {
            return 15;
        }
        if (first && this.getBlockLitInteriorSurface(tilePos)) {
            int lightUp = this.getBlockLightValue_do((TilePos)tilePos.up(), false);
            int lightEast = this.getBlockLightValue_do((TilePos)tilePos.east(), false);
            int lightWest = this.getBlockLightValue_do((TilePos)tilePos.west(), false);
            int lightSouth = this.getBlockLightValue_do((TilePos)tilePos.south(), false);
            int lightNorth = this.getBlockLightValue_do((TilePos)tilePos.north(), false);
            return Math.max(lightUp, Math.max(lightEast, Math.max(lightWest, Math.max(lightSouth, lightNorth))));
        }
        if (tilePos.y < 0) {
            return 0;
        }
        if (tilePos.y >= this.getHeightBlocks()) {
            int brightness = 15 - this.world.skyDarken;
            if (brightness < 0) {
                brightness = 0;
            }
            return brightness;
        }
        @NotNull ChunkPos cachePos = tilePos.toChunkPos().sub(this.origin);
        return this.chunkArray[cachePos.x][cachePos.z].getRawBrightness(tilePos.x & 0xF, tilePos.y, tilePos.z & 0xF, this.world.skyDarken);
    }

    @Override
    public int getBlockData(@NotNull TilePos tilePos) {
        if (tilePos.y < 0 || tilePos.y >= this.getHeightBlocks()) {
            return 0;
        }
        @NotNull ChunkPos cachePos = tilePos.toChunkPos().sub(this.origin);
        return this.chunkArray[cachePos.x][cachePos.z].getBlockMetadata(tilePos.x & 0xF, tilePos.y, tilePos.z & 0xF);
    }

    @Override
    @NotNull
    public Material getBlockMaterial(@NotNull TilePos tilePos) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        if (block == null) {
            return Material.air;
        }
        return block.getMaterial();
    }

    @Override
    public boolean isBlockOpaqueCube(@NotNull TilePos tilePos) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        return block != null && block.isSolidRender();
    }

    @Override
    public boolean isBlockNormalCube(@NotNull TilePos tilePos) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        return block != null && block.getMaterial().isSolidBlocking() && block.renderAsNormalBlockOnCondition(this, tilePos.x, tilePos.y, tilePos.z);
    }

    @Override
    public double getBlockTemperature(@NotNull TilePos tilePos) {
        return this.world.getBlockTemperature(tilePos);
    }

    @Override
    public double getBlockHumidity(@NotNull TilePos tilePos) {
        return this.world.getBlockHumidity(tilePos);
    }

    @Override
    public double getBlockVariety(@NotNull TilePos tilePos) {
        return this.world.getBlockVariety(tilePos);
    }

    @Override
    @NotNull
    public SeasonManager getSeasonManager() {
        return this.world.getSeasonManager();
    }

    @Override
    @NotNull
    public Biome getBlockBiome(@NotNull TilePos tilePos) {
        return this.world.getBlockBiome(tilePos);
    }

    @Override
    public int getSavedLightValue(@NotNull LightLayer lightLayer, @NotNull TilePos tilePos) {
        return this.world.getSavedLightValue(lightLayer, tilePos);
    }

    @Override
    public boolean isRetro() {
        return this.world.isRetro();
    }
}

