/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicCactus
extends BlockLogic
implements IBonemealable {
    public BlockLogicCactus(@NotNull Block<?> block) {
        super(block, Material.cactus);
        block.setTicking(true);
        float indent = 0.0625f;
        this.setBlockBounds(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePos tilePos) {
        this.onNeighborChanged(world, tilePos, 0);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (world.isAirBlock((TilePos)tilePos.up())) {
            int cactusHeight = 1;
            while (world.getBlockId((TilePos)tilePos.sub(0, cactusHeight, 0)) == this.block.id()) {
                ++cactusHeight;
            }
            if (cactusHeight < 3) {
                int data = world.getBlockData(tilePos);
                if (data == 15) {
                    world.setBlockIdNotify((TilePos)tilePos.up(), this.block.id());
                    world.setBlockDataNotify(tilePos, 0);
                } else {
                    world.setBlockDataNotify(tilePos, data + 1);
                }
            }
        }
    }

    private void growCactusOnTop(@NotNull World world, @NotNull TilePos tilePos) {
        @NotNull TilePos offsetPos = new TilePos(tilePos);
        offsetPos.y = tilePos.y + 1;
        while (world.getBlockId(offsetPos) == this.block.id()) {
            ++offsetPos.y;
        }
        if (world.isAirBlock(offsetPos)) {
            world.setBlockIdNotify(offsetPos, this.block.id());
        }
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        if (side.isVertical()) {
            return PartialSupport.INSTANCE.center();
        }
        return PartialSupport.INSTANCE;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePos tilePos) {
        if (!super.canPlaceAt(world, tilePos)) {
            return false;
        }
        return this.canStay(world, tilePos);
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        if (!this.canStay(world, tilePos)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePos tilePos) {
        if (world.getBlockMaterial((TilePos)tilePos.west()).isSolid()) {
            return false;
        }
        if (world.getBlockMaterial((TilePos)tilePos.east()).isSolid()) {
            return false;
        }
        if (world.getBlockMaterial((TilePos)tilePos.north()).isSolid()) {
            return false;
        }
        if (world.getBlockMaterial((TilePos)tilePos.south()).isSolid()) {
            return false;
        }
        int idDown = world.getBlockId((TilePos)tilePos.down());
        return Blocks.hasTag(idDown, BlockTags.GROWS_CACTI);
    }

    @Override
    public void onEntityCollision(@NotNull World world, @NotNull TilePos tilePos, @NotNull Entity entity) {
        if (entity instanceof Mob || entity instanceof EntityMinecart || entity instanceof EntityBoat) {
            entity.hurt(null, 1, DamageType.COMBAT);
        }
    }

    @Override
    public boolean onBonemealUsed(@NotNull ItemStack itemStack, @Nullable Player player, @NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        if (!world.isClientSide) {
            this.growCactusOnTop(world, tilePos);
            if (player == null || player.getGamemode().consumeBlocks()) {
                --itemStack.stackSize;
            }
        }
        return true;
    }
}

