/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Objects;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.block.entity.TileEntityChest;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.ContainerCompound;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicChest
extends BlockLogic
implements IPaintable {
    public static final int directionBits = 3;
    public static final int directionOffset = 0;
    public static final int typeBits = 12;
    public static final int typeOffset = 2;

    public BlockLogicChest(@NotNull Block<?> block, @NotNull Material material) {
        super(block, material);
        block.withEntity(TileEntityChest::new);
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        @NotNull Direction direction = mob.getHorizontalPlacementDirection(side).getOpposite();
        @NotNull Type type = Type.SINGLE;
        if (mob.isSneaking() && side.isHorizontal() && (mob.rotationLockHorizontal == null || mob.rotationLockHorizontal == Direction.NONE)) {
            @NotNull TilePos placedOn = (TilePos)tilePos.sub(side.getDirection());
            if (BlockLogicChest.isSingleChest(world, placedOn)) {
                @NotNull Direction direction2 = BlockLogicChest.getDirectionFromMeta(world.getBlockData(placedOn));
                if (direction2 == Direction.NORTH) {
                    if (side == Side.EAST) {
                        BlockLogicChest.setType(world, placedOn, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                    if (side == Side.WEST) {
                        BlockLogicChest.setType(world, placedOn, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                }
                if (direction2 == Direction.EAST) {
                    if (side == Side.SOUTH) {
                        BlockLogicChest.setType(world, placedOn, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                    if (side == Side.NORTH) {
                        BlockLogicChest.setType(world, placedOn, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                }
                if (direction2 == Direction.SOUTH) {
                    if (side == Side.EAST) {
                        BlockLogicChest.setType(world, placedOn, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                    if (side == Side.WEST) {
                        BlockLogicChest.setType(world, placedOn, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                }
                if (direction2 == Direction.WEST) {
                    if (side == Side.SOUTH) {
                        BlockLogicChest.setType(world, placedOn, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                    if (side == Side.NORTH) {
                        BlockLogicChest.setType(world, placedOn, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                }
            }
        } else if (!mob.isSneaking()) {
            if (direction == Direction.NORTH) {
                if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.west(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.east(), direction)) {
                    type = Type.LEFT;
                    BlockLogicChest.setType(world, (TilePos)tilePos.west(), Type.RIGHT);
                }
                if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.east(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.west(), direction)) {
                    type = Type.RIGHT;
                    BlockLogicChest.setType(world, (TilePos)tilePos.east(), Type.LEFT);
                }
            }
            if (direction == Direction.EAST) {
                if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.north(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.south(), direction)) {
                    type = Type.LEFT;
                    BlockLogicChest.setType(world, (TilePos)tilePos.north(), Type.RIGHT);
                }
                if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.south(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.north(), direction)) {
                    type = Type.RIGHT;
                    BlockLogicChest.setType(world, (TilePos)tilePos.south(), Type.LEFT);
                }
            }
            if (direction == Direction.SOUTH) {
                if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.west(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.east(), direction)) {
                    type = Type.RIGHT;
                    BlockLogicChest.setType(world, (TilePos)tilePos.west(), Type.LEFT);
                }
                if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.east(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.west(), direction)) {
                    type = Type.LEFT;
                    BlockLogicChest.setType(world, (TilePos)tilePos.east(), Type.RIGHT);
                }
            }
            if (direction == Direction.WEST) {
                if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.north(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.south(), direction)) {
                    type = Type.RIGHT;
                    BlockLogicChest.setType(world, (TilePos)tilePos.north(), Type.LEFT);
                }
                if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.south(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.north(), direction)) {
                    type = Type.LEFT;
                    BlockLogicChest.setType(world, (TilePos)tilePos.south(), Type.RIGHT);
                }
            }
        }
        int meta = world.getBlockData(tilePos);
        meta = BlockLogicChest.getMetaWithDirection(meta, direction);
        meta = BlockLogicChest.getMetaWithType(meta, type);
        world.setBlockData(tilePos, meta);
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        Direction direction = side.getDirection();
        Type type = Type.SINGLE;
        if (direction == Direction.NORTH) {
            if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.west(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.east(), direction)) {
                type = Type.LEFT;
                BlockLogicChest.setType(world, (TilePos)tilePos.west(), Type.RIGHT);
            }
            if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.east(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.west(), direction)) {
                type = Type.RIGHT;
                BlockLogicChest.setType(world, (TilePos)tilePos.east(), Type.LEFT);
            }
        }
        if (direction == Direction.EAST) {
            if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.north(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.south(), direction)) {
                type = Type.LEFT;
                BlockLogicChest.setType(world, (TilePos)tilePos.north(), Type.RIGHT);
            }
            if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.south(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.north(), direction)) {
                type = Type.RIGHT;
                BlockLogicChest.setType(world, (TilePos)tilePos.south(), Type.LEFT);
            }
        }
        if (direction == Direction.SOUTH) {
            if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.west(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.east(), direction)) {
                type = Type.RIGHT;
                BlockLogicChest.setType(world, (TilePos)tilePos.west(), Type.LEFT);
            }
            if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.east(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.west(), direction)) {
                type = Type.LEFT;
                BlockLogicChest.setType(world, (TilePos)tilePos.east(), Type.RIGHT);
            }
        }
        if (direction == Direction.WEST) {
            if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.north(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.south(), direction)) {
                type = Type.RIGHT;
                BlockLogicChest.setType(world, (TilePos)tilePos.north(), Type.LEFT);
            }
            if (BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.south(), direction) && !BlockLogicChest.isSingleChestWithDirection(world, (TilePos)tilePos.north(), direction)) {
                type = Type.LEFT;
                BlockLogicChest.setType(world, (TilePos)tilePos.south(), Type.RIGHT);
            }
        }
        int meta = world.getBlockData(tilePos);
        meta = BlockLogicChest.getMetaWithDirection(meta, direction);
        meta = BlockLogicChest.getMetaWithType(meta, type);
        world.setBlockData(tilePos, meta);
    }

    public void checkIfOtherHalfExists(@NotNull World world, @NotNull TilePos tilePos) {
        int meta = world.getBlockData(tilePos);
        @NotNull Type type = BlockLogicChest.getTypeFromMeta(meta);
        if (type != Type.SINGLE) {
            int otherMeta;
            @NotNull Direction direction = BlockLogicChest.getDirectionFromMeta(meta);
            @NotNull TilePos otherChest = new TilePos(tilePos);
            if (direction == Direction.NORTH) {
                if (type == Type.LEFT) {
                    --otherChest.x;
                }
                if (type == Type.RIGHT) {
                    ++otherChest.x;
                }
            }
            if (direction == Direction.EAST) {
                if (type == Type.LEFT) {
                    --otherChest.z;
                }
                if (type == Type.RIGHT) {
                    ++otherChest.z;
                }
            }
            if (direction == Direction.SOUTH) {
                if (type == Type.LEFT) {
                    ++otherChest.x;
                }
                if (type == Type.RIGHT) {
                    --otherChest.x;
                }
            }
            if (direction == Direction.WEST) {
                if (type == Type.LEFT) {
                    ++otherChest.z;
                }
                if (type == Type.RIGHT) {
                    --otherChest.z;
                }
            }
            boolean valid = false;
            if (BlockLogicChest.isChest(world, otherChest) && BlockLogicChest.getDirectionFromMeta(otherMeta = world.getBlockData(otherChest)) == direction) {
                @NotNull Type otherType = BlockLogicChest.getTypeFromMeta(otherMeta);
                if (type == Type.LEFT && otherType == Type.RIGHT || type == Type.RIGHT && otherType == Type.LEFT) {
                    valid = true;
                }
            }
            if (!valid) {
                BlockLogicChest.setType(world, tilePos, Type.SINGLE);
                world.markBlockDirty(tilePos);
            }
        }
    }

    public static void setDefaultDirection(@NotNull World world, @NotNull TilePos tilePos) {
        if (world.isClientSide) {
            return;
        }
        int bN = world.getBlockId((TilePos)tilePos.north());
        int bS = world.getBlockId((TilePos)tilePos.south());
        int bW = world.getBlockId((TilePos)tilePos.west());
        int bE = world.getBlockId((TilePos)tilePos.east());
        @NotNull Direction direction = Direction.NORTH;
        if (Blocks.solid[bN] && !Blocks.solid[bS]) {
            direction = Direction.SOUTH;
        }
        if (Blocks.solid[bS] && !Blocks.solid[bN]) {
            direction = Direction.NORTH;
        }
        if (Blocks.solid[bW] && !Blocks.solid[bE]) {
            direction = Direction.EAST;
        }
        if (Blocks.solid[bE] && !Blocks.solid[bW]) {
            direction = Direction.WEST;
        }
        world.setBlockDataNotify(tilePos, BlockLogicChest.getMetaWithType(BlockLogicChest.getMetaWithDirection(world.getBlockData(tilePos), direction), Type.SINGLE));
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        super.onNeighborChanged(world, tilePos, id);
        this.checkIfOtherHalfExists(world, tilePos);
    }

    public static boolean isChest(@NotNull World world, @NotNull TilePos tilePos) {
        @Nullable Block<?> b = world.getBlock(tilePos);
        return b != null && b.getLogic() instanceof BlockLogicChest;
    }

    public static boolean isSingleChest(@NotNull World world, @NotNull TilePos tilePos) {
        return BlockLogicChest.isChest(world, tilePos) && BlockLogicChest.getTypeFromMeta(world.getBlockData(tilePos)) == Type.SINGLE;
    }

    public static boolean isSingleChestWithDirection(@NotNull World world, @NotNull TilePos tilePos, @NotNull Direction direction) {
        int meta = world.getBlockData(tilePos);
        return BlockLogicChest.isChest(world, tilePos) && BlockLogicChest.getTypeFromMeta(meta) == Type.SINGLE && BlockLogicChest.getDirectionFromMeta(meta) == direction;
    }

    public void setDirection(@NotNull World world, @NotNull TilePos tilePos, @NotNull Direction direction) {
        if (BlockLogicChest.isChest(world, tilePos)) {
            world.setBlockDataNotify(tilePos, BlockLogicChest.getMetaWithDirection(world.getBlockData(tilePos), direction));
        }
    }

    public static void setType(@NotNull World world, @NotNull TilePos tilePos, @NotNull Type type) {
        if (BlockLogicChest.isChest(world, tilePos)) {
            world.setBlockDataNotify(tilePos, BlockLogicChest.getMetaWithType(world.getBlockData(tilePos), type));
        }
    }

    @Nullable
    public static Direction getDirection(@NotNull World world, @NotNull TilePos tilePos) {
        if (BlockLogicChest.isChest(world, tilePos)) {
            return BlockLogicChest.getDirectionFromMeta(world.getBlockData(tilePos));
        }
        return null;
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        if (world.isClientSide) {
            return true;
        }
        this.checkIfOtherHalfExists(world, tilePos);
        player.displayChestScreen(BlockLogicChest.getInventory(world, tilePos), tilePos.x, tilePos.y, tilePos.z);
        return true;
    }

    @NotNull
    public static Container getInventory(@NotNull World world, @NotNull TilePos tilePos) {
        @NotNull Container inventory = (Container)((Object)Objects.requireNonNull(world.getTileEntity(tilePos)));
        int meta = world.getBlockData(tilePos);
        @NotNull Type type = BlockLogicChest.getTypeFromMeta(meta);
        if (type != Type.SINGLE) {
            int otherMeta;
            Container inv2 = null;
            Direction direction = BlockLogicChest.getDirectionFromMeta(meta);
            @NotNull TilePos otherChest = new TilePos(tilePos);
            if (direction == Direction.NORTH) {
                if (type == Type.LEFT) {
                    --otherChest.x;
                }
                if (type == Type.RIGHT) {
                    ++otherChest.x;
                }
            }
            if (direction == Direction.EAST) {
                if (type == Type.LEFT) {
                    --otherChest.z;
                }
                if (type == Type.RIGHT) {
                    ++otherChest.z;
                }
            }
            if (direction == Direction.SOUTH) {
                if (type == Type.LEFT) {
                    ++otherChest.x;
                }
                if (type == Type.RIGHT) {
                    --otherChest.x;
                }
            }
            if (direction == Direction.WEST) {
                if (type == Type.LEFT) {
                    ++otherChest.z;
                }
                if (type == Type.RIGHT) {
                    --otherChest.z;
                }
            }
            if (BlockLogicChest.isChest(world, otherChest) && BlockLogicChest.getDirectionFromMeta(otherMeta = world.getBlockData(otherChest)) == direction) {
                @NotNull Type otherType = BlockLogicChest.getTypeFromMeta(otherMeta);
                if (type == Type.LEFT && otherType == Type.RIGHT) {
                    inv2 = (Container)((Object)world.getTileEntity(otherChest));
                }
                if (type == Type.RIGHT && otherType == Type.LEFT) {
                    inv2 = inventory;
                    inventory = (Container)((Object)Objects.requireNonNull(world.getTileEntity(otherChest)));
                }
            }
            if (inv2 != null) {
                inventory = new ContainerCompound("container.chest.large.name", inventory, inv2);
            }
        }
        return inventory;
    }

    public static int getMetaWithDirection(int meta, @Nullable Direction direction) {
        if (direction == null) {
            return meta;
        }
        meta &= 0xFFFFFFFC;
        return meta |= direction.ordinal() << 0 & 3;
    }

    public static int getMetaWithType(int meta, @Nullable Type type) {
        if (type == null) {
            return meta;
        }
        meta &= 0xFFFFFFF3;
        return meta |= type.ordinal() << 2 & 0xC;
    }

    @NotNull
    public static Direction getDirectionFromMeta(int meta) {
        return switch (meta &= 3) {
            case 0 -> Direction.NORTH;
            case 1 -> Direction.EAST;
            case 2 -> Direction.SOUTH;
            case 3 -> Direction.WEST;
            default -> Direction.NONE;
        };
    }

    @NotNull
    public static Type getTypeFromMeta(int meta) {
        return Type.get(meta >> 2 & 3);
    }

    @Override
    public void setColor(@NotNull World world, @NotNull TilePos tilePos, @NotNull DyeColor color) {
        int meta = world.getBlockData(tilePos);
        world.setBlockIdDataRaw(tilePos, Blocks.CHEST_PLANKS_OAK_PAINTED.id(), meta);
        world.setBlockData(tilePos, meta);
        Blocks.CHEST_PLANKS_OAK_PAINTED.getLogic().setColor(world, tilePos, color);
    }

    public static enum Type {
        SINGLE,
        LEFT,
        RIGHT;


        @NotNull
        public static Type get(int i) {
            if (i < 0 || i >= Type.values().length) {
                i = 0;
            }
            return Objects.requireNonNull(Type.values()[i]);
        }
    }
}

