/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockLogicEdible
extends BlockLogic {
    @NotNull
    private final @NotNull Supplier<@NotNull Item> itemSupplier;
    public int maxBites;

    public BlockLogicEdible(@NotNull Block<?> block, int maxBites, @NotNull @NotNull Supplier<@NotNull Item> dropItemSupplier) {
        super(block, Material.cake);
        this.maxBites = maxBites;
        this.itemSupplier = dropItemSupplier;
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        if (dropCause == EnumDropCause.PICK_BLOCK || data == 0) {
            return new ItemStack[]{new ItemStack(this.itemSupplier.get())};
        }
        return null;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    private void eatSlice(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player) {
        if (player.getHealth() < player.getMaxHealth()) {
            player.heal(this.getHealAmount(world, tilePos));
            int data = world.getBlockData(tilePos) + 1;
            if (data >= this.maxBites) {
                world.setBlockIdNotify(tilePos, 0);
            } else {
                world.setBlockDataNotify(tilePos, data);
                world.markBlockDirty(tilePos);
            }
        }
    }

    public abstract int getHealAmount(@NotNull World var1, @NotNull TilePos var2);

    @Deprecated
    public final int getHealAmount(@NotNull World world, int x, int y, int z) {
        return this.getHealAmount(world, new TilePos(x, y, z));
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        if (player.getHealth() == player.getMaxHealth()) {
            return false;
        }
        this.eatSlice(world, tilePos, player);
        return true;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePos tilePos) {
        if (!super.canPlaceAt(world, tilePos)) {
            return false;
        }
        return this.canStay(world, tilePos);
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        if (!this.canStay(world, tilePos)) {
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePos tilePos) {
        return world.getBlockMaterial((TilePos)tilePos.down()).isSolid();
    }
}

