/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicFenceGate
extends BlockLogic
implements IPaintable {
    public static final int MASK_DIRECTION = 3;
    public static final int MASK_OPEN = 4;
    public static final int MASK_POWERED = 8;

    public BlockLogicFenceGate(@NotNull Block<?> block) {
        super(block, Material.wood);
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        int metadata = source.getBlockData(tilePos);
        if (BlockLogicFenceGate.isOpen(metadata)) {
            return null;
        }
        return this.getAABBFromMeta(metadata).grow(0.0, 0.25, 0.0).move(tilePos.x, (float)tilePos.y + 0.25f, tilePos.z);
    }

    @NotNull
    private AABB getAABBFromMeta(int meta) {
        if (BlockLogicFenceGate.getDirection(meta) == 3 || BlockLogicFenceGate.getDirection(meta) == 1) {
            return AABB.fromPool(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
        }
        return AABB.fromPool(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    }

    @Override
    @NotNull
    public AABB getBoundsFromState(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return this.getAABBFromMeta(source.getBlockData(tilePos));
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        int direction = mob.getHorizontalPlacementDirection(side).getHorizontalIndex();
        int meta = world.getBlockData(tilePos);
        world.setBlockDataNotify(tilePos, direction | meta & 0xFFFFFFFC);
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        if (!side.isHorizontal()) {
            side = Side.NORTH;
        }
        int direction = side.getDirection().getHorizontalIndex();
        int meta = world.getBlockData(tilePos);
        world.setBlockDataNotify(tilePos, direction | meta & 0xFFFFFFFC);
    }

    @Override
    public void onAttacked(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player, @NotNull Side side, double xHit, double yHit) {
        if (!Item.hasTag(player.getCurrentEquippedItem(), ItemTags.PREVENT_LEFT_CLICK_INTERACTIONS)) {
            this.onInteracted(world, tilePos, player, null, 0.0, 0.0);
        }
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePos tilePos, @Nullable Player player, @Nullable Side side, double xHit, double yHit) {
        int data = world.getBlockData(tilePos);
        if (BlockLogicFenceGate.isOpen(data)) {
            world.setBlockDataNotify(tilePos, data & 0xFFFFFFFB);
            world.playBlockEvent(tilePos, 1003, 0);
        } else {
            int dir;
            int i1 = 0;
            if (player != null) {
                i1 = (MathHelper.floor((double)(player.yRot * 4.0f / 360.0f) + 0.5) & 3) % 4;
            }
            if ((dir = BlockLogicFenceGate.getDirection(data)) == (i1 + 2) % 4) {
                data = data & 0xF0 | i1;
            }
            world.setBlockDataNotify(tilePos, data | 4);
            world.playBlockEvent(tilePos, 1003, 0);
        }
        return true;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        boolean hasPower;
        int data = world.getBlockData(tilePos);
        boolean wasPowered = BlockLogicFenceGate.isPowered(data);
        boolean bl = hasPower = world.hasNeighborSignal(tilePos) || world.hasDirectSignal(tilePos);
        if (hasPower && !wasPowered) {
            world.setBlockDataNotify(tilePos, data | 4 | 8);
            world.playBlockEvent(tilePos, 1003, 0);
        } else if (!hasPower && wasPowered) {
            world.setBlockDataNotify(tilePos, data & 0xFFFFFFF3);
            world.playBlockEvent(tilePos, 1003, 0);
        }
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        this.onInteracted(world, tilePos, null, direction.getSide(), 0.5, 0.5);
    }

    public static boolean isOpen(int meta) {
        return (meta & 4) != 0;
    }

    public static boolean isPowered(int meta) {
        return (meta & 8) != 0;
    }

    public static int getDirection(int meta) {
        return meta & 3;
    }

    @Override
    public void setColor(@NotNull World world, @NotNull TilePos tilePos, @NotNull DyeColor color) {
        world.setBlockIdDataNotify(tilePos, Blocks.FENCE_GATE_PLANKS_OAK_PAINTED.id(), world.getBlockData(tilePos));
        Blocks.FENCE_GATE_PLANKS_OAK_PAINTED.getLogic().setColor(world, tilePos, color);
    }
}

