/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFire;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.weather.IPrecipitation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicFireCold
extends BlockLogicFire {
    public BlockLogicFireCold(@NotNull Block<?> block) {
        super(block);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        boolean infiniBurn;
        @Nullable Block<?> blockUnder = world.getBlock((TilePos)tilePos.down());
        boolean bl = infiniBurn = blockUnder != null && blockUnder.hasTag(BlockTags.INFINITE_BURN_COLD);
        if (!this.isValidFireLocation(world, tilePos)) {
            this.setBurnResult(world, tilePos);
        }
        if (!infiniBurn && world.getCurrentWeather() != null && world.getCurrentWeather() instanceof IPrecipitation && (world.isBlockBeingRainedOn(tilePos) || world.isBlockBeingRainedOn((TilePos)tilePos.west()) || world.isBlockBeingRainedOn((TilePos)tilePos.east()) || world.isBlockBeingRainedOn((TilePos)tilePos.north()) || world.isBlockBeingRainedOn((TilePos)tilePos.south()))) {
            this.setBurnResult(world, tilePos);
            return;
        }
        int meta = world.getBlockData(tilePos);
        if (meta < 15) {
            world.setBlockData(tilePos, meta + rand.nextInt(3) / 2);
        }
        world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay());
        if (!infiniBurn && !this.canNeighborCatchFire(world, tilePos)) {
            if (!world.isBlockNormalCube((TilePos)tilePos.down()) || meta > 3) {
                this.setBurnResult(world, tilePos);
            }
            return;
        }
        if (!infiniBurn && !BlockLogicFireCold.canBurn(world, (TilePos)tilePos.down()) && meta == 15 && rand.nextInt(4) == 0) {
            this.setBurnResult(world, tilePos);
        }
    }
}

