/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Fluid;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockLogicFluid
extends BlockLogic {
    @NotNull
    protected final Fluid fluid;

    public BlockLogicFluid(@NotNull Block<?> block, @NotNull Material material, @NotNull Fluid fluid) {
        super(block, material);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.fluid = fluid;
    }

    public static float getHeight(int data) {
        if ((data &= 0xF) >= 8) {
            data = 0;
        }
        return (float)(data + 1) / 8.0f;
    }

    protected int getDepth(WorldSource worldSource, @NotNull TilePos tilePos) {
        if (worldSource.getBlockMaterial(tilePos) != this.material) {
            return -1;
        }
        return worldSource.getBlockData(tilePos) & 0xF;
    }

    protected int getRenderedDepth(@NotNull WorldSource worldSource, @NotNull TilePos tilePos) {
        if (worldSource.getBlockMaterial(tilePos) != this.material) {
            return -1;
        }
        int meta = worldSource.getBlockData(tilePos) & 0xF;
        if (meta >= 8) {
            meta = 0;
        }
        return meta;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public boolean canCollideCheck(int data, boolean shouldCollideWithFluids) {
        return shouldCollideWithFluids && (data & 0xF) == 0;
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return null;
    }

    private Vec3 getFlow(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        Vec3 result = Vec3.fromPool(0.0, 0.0, 0.0);
        int depthLocal = this.getRenderedDepth(source, tilePos);
        TilePos p = new TilePos(tilePos);
        for (int i = 0; i < 4; ++i) {
            int mult;
            p.set(tilePos.x, tilePos.y, tilePos.z);
            switch (i) {
                case 0: {
                    --tilePos.x;
                    break;
                }
                case 1: {
                    --tilePos.z;
                    break;
                }
                case 2: {
                    ++tilePos.x;
                    break;
                }
                case 3: {
                    ++tilePos.z;
                }
            }
            int depthCheck = this.getRenderedDepth(source, p);
            if (depthCheck < 0) {
                if (source.getBlockMaterial(p).blocksMotion() || (depthCheck = this.getRenderedDepth(source, (TilePos)p.down())) < 0) continue;
                mult = depthCheck - (depthLocal - 8);
                result = result.add((p.x - tilePos.x) * mult, 0.0, (p.z - tilePos.z) * mult);
                continue;
            }
            mult = depthCheck - depthLocal;
            result = result.add((p.x - tilePos.x) * mult, 0.0, (p.z - tilePos.z) * mult);
        }
        result = result.normalize();
        return result;
    }

    @Override
    public void onEntityInside(@NotNull World world, @NotNull TilePos tilePos, @NotNull Entity entity, @NotNull Vec3 velocity) {
        if (entity.noPhysics) {
            return;
        }
        Vec3 flowVector = this.getFlow(world, tilePos);
        velocity.x += flowVector.x;
        velocity.y += flowVector.y;
        velocity.z += flowVector.z;
    }

    @Override
    public int tickDelay() {
        return this.fluid.tickDelay();
    }

    @Override
    public float getBrightness(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        float br = source.getLightBrightness(tilePos);
        float brAbove = source.getLightBrightness((TilePos)tilePos.up());
        return Math.max(br, brAbove);
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand) {
        this.fluid.animationTick(this, world, tilePos, rand);
    }

    public double getSlopeAngle(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        Vec3 vec = this.getFlow(source, tilePos);
        if (vec == null || vec.x == 0.0 && vec.z == 0.0) {
            return -1000.0;
        }
        return Math.atan2(vec.z, vec.x) - 1.5707963267948966;
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePos tilePos) {
        this.checkForHarden(world, tilePos);
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        this.checkForHarden(world, tilePos);
    }

    private void checkForHarden(World world, @NotNull TilePos tilePos) {
        if (world.getBlockId(tilePos) != this.block.id()) {
            return;
        }
        this.fluid.checkForHarden(this, world, tilePos, world.getBlockMaterial((TilePos)tilePos.north()));
        this.fluid.checkForHarden(this, world, tilePos, world.getBlockMaterial((TilePos)tilePos.south()));
        this.fluid.checkForHarden(this, world, tilePos, world.getBlockMaterial((TilePos)tilePos.west()));
        this.fluid.checkForHarden(this, world, tilePos, world.getBlockMaterial((TilePos)tilePos.east()));
        this.fluid.checkForHarden(this, world, tilePos, world.getBlockMaterial((TilePos)tilePos.up()));
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return null;
    }

    protected static void fizz(@NotNull World world, @NotNull TilePos tilePos) {
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float)tilePos.x + 0.5f, (float)tilePos.y + 0.5f, (float)tilePos.z + 0.5f, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            world.spawnParticle("largesmoke", (double)tilePos.x + Math.random(), (double)tilePos.y + 1.2, (double)tilePos.z + Math.random(), 0.0, 0.0, 0.0, 0);
        }
    }

    @Override
    @NotNull
    public AABB getBoundsFromState(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        float myHeight = this.getFluidHeight(source, tilePos);
        float heightPosZ = this.getFluidHeight(source, tilePos.add(0, 0, 1));
        float heightPosXPosZ = this.getFluidHeight(source, tilePos.add(1, 0, 1));
        float heightPosX = this.getFluidHeight(source, tilePos.add(1, 0, 0));
        return AABB.fromPool(0.0, 0.0, 0.0, 1.0, Math.max((double)((myHeight + heightPosZ + heightPosXPosZ + heightPosX) / 4.0f), 0.2), 1.0);
    }

    public float getFluidHeight(@NotNull WorldSource worldSource, @NotNull TilePos tilePos) {
        int count = 0;
        float height = 0.0f;
        TilePos p = new TilePos(tilePos);
        for (int i = 0; i < 4; ++i) {
            p.set(tilePos.x - (i & 1), tilePos.y, tilePos.z - (i >> 1 & 1));
            if (worldSource.getBlockMaterial((TilePos)p.up()) == this.material) {
                return 1.0f;
            }
            Material adjMaterial = worldSource.getBlockMaterial(p);
            if (adjMaterial == this.material) {
                int data = worldSource.getBlockData(p) & 0xF;
                if (data >= 8 || data == 0) {
                    height += BlockLogicFluid.getHeight(data) * 10.0f;
                    count += 10;
                }
                height += BlockLogicFluid.getHeight(data);
                ++count;
                continue;
            }
            if (adjMaterial.isSolid()) continue;
            height += 1.0f;
            ++count;
        }
        return Math.max(1.0f - height / (float)count, 0.015f);
    }

    @Override
    public boolean isEquivalent(@NotNull World world, @NotNull TilePos thisPos, @NotNull TilePos thatPos) {
        Block<?> bBlock = world.getBlock(thatPos);
        int thisMeta = world.getBlockData(thisPos);
        int otherMeta = world.getBlockData(thatPos);
        if (Block.hasLogicClass(bBlock, BlockLogicFluid.class)) {
            return this.material == bBlock.getMaterial() && thisMeta == otherMeta;
        }
        return false;
    }
}

