/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.Fluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class BlockLogicFluidFlowing
extends BlockLogicFluid {
    int maxCount = 0;
    boolean @NotNull [] result = new boolean[4];
    int @NotNull [] distance = new int[4];
    @NotNull
    public final Block<?> blockStill;

    public BlockLogicFluidFlowing(@NotNull Block<?> block, @NotNull Material material, @NotNull Fluid fluid, @NotNull Block<?> blockStill) {
        super(block, material, fluid);
        this.blockStill = blockStill;
    }

    private void setFluidStill(@NotNull World world, @NotNull TilePos tilePos) {
        world.setBlockIdData(tilePos, this.blockStill.id(), world.getBlockData(tilePos));
        world.markBlocksDirty(tilePos, tilePos);
        world.markBlockNeedsUpdate(tilePos);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        int localFlowDecay = this.getDepth(world, tilePos);
        byte flowDecayMod = this.fluid.getFlowDecayMod(this, world, tilePos);
        TilePos down = (TilePos)tilePos.down();
        TilePos up = (TilePos)tilePos.up();
        TilePos north = (TilePos)tilePos.north();
        TilePos south = (TilePos)tilePos.south();
        TilePos west = (TilePos)tilePos.west();
        TilePos east = (TilePos)tilePos.east();
        if (localFlowDecay > 0) {
            int surroundingFlowDecay = -100;
            this.maxCount = 0;
            surroundingFlowDecay = this.getHighest(world, west, surroundingFlowDecay);
            surroundingFlowDecay = this.getHighest(world, east, surroundingFlowDecay);
            surroundingFlowDecay = this.getHighest(world, north, surroundingFlowDecay);
            int newFlowDecay = (surroundingFlowDecay = this.getHighest(world, south, surroundingFlowDecay)) + flowDecayMod;
            if (newFlowDecay >= 8 || surroundingFlowDecay < 0) {
                newFlowDecay = -1;
            }
            if (this.getDepth(world, up) >= 0) {
                int flowDecayAbove = this.getDepth(world, up);
                newFlowDecay = flowDecayAbove >= 8 ? flowDecayAbove : flowDecayAbove + 8;
            }
            if (this.maxCount >= 2 && this.fluid.canBecomeSource(this, world, tilePos, rand)) {
                if (world.getBlockMaterial(down).isSolid()) {
                    newFlowDecay = 0;
                } else if (world.getBlockMaterial(down) == this.material && world.getBlockData(down) == 0) {
                    newFlowDecay = 0;
                }
            }
            if (newFlowDecay != localFlowDecay) {
                localFlowDecay = newFlowDecay;
                if (localFlowDecay < 0) {
                    world.setBlockIdNotify(tilePos, 0);
                } else {
                    world.setBlockDataNotify(tilePos, localFlowDecay);
                    world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay());
                    world.notifyBlocksOfNeighborChange(tilePos, this.block.id());
                }
            } else {
                this.setFluidStill(world, tilePos);
            }
        } else {
            this.setFluidStill(world, tilePos);
        }
        if (this.canSpreadTo(world, down)) {
            Block<?> b = world.getBlock(down);
            if (b != null) {
                b.dropWithCause(world, EnumDropCause.WORLD, down, world.getBlockData(down), null, null);
            }
            if (localFlowDecay >= 8) {
                world.setBlockIdDataNotify(down, this.block.id(), localFlowDecay);
            } else {
                world.setBlockIdDataNotify(down, this.block.id(), localFlowDecay + 8);
            }
        } else if (localFlowDecay >= 0 && (localFlowDecay == 0 || this.isFluidBlocking(world, down))) {
            boolean[] spreadFlags = this.getSpread(world, tilePos);
            int k1 = localFlowDecay + flowDecayMod;
            if (localFlowDecay >= 8) {
                k1 = 1;
            }
            if (k1 >= 8) {
                return;
            }
            if (spreadFlags[0]) {
                this.flowIntoBlock(world, west, k1);
            }
            if (spreadFlags[1]) {
                this.flowIntoBlock(world, east, k1);
            }
            if (spreadFlags[2]) {
                this.flowIntoBlock(world, north, k1);
            }
            if (spreadFlags[3]) {
                this.flowIntoBlock(world, south, k1);
            }
        }
    }

    private void flowIntoBlock(@NotNull World world, @NotNull TilePos tilePos, int meta) {
        if (this.canSpreadTo(world, tilePos)) {
            int id = world.getBlockId(tilePos);
            if (id > 0) {
                this.fluid.onFlowIntoBlock(this, world, tilePos, meta);
            }
            world.setBlockIdDataNotify(tilePos, this.block.id(), meta);
        }
    }

    private int getSlopeDistance(@NotNull World world, @NotNull TilePos tilePos, int l, int i1) {
        int j1 = 1000;
        TilePos p = new TilePos(tilePos);
        for (int d = 0; d < 4; ++d) {
            int k2;
            if (d == 0 && i1 == 1 || d == 1 && i1 == 0 || d == 2 && i1 == 3 || d == 3 && i1 == 2) continue;
            p.set(tilePos.x, tilePos.y, tilePos.z);
            switch (d) {
                case 0: {
                    --p.x;
                    break;
                }
                case 1: {
                    ++p.x;
                    break;
                }
                case 2: {
                    --p.z;
                    break;
                }
                case 3: {
                    ++p.z;
                }
            }
            if (this.isFluidBlocking(world, p) || world.getBlockMaterial(p) == this.material && world.getBlockData(p) == 0) continue;
            if (!this.isFluidBlocking(world, (TilePos)p.down())) {
                return l;
            }
            if (l >= 4 || (k2 = this.getSlopeDistance(world, p, l + 1, d)) >= j1) continue;
            j1 = k2;
        }
        return j1;
    }

    private boolean[] getSpread(@NotNull World world, @NotNull TilePos tilePos) {
        TilePos p = new TilePos(tilePos);
        for (int d = 0; d < 4; ++d) {
            this.distance[d] = 1000;
            p.set(tilePos.x, tilePos.y, tilePos.z);
            switch (d) {
                case 0: {
                    --p.x;
                    break;
                }
                case 1: {
                    ++p.x;
                    break;
                }
                case 2: {
                    --p.z;
                    break;
                }
                case 3: {
                    ++p.z;
                }
            }
            if (this.isFluidBlocking(world, p) || world.getBlockMaterial(p) == this.material && world.getBlockData(p) == 0) continue;
            this.distance[d] = !this.isFluidBlocking(world, (TilePos)p.down()) ? 0 : this.getSlopeDistance(world, p, 1, d);
        }
        int i1 = this.distance[0];
        for (int k1 = 1; k1 < 4; ++k1) {
            if (this.distance[k1] >= i1) continue;
            i1 = this.distance[k1];
        }
        for (int l1 = 0; l1 < 4; ++l1) {
            this.result[l1] = this.distance[l1] == i1;
        }
        return this.result;
    }

    private boolean isFluidBlocking(@NotNull World world, @NotNull TilePos tilePos) {
        Block<?> b = world.getBlock(tilePos);
        return b != null && !(b.getLogic() instanceof BlockLogicFluid) && !b.hasTag(BlockTags.BROKEN_BY_FLUIDS);
    }

    protected int getHighest(@NotNull World world, @NotNull TilePos tilePos, int currentFlowDecay) {
        int flowDecay = this.getDepth(world, tilePos);
        if (flowDecay < 0) {
            return currentFlowDecay;
        }
        if (flowDecay == 0) {
            ++this.maxCount;
        }
        if (flowDecay >= 8) {
            flowDecay = 0;
        }
        return currentFlowDecay >= 0 && flowDecay >= currentFlowDecay ? currentFlowDecay : flowDecay;
    }

    private boolean canSpreadTo(@NotNull World world, @NotNull TilePos tilePos) {
        Material material = world.getBlockMaterial(tilePos);
        if (material == this.material) {
            return false;
        }
        if (!this.fluid.canSpreadTo(this, world, tilePos, material)) {
            return false;
        }
        return !this.isFluidBlocking(world, tilePos);
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePos tilePos) {
        super.onPlacedByWorld(world, tilePos);
        if (world.getBlockId(tilePos) == this.block.id()) {
            world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay());
        }
    }
}

