/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicLamp
extends BlockLogic
implements IPainted {
    public boolean isActive;
    public boolean isInverted;

    public BlockLogicLamp(Block<?> block, boolean isActive, boolean isInverted) {
        super(block, Material.stone);
        this.isActive = isActive;
        this.isInverted = isInverted;
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePos tilePos) {
        if (this.isInverted) {
            if (this.isActive && (world.hasDirectSignal(tilePos) || world.hasNeighborSignal(tilePos))) {
                world.setBlockIdDataNotify(tilePos, Blocks.LAMP_INVERTED_IDLE.id(), world.getBlockData(tilePos));
            }
        } else if (this.isActive && !world.hasDirectSignal(tilePos) && !world.hasNeighborSignal(tilePos)) {
            world.setBlockIdDataNotify(tilePos, Blocks.LAMP_IDLE.id(), world.getBlockData(tilePos));
        }
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        boolean hasSignal;
        if (world.isClientSide) {
            return;
        }
        boolean bl = hasSignal = world.hasDirectSignal(tilePos) || world.hasNeighborSignal(tilePos);
        if (this.isInverted) {
            if (hasSignal && this.isActive) {
                world.setBlockIdDataNotify(tilePos, Blocks.LAMP_INVERTED_IDLE.id(), world.getBlockData(tilePos));
            } else if (!hasSignal && !this.isActive) {
                world.setBlockIdDataNotify(tilePos, Blocks.LAMP_INVERTED_ACTIVE.id(), world.getBlockData(tilePos));
            }
        } else if (hasSignal && !this.isActive) {
            world.setBlockIdDataNotify(tilePos, Blocks.LAMP_ACTIVE.id(), world.getBlockId(tilePos));
        } else if (!hasSignal && this.isActive) {
            world.setBlockIdDataNotify(tilePos, Blocks.LAMP_IDLE.id(), world.getBlockData(tilePos));
        }
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        boolean hasSignal;
        boolean bl = hasSignal = world.hasDirectSignal(tilePos) || world.hasNeighborSignal(tilePos);
        if (this.isInverted) {
            if (hasSignal && this.isActive) {
                world.setBlockIdDataNotify(tilePos, Blocks.LAMP_INVERTED_IDLE.id(), world.getBlockData(tilePos));
            } else if (!hasSignal && !this.isActive) {
                world.setBlockIdDataNotify(tilePos, Blocks.LAMP_INVERTED_ACTIVE.id(), world.getBlockData(tilePos));
            }
        } else if (hasSignal && !this.isActive) {
            world.setBlockIdDataNotify(tilePos, Blocks.LAMP_ACTIVE.id(), world.getBlockData(tilePos));
        } else if (!hasSignal && this.isActive) {
            world.setBlockIdDataNotify(tilePos, Blocks.LAMP_IDLE.id(), world.getBlockData(tilePos));
        }
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        if (player.getHeldItem() == null) {
            this.invertLamp(world, tilePos);
            return true;
        }
        return false;
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        this.invertLamp(world, tilePos);
    }

    public void invertLamp(@NotNull World world, @NotNull TilePos tilePos) {
        if (this.isInverted) {
            if (this.isActive) {
                world.setBlockIdDataNotify(tilePos, Blocks.LAMP_IDLE.id(), world.getBlockData(tilePos));
            } else {
                world.setBlockIdDataNotify(tilePos, Blocks.LAMP_ACTIVE.id(), world.getBlockData(tilePos));
            }
        } else if (this.isActive) {
            world.setBlockIdDataNotify(tilePos, Blocks.LAMP_INVERTED_IDLE.id(), world.getBlockData(tilePos));
        } else {
            world.setBlockIdDataNotify(tilePos, Blocks.LAMP_INVERTED_ACTIVE.id(), world.getBlockData(tilePos));
        }
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Blocks.LAMP_IDLE, 1, data)};
    }

    @Override
    @NotNull
    public DyeColor fromMetadata(int meta) {
        return DyeColor.colorFromBlockMeta(meta & 0xF);
    }

    @Override
    public int toMetadata(@NotNull DyeColor color) {
        return color.blockMeta;
    }

    @Override
    public int stripColorFromMetadata(int meta) {
        return 0;
    }

    @Override
    public void removeDye(@NotNull World world, @NotNull TilePos tilePos) {
        world.setBlockDataNotify(tilePos, 0);
    }
}

