/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.item.block.ItemBlockLayer;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockLogicLayerBase
extends BlockLogic {
    @Nullable
    public final Block<?> fullBlock;
    public static final int MASK_HEIGHT = 7;

    public BlockLogicLayerBase(@NotNull Block<? extends BlockLogicLayerBase> block, @Nullable Block<?> fullBlock, @NotNull Material material) {
        super(block, material);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
        block.setBlockItem(() -> new ItemBlockLayer(block));
        this.fullBlock = fullBlock;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        int height = world.getBlockData(tilePos) & 7;
        return switch (side) {
            case Side.TOP -> PartialSupport.INSTANCE;
            case Side.BOTTOM -> FullSupport.INSTANCE;
            default -> height >= 5 ? PartialSupport.INSTANCE.center().down() : (height >= 1 ? PartialSupport.INSTANCE.down() : PartialSupport.INSTANCE);
        };
    }

    @Override
    @NotNull
    public AABB getBoundsFromState(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        int data = source.getBlockData(tilePos) & 7;
        float f = (float)(2 * (1 + data)) / 16.0f;
        return AABB.fromPool(0.0, 0.0, 0.0, 1.0, f, 1.0);
    }
}

