/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicAxisAligned;
import net.minecraft.core.block.BlockLogicLeavesBase;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class BlockLogicLog
extends BlockLogicAxisAligned {
    public BlockLogicLog(@NotNull Block<?> block) {
        super(block, Material.wood);
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePos tilePos, int data) {
        int r = 4;
        int r2 = r + 1;
        if (world.areBlocksLoaded(tilePos.add(-r2, -r2, -r2), tilePos.add(r2, r2, r2))) {
            TilePos p = new TilePos(tilePos);
            for (int xOff = -r; xOff <= r; ++xOff) {
                for (int yOff = -r; yOff <= r; ++yOff) {
                    for (int zOff = -r; zOff <= r; ++zOff) {
                        int leavesMeta;
                        p.set(tilePos.x + xOff, tilePos.y + yOff, tilePos.z + zOff);
                        Block<?> block = world.getBlock(p);
                        if (block == null || !(block.getLogic() instanceof BlockLogicLeavesBase) || BlockLogicLeavesBase.isPermanent(leavesMeta = world.getBlockData(p))) continue;
                        world.setBlockData(p, BlockLogicLeavesBase.setDecaying(leavesMeta, true));
                    }
                }
            }
        }
    }
}

