/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicMobSpawnerDeactivated;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicMobSpawner
extends BlockLogicMobSpawnerDeactivated {
    public BlockLogicMobSpawner(@NotNull Block<?> block) {
        super(block);
        block.withEntity(TileEntityMobSpawner::new);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        if (player.getGamemode() != Gamemode.creative) {
            return false;
        }
        player.displayMobPickerScreen(tilePos);
        return true;
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        TileEntity tileEntity = world.getTileEntity(tilePos);
        if (tileEntity instanceof TileEntityMobSpawner) {
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)tileEntity;
            spawner.setMobId("none");
        }
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePos tilePos, int data) {
        if (!world.isClientSide) {
            TileEntityMobSpawner tileEntityMobSpawner = (TileEntityMobSpawner)world.getTileEntity(tilePos);
            if (tileEntityMobSpawner == null) {
                return;
            }
            int amountToDrop = world.rand.nextInt(10) + 10;
            for (int l = 0; l < amountToDrop; ++l) {
                ItemStack itemstack;
                String mobInSpawner = tileEntityMobSpawner.getMobId();
                if (mobInSpawner == null) continue;
                switch (mobInSpawner) {
                    case "minecraft:zombie": {
                        ItemStack itemStack = new ItemStack(Items.CLOTH);
                        break;
                    }
                    case "minecraft:skeleton": {
                        ItemStack itemStack;
                        if (world.rand.nextInt(2) == 0) {
                            itemStack = new ItemStack(Items.BONE);
                            break;
                        }
                        itemStack = new ItemStack(Items.AMMO_ARROW);
                        break;
                    }
                    case "minecraft:zombie_armored": {
                        ItemStack itemStack = new ItemStack(Items.CHAINLINK);
                        break;
                    }
                    case "minecraft:spider": {
                        ItemStack itemStack = new ItemStack(Items.STRING);
                        break;
                    }
                    case "minecraft:snowman": {
                        ItemStack itemStack = new ItemStack(Items.AMMO_SNOWBALL);
                        break;
                    }
                    default: {
                        ItemStack itemStack = itemstack = null;
                    }
                }
                if (itemstack == null) continue;
                float rx = world.rand.nextFloat() * 0.8f + 0.1f;
                float ry = world.rand.nextFloat() * 0.8f + 0.1f;
                float rz = world.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = world.rand.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)tilePos.x + rx, (float)tilePos.y + ry, (float)tilePos.z + rz, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.xd = (float)world.rand.nextGaussian() * f3;
                    entityitem.yd = (float)world.rand.nextGaussian() * f3 + 0.2f;
                    entityitem.zd = (float)world.rand.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onRemoved(world, tilePos, data);
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        if (dropCause == EnumDropCause.SILK_TOUCH) {
            return new ItemStack[]{new ItemStack(Blocks.MOBSPAWNER_DEACTIVATED)};
        }
        return null;
    }
}

