/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicMoss
extends BlockLogic
implements IBonemealable {
    public static Int2IntArrayMap variantMap = new Int2IntArrayMap();
    @NotNull
    public static final @NotNull Map<@NotNull Block<?>, @NotNull Block<?>> stoneToMossMap = new HashMap();
    @NotNull
    public static final @NotNull Map<@NotNull Block<?>, @NotNull Block<?>> mossToStoneMap = new HashMap();

    public BlockLogicMoss(@NotNull Block<?> block, @NotNull Block<?> parentBlock) {
        super(block, Material.moss);
        block.setTicking(true);
        variantMap.put(parentBlock.id(), block.id());
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        Block<?> mossStone;
        Direction rDir;
        TilePos randomPos;
        if (world.isClientSide) {
            return;
        }
        if (world.areBlocksLoaded(tilePos, 16) && rand.nextInt(20) == 0 && this.airExposed(world, tilePos) && this.canMossSpread(world, randomPos = (TilePos)tilePos.add(rDir = Direction.getDirectionById(rand.nextInt(6)))) && (mossStone = BlockLogicMoss.getMossBlock(world.getBlockId(randomPos))) != null) {
            world.setBlockIdNotify(randomPos, mossStone.id());
        }
    }

    public boolean canMossSpread(@NotNull World world, @NotNull TilePos tilePos) {
        if (!world.isBlockLoaded(tilePos)) {
            return false;
        }
        int maxBlockLight = 0;
        int maxSkyLight = 0;
        for (int i = 0; i < Direction.directions.length; ++i) {
            Direction dir = Direction.directions[i];
            TilePos offsetPos = (TilePos)tilePos.add(dir);
            int blockLight = world.getBlockLightValue(offsetPos);
            int skyLight = world.getSavedLightValue(LightLayer.Sky, offsetPos);
            if (blockLight > maxBlockLight) {
                maxBlockLight = blockLight;
            }
            if (skyLight <= maxSkyLight) continue;
            maxSkyLight = skyLight;
        }
        return maxBlockLight == 0 && maxSkyLight == 0;
    }

    @Nullable
    public static Block<?> getMossBlock(int blockId) {
        return BlockLogicMoss.getMossBlock(Blocks.getBlock(blockId));
    }

    @Nullable
    public static Block<?> getMossBlock(@Nullable Block<?> stoneBlock) {
        return stoneToMossMap.get(stoneBlock);
    }

    @Nullable
    public static Block<?> getStoneBlock(int blockId) {
        return BlockLogicMoss.getStoneBlock(Blocks.getBlock(blockId));
    }

    @Nullable
    public static Block<?> getStoneBlock(@Nullable Block<?> mossBlock) {
        return mossToStoneMap.get(mossBlock);
    }

    public static void initMossMap() {
        stoneToMossMap.clear();
        mossToStoneMap.clear();
        stoneToMossMap.put(Blocks.STONE, Blocks.MOSS_STONE);
        stoneToMossMap.put(Blocks.GRANITE, Blocks.MOSS_GRANITE);
        stoneToMossMap.put(Blocks.LIMESTONE, Blocks.MOSS_LIMESTONE);
        stoneToMossMap.put(Blocks.BASALT, Blocks.MOSS_BASALT);
        stoneToMossMap.put(Blocks.COBBLE_STONE, Blocks.COBBLE_STONE_MOSSY);
        stoneToMossMap.put(Blocks.COBBLE_BASALT, Blocks.COBBLE_BASALT_MOSSY);
        stoneToMossMap.put(Blocks.COBBLE_LIMESTONE, Blocks.COBBLE_LIMESTONE_MOSSY);
        stoneToMossMap.put(Blocks.COBBLE_GRANITE, Blocks.COBBLE_GRANITE_MOSSY);
        stoneToMossMap.put(Blocks.BRICK_STONE_POLISHED, Blocks.BRICK_STONE_POLISHED_MOSSY);
        stoneToMossMap.put(Blocks.LOG_OAK, Blocks.LOG_OAK_MOSSY);
        for (Map.Entry<Block<?>, Block<?>> entry : stoneToMossMap.entrySet()) {
            mossToStoneMap.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public boolean onBonemealUsed(@NotNull ItemStack itemStack, @Nullable Player player, @NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        if (!world.isClientSide) {
            if (!this.canMossSpread(world, tilePos) || !this.airExposed(world, tilePos)) {
                return false;
            }
            if (player == null || player.getGamemode().consumeBlocks()) {
                --itemStack.stackSize;
            }
            for (int i = 0; i < 32; ++i) {
                Block<?> block;
                TilePos randomPos = new TilePos(tilePos);
                for (int j = 0; j < i / 16; ++j) {
                    randomPos.x += world.rand.nextInt(3) - 1;
                    randomPos.y += (world.rand.nextInt(3) - 1) * world.rand.nextInt(3) / 2;
                    randomPos.z += world.rand.nextInt(3) - 1;
                }
                if (!this.airExposed(world, randomPos) || !this.canMossSpread(world, randomPos) || (block = BlockLogicMoss.getMossBlock(world.getBlockId(randomPos))) == null) continue;
                world.setBlockIdNotify(randomPos, block.id());
            }
        }
        return true;
    }

    public boolean airExposed(@NotNull World world, @NotNull TilePos tilePos) {
        for (int i = 0; i < Direction.directions.length; ++i) {
            Direction dir = Direction.directions[i];
            if (!world.isAirBlock((TilePos)tilePos.add(dir))) continue;
            return true;
        }
        return false;
    }
}

