/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFlower;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicMushroom
extends BlockLogicFlower {
    public BlockLogicMushroom(@NotNull Block<?> block) {
        super(block);
        float f = 0.2f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        block.setTicking(true);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        TilePos checkPos;
        if (rand.nextInt(25) == 0 && world.isAirBlock(checkPos = tilePos.add(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1)) && this.canStay(world, checkPos)) {
            checkPos.set(tilePos.x + rand.nextInt(3) - 1, checkPos.y, tilePos.z + rand.nextInt(3) - 1);
            if (world.isAirBlock(checkPos) && this.canStay(world, checkPos)) {
                world.setBlockIdNotify(checkPos, this.block.id());
            }
        }
    }

    @Override
    protected boolean mayPlaceOn(int blockId) {
        return Blocks.solid[blockId];
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePos tilePos) {
        if (tilePos.y < 0 || tilePos.y >= world.getHeightBlocks()) {
            return false;
        }
        return world.getFullBlockLightValue(tilePos) < 13 && this.mayPlaceOn(world.getBlockId((TilePos)tilePos.down()));
    }

    @Override
    public boolean onBonemealUsed(@NotNull ItemStack itemStack, @Nullable Player player, @NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        Random rand = world.rand;
        if (!world.isClientSide && this.canBeBonemealed) {
            if (player == null || player.getGamemode().consumeBlocks()) {
                --itemStack.stackSize;
            }
            TilePos p = new TilePos(tilePos);
            block0: for (int j1 = 0; j1 < 32; ++j1) {
                p.set(tilePos.x, tilePos.y, tilePos.z);
                for (int j2 = 0; j2 < j1 / 16; ++j2) {
                    p.x += rand.nextInt(3) - 1;
                    p.y += (rand.nextInt(3) - 1) * rand.nextInt(3) / 2;
                    p.z += rand.nextInt(3) - 1;
                    if (world.getFullBlockLightValue(p) >= 13 || !this.mayPlaceOn(world.getBlockId((TilePos)p.down()))) continue block0;
                }
                if (world.getBlockId(p) != 0 || !((double)rand.nextFloat() > 0.85)) continue;
                world.setBlockIdNotify(p, this.block.id());
            }
            return true;
        }
        return this.canBeBonemealed;
    }
}

