/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicNetherrackIgneous
extends BlockLogic {
    public BlockLogicNetherrackIgneous(@NotNull Block<?> block) {
        super(block, Material.netherrack);
        block.setTicking(true);
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        float f = 0.125f;
        return AABB.fromPool(tilePos.x, tilePos.y, tilePos.z, tilePos.x + 1, (float)(tilePos.y + 1) - f, tilePos.z + 1);
    }

    @Override
    public void onEntityCollision(@NotNull World world, @NotNull TilePos tilePos, @NotNull Entity entity) {
        if (entity instanceof EntityItem) {
            return;
        }
        entity.fireHurt();
    }

    @Override
    public int tickDelay() {
        return 20;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay() + world.rand.nextInt(5) - world.rand.nextInt(5));
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePos tilePos) {
        world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay() + world.rand.nextInt(5) - world.rand.nextInt(5));
    }

    public boolean canMelt(@NotNull World world, @NotNull TilePos tilePos) {
        boolean canMelt = false;
        for (Direction dir : Direction.directions) {
            Material adjacentMaterial;
            Block<?> block = world.getBlock((TilePos)tilePos.add(dir));
            Material material = adjacentMaterial = block == null ? Material.air : block.getMaterial();
            if (adjacentMaterial == Material.water) {
                return false;
            }
            canMelt |= adjacentMaterial == Material.lava;
        }
        return canMelt;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (this.canMelt(world, tilePos)) {
            world.setBlockIdNotify(tilePos, Blocks.FLUID_LAVA_FLOWING.id());
        }
    }
}

