/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRail;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class BlockLogicRailDetector
extends BlockLogicRail {
    public BlockLogicRailDetector(@NotNull Block<?> block) {
        super(block, true);
        block.setTicking(true);
    }

    @Override
    public int tickDelay() {
        return 20;
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public void onEntityCollision(@NotNull World world, @NotNull TilePos tilePos, @NotNull Entity entity) {
        if (world.isClientSide) {
            return;
        }
        int meta = world.getBlockData(tilePos);
        if ((meta & 8) == 0) {
            this.checkForMinecart(world, tilePos, meta);
        }
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (world.isClientSide) {
            return;
        }
        int meta = world.getBlockData(tilePos);
        if ((meta & 8) != 0) {
            this.checkForMinecart(world, tilePos, meta);
        }
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePos tilePos, @NotNull Side side) {
        return (source.getBlockData(tilePos) & 8) != 0;
    }

    @Override
    public boolean isEmittingDirectSignal(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        if ((world.getBlockData(tilePos) & 8) == 0) {
            return false;
        }
        return side == Side.TOP;
    }

    private void checkForMinecart(@NotNull World world, @NotNull TilePos tilePos, int meta) {
        boolean isPowered = (meta & 8) != 0;
        boolean minecartPresent = false;
        float offset = 0.125f;
        List<EntityMinecart> list = world.getEntitiesWithinAABB(EntityMinecart.class, AABB.fromPool((float)tilePos.x + offset, (float)tilePos.y + offset, (float)tilePos.z + offset, (float)(tilePos.x + 1) - offset, (float)(tilePos.y + 1) - offset, (float)(tilePos.z + 1) - offset));
        if (!list.isEmpty()) {
            minecartPresent = true;
        }
        if (minecartPresent && !isPowered) {
            world.setBlockDataNotify(tilePos, meta | 8);
            world.notifyBlocksOfNeighborChange(tilePos, this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.down(), this.id());
            world.markBlockDirty(tilePos);
        } else if (!minecartPresent && isPowered) {
            world.setBlockDataNotify(tilePos, meta & 0xFFFFFFF7);
            world.notifyBlocksOfNeighborChange(tilePos, this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.down(), this.id());
            world.markBlockDirty(tilePos);
        }
        if (minecartPresent) {
            world.scheduleBlockUpdate(tilePos, this.id(), this.tickDelay());
        }
    }
}

