/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicStairs
extends BlockLogic {
    public static final int MASK_ROTATION_HORIZONTAL = 3;
    public static final int MASK_ROTATION_VERTICAL = 8;
    public static final int H_ROTATION_WEST = 0;
    public static final int H_ROTATION_EAST = 1;
    public static final int H_ROTATION_NORTH = 2;
    public static final int H_ROTATION_SOUTH = 3;
    public static final ISupport[] lowerStairsSupportMapping = new ISupport[]{FullSupport.INSTANCE, FullSupport.INSTANCE, FullSupport.INSTANCE, FullSupport.INSTANCE, PartialSupport.INSTANCE.right(), PartialSupport.INSTANCE.left(), PartialSupport.INSTANCE.down(), PartialSupport.INSTANCE.up(), PartialSupport.INSTANCE.down().right(), PartialSupport.INSTANCE.down().left(), PartialSupport.INSTANCE.down(), FullSupport.INSTANCE, PartialSupport.INSTANCE.down().right(), PartialSupport.INSTANCE.down().left(), FullSupport.INSTANCE, PartialSupport.INSTANCE.down(), PartialSupport.INSTANCE.down(), FullSupport.INSTANCE, PartialSupport.INSTANCE.down().left(), PartialSupport.INSTANCE.down().right(), FullSupport.INSTANCE, PartialSupport.INSTANCE.down(), PartialSupport.INSTANCE.down().left(), PartialSupport.INSTANCE.down().right()};
    public static final ISupport[] upperStairsSupportMapping = new ISupport[]{PartialSupport.INSTANCE.right(), PartialSupport.INSTANCE.left(), PartialSupport.INSTANCE.down(), PartialSupport.INSTANCE.up(), FullSupport.INSTANCE, FullSupport.INSTANCE, FullSupport.INSTANCE, FullSupport.INSTANCE, PartialSupport.INSTANCE.up().right(), PartialSupport.INSTANCE.up().left(), PartialSupport.INSTANCE.up(), FullSupport.INSTANCE, PartialSupport.INSTANCE.up().right(), PartialSupport.INSTANCE.up().left(), FullSupport.INSTANCE, PartialSupport.INSTANCE.up(), PartialSupport.INSTANCE.up(), FullSupport.INSTANCE, PartialSupport.INSTANCE.up().left(), PartialSupport.INSTANCE.up().right(), FullSupport.INSTANCE, PartialSupport.INSTANCE.up(), PartialSupport.INSTANCE.up().left(), PartialSupport.INSTANCE.up().right()};
    @NotNull
    public Block<?> modelBlock;

    public BlockLogicStairs(@NotNull Block<?> block, @NotNull Block<?> modelBlock) {
        super(block, Material.stone);
        this.modelBlock = modelBlock;
        block.withLightBlock(255);
    }

    @Override
    public void initializeBlock() {
        this.block.withHardness(this.modelBlock.blockHardness);
        this.block.withBlastResistance(this.modelBlock.blastResistance / 3.0f);
    }

    @Override
    @NotNull
    public Material getMaterial() {
        return this.modelBlock.getMaterial();
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean canPlaceOnSurfaceOnCondition(@NotNull World world, @NotNull TilePos tilePos) {
        return (world.getBlockData(tilePos) & 8) != 0;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        int meta = world.getBlockData(tilePos);
        int hRot = meta & 3;
        if ((meta & 8) != 0) {
            return upperStairsSupportMapping[side.getId() * 4 + hRot];
        }
        return lowerStairsSupportMapping[side.getId() * 4 + hRot];
    }

    @Override
    public void getCollisionAABBs(@NotNull World world, @NotNull TilePos tilePos, @NotNull AABB aabb, @NotNull @NotNull List<@NotNull AABB> aabbList) {
        int meta = world.getBlockData(tilePos);
        int hRotation = meta & 3;
        int vRotation = meta & 8;
        float stepYOffset = vRotation != 0 ? 0.5f : 0.0f;
        switch (hRotation) {
            case 0: {
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.0, 0.0f + stepYOffset, 0.0, 0.5, 0.5f + stepYOffset, 1.0).move(tilePos), aabbList);
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.5, 0.0, 0.0, 1.0, 1.0, 1.0).move(tilePos), aabbList);
                break;
            }
            case 1: {
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.0, 0.0, 0.0, 0.5, 1.0, 1.0).move(tilePos), aabbList);
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.5, 0.0f + stepYOffset, 0.0, 1.0, 0.5f + stepYOffset, 1.0).move(tilePos), aabbList);
                break;
            }
            case 2: {
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.0, 0.0f + stepYOffset, 0.0, 1.0, 0.5f + stepYOffset, 0.5).move(tilePos), aabbList);
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.0, 0.0, 0.5, 1.0, 1.0, 1.0).move(tilePos), aabbList);
                break;
            }
            default: {
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.0, 0.0, 0.0, 1.0, 1.0, 0.5).move(tilePos), aabbList);
                this.addIntersectingBoundingBox(aabb, AABB.fromPool(0.0, 0.0f + stepYOffset, 0.5, 1.0, 0.5f + stepYOffset, 1.0).move(tilePos), aabbList);
            }
        }
    }

    @Override
    public ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] result;
        if (dropCause != EnumDropCause.IMPROPER_TOOL) {
            ItemStack[] itemStackArray = new ItemStack[1];
            v1 = itemStackArray;
            itemStackArray[0] = new ItemStack(this.block);
        } else {
            v1 = result = null;
        }
        if (result != null) {
            for (ItemStack stack : result) {
                stack.setMetadata(data & 0xF0);
                stack.itemID = this.id();
            }
        }
        return result;
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand) {
        this.modelBlock.animationTick(world, tilePos, rand);
    }

    @Override
    public float getBrightness(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return this.modelBlock.getBrightness(source, tilePos);
    }

    @Override
    public float getBlastResistance(Entity entity) {
        return this.modelBlock.getBlastResistance(entity);
    }

    @Override
    public int tickDelay() {
        return this.modelBlock.tickDelay();
    }

    @Override
    public void onEntityInside(@NotNull World world, @NotNull TilePos tilePos, @NotNull Entity entity, @NotNull Vec3 velocity) {
        this.modelBlock.onEntityInside(world, tilePos, entity, velocity);
    }

    @Override
    public boolean isCollidable() {
        return this.modelBlock.isCollidable();
    }

    @Override
    public boolean canCollideCheck(int data, boolean shouldCollideWithFluids) {
        return this.modelBlock.canCollideCheck(data, shouldCollideWithFluids);
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePos tilePos) {
        return this.modelBlock.canPlaceAt(world, tilePos);
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePos tilePos) {
        this.onNeighborChanged(world, tilePos, 0);
        this.modelBlock.onPlacedByWorld(world, tilePos);
    }

    @Override
    public void onEntityWalkedOn(@NotNull World world, @NotNull TilePos tilePos, @NotNull Entity walker) {
        this.modelBlock.onEntityWalkedOn(world, tilePos, walker);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        this.modelBlock.updateTick(world, tilePos, rand, false);
    }

    @Override
    public void onAttacked(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player, @NotNull Side side, double xHit, double yHit) {
        this.modelBlock.onAttacked(world, tilePos, player, side, xHit, yHit);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        return this.modelBlock.onInteracted(world, tilePos, player, side, xHit, yHit);
    }

    @Override
    public void onDestroyedByExplosion(@NotNull World world, @NotNull TilePos tilePos) {
        this.modelBlock.onDestroyedByExplosion(world, tilePos);
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, Mob mob, double xHit, double yHit) {
        Direction vRotation;
        int meta = world.getBlockData(tilePos) & 0xF0;
        Direction hRotation = mob.getHorizontalPlacementDirection(side).getOpposite();
        if (hRotation == Direction.NORTH) {
            meta |= 2;
        }
        if (hRotation == Direction.EAST) {
            meta |= 1;
        }
        if (hRotation == Direction.SOUTH) {
            meta |= 3;
        }
        if (hRotation == Direction.WEST) {
            meta |= 0;
        }
        if ((vRotation = mob.getVerticalPlacementDirection(side, yHit)) == Direction.UP) {
            meta |= 8;
        }
        world.setBlockDataNotify(tilePos, meta);
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        Side vSide;
        Direction vRotation;
        int meta = world.getBlockData(tilePos) & 0xF0;
        Side hSide = !(side = side.getOpposite()).isHorizontal() ? Side.NORTH : side;
        Direction hRotation = hSide.getOpposite().getDirection();
        if (hRotation == Direction.NORTH) {
            meta |= 2;
        }
        if (hRotation == Direction.EAST) {
            meta |= 1;
        }
        if (hRotation == Direction.SOUTH) {
            meta |= 3;
        }
        if (hRotation == Direction.WEST) {
            meta |= 0;
        }
        if ((vRotation = (vSide = !side.isVertical() ? Side.BOTTOM : side).getDirection()) == Direction.UP) {
            meta |= 8;
        }
        world.setBlockDataNotify(tilePos, meta);
    }

    @Override
    public float getAmbientOcclusionStrength(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return 0.0f;
    }

    @Override
    @NotNull
    public MaterialColor getMaterialColor() {
        return this.modelBlock.getMaterialColor();
    }
}

