/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicStone
extends BlockLogic {
    @NotNull
    private final Block<?> cobble;

    public BlockLogicStone(@NotNull Block<?> block, @NotNull Block<?> cobbleStone, @NotNull Material material) {
        super(block, material);
        this.cobble = cobbleStone;
    }

    @Override
    public void onHarvest(@NotNull World world, @NotNull Player player, @NotNull TilePos tilePos, int data, @Nullable TileEntity tileEntity) {
        super.onHarvest(world, player, tilePos, data, tileEntity);
        if (player.getStat(Blocks.STONE.getStat("stat_mined")) > 0 && player.getStat(Blocks.BASALT.getStat("stat_mined")) > 0 && player.getStat(Blocks.GRANITE.getStat("stat_mined")) > 0 && player.getStat(Blocks.LIMESTONE.getStat("stat_mined")) > 0 && player.getStat(Blocks.PERMAFROST.getStat("stat_mined")) > 0) {
            player.triggerAchievement(Achievements.COLLECT_STONE);
        }
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand) {
        Chunk chunk = world.getChunk(tilePos.toChunkPos());
        if (tilePos.y <= 32 && chunk.getChunkRandom(987234911L).nextInt(10) == 0 && world.getBlockId((TilePos)tilePos.down()) == 0 && rand.nextInt(50) == 0) {
            world.spawnParticle("slimechunk", tilePos.x, tilePos.y, tilePos.z, 0.0, 0.0, 0.0, 0);
        }
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case PISTON_CRUSH: 
            case WORLD: 
            case EXPLOSION: 
            case PROPER_TOOL: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this.cobble);
                break;
            }
            case PICK_BLOCK: 
            case SILK_TOUCH: {
                ItemStack[] itemStackArray3 = new ItemStack[1];
                itemStackArray = itemStackArray3;
                itemStackArray3[0] = new ItemStack(this);
                break;
            }
            default: {
                itemStackArray = null;
            }
        }
        return itemStackArray;
    }
}

