/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.logic;

import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public enum RailDirection {
    NONE(-1, false, false, false, 0, 0, 0, 0, 0, 0),
    STRAIGHT_NS(0, false, true, false, 0, 0, 1, 0, 0, -1),
    STRAIGHT_EW(1, false, true, false, -1, 0, 0, 1, 0, 0),
    SLOPE_E(2, true, false, false, -1, 0, 0, 1, 1, 0),
    SLOPE_W(3, true, false, false, -1, 1, 0, 1, 0, 0),
    SLOPE_N(4, true, false, false, 0, 0, 1, 0, 1, -1),
    SLOPE_S(5, true, false, false, 0, 1, 1, 0, 0, -1),
    TURN_ES(6, false, false, true, 0, 0, 1, 1, 0, 0),
    TURN_WS(7, false, false, true, 0, 0, 1, -1, 0, 0),
    TURN_WN(8, false, false, true, 0, 0, -1, -1, 0, 0),
    TURN_EN(9, false, false, true, 0, 0, -1, 1, 0, 0);

    @NotNull
    private static final @NotNull RailDirection @NotNull [] directionMap;
    public final int meta;
    private final boolean sloped;
    private final boolean straight;
    private final boolean curved;
    private final int offX1;
    private final int offY1;
    private final int offZ1;
    private final int offX2;
    private final int offY2;
    private final int offZ2;

    private RailDirection(int meta, boolean sloped, boolean straight, boolean curved, int offX1, int offY1, int offZ1, int offX2, int offY2, int offZ2) {
        this.meta = meta;
        this.sloped = sloped;
        this.straight = straight;
        this.curved = curved;
        this.offX1 = offX1;
        this.offY1 = offY1;
        this.offZ1 = offZ1;
        this.offX2 = offX2;
        this.offY2 = offY2;
        this.offZ2 = offZ2;
    }

    @NotNull
    public TilePos getNextRail(@NotNull TilePos curPos) {
        return curPos.add(this.offX1, this.offY1, this.offZ1);
    }

    @NotNull
    public TilePos getPrevRail(@NotNull TilePos curPos) {
        return curPos.add(this.offX2, this.offY2, this.offZ2);
    }

    public boolean isSloped() {
        return this.sloped;
    }

    public boolean isStraight() {
        return this.straight;
    }

    public boolean isCurved() {
        return this.curved;
    }

    @NotNull
    public static RailDirection getFromMeta(int meta) {
        if (meta >= 0 && meta < directionMap.length) {
            return directionMap[meta];
        }
        return NONE;
    }

    static {
        directionMap = new RailDirection[RailDirection.TURN_EN.meta + 1];
        RailDirection[] railDirectionArray = RailDirection.values();
        int n = railDirectionArray.length;
        for (int i = 0; i < n; ++i) {
            RailDirection d;
            RailDirection.directionMap[d.meta] = d = railDirectionArray[i];
        }
    }
}

