/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.piston.TileEntityMovingPistonBlock;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicPistonMoving
extends BlockLogic {
    public BlockLogicPistonMoving(Block<?> container) {
        super(container, Material.piston);
        container.withHardness(-1.0f);
        container.withEntity(null);
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePos tilePos, int data) {
        TileEntity tileEntity = world.getTileEntity(tilePos);
        if (tileEntity instanceof TileEntityMovingPistonBlock) {
            TileEntityMovingPistonBlock moving = (TileEntityMovingPistonBlock)tileEntity;
            moving.finalTick();
        } else {
            super.onRemoved(world, tilePos, data);
        }
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePos tilePos) {
        return false;
    }

    @Override
    public boolean canPlaceOnSide(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        if (!world.isClientSide && world.getTileEntity(tilePos) == null) {
            int id = 0;
            TileEntity tileEntity = world.getTileEntity(tilePos);
            if (tileEntity instanceof TileEntityMovingPistonBlock) {
                TileEntityMovingPistonBlock piston = (TileEntityMovingPistonBlock)tileEntity;
                id = piston.getMovedId();
            }
            world.setBlockIdNotify(tilePos, id);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return null;
    }

    @Override
    public void dropWithCause(@NotNull World world, @NotNull EnumDropCause dropCause, @NotNull TilePos tilePos, int data, @Nullable TileEntity tileEntity, @Nullable Player player) {
        TileEntityMovingPistonBlock piston;
        Block<?> b;
        if (world.isClientSide) {
            return;
        }
        TileEntity tileEntity2 = world.getTileEntity(tilePos);
        if (tileEntity2 instanceof TileEntityMovingPistonBlock && (b = Blocks.getBlock((piston = (TileEntityMovingPistonBlock)tileEntity2).getMovedId())) != null) {
            b.dropWithCause(world, EnumDropCause.WORLD, tilePos, data, null, null);
        }
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        if (!world.isClientSide) {
            world.getTileEntity(tilePos);
        }
    }

    public static TileEntity createTileEntity(int movedId, int movedData, @Nullable TileEntity movedEntity, @NotNull Direction direction, boolean extending, boolean isSourcePiston) {
        assert (!(movedEntity instanceof TileEntityMovingPistonBlock)) : "Moving piston entity should not be able to be put into another moving piston!";
        return new TileEntityMovingPistonBlock(movedId, movedData, movedEntity, direction, extending, isSourcePiston);
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        TileEntity tileEntity = source.getTileEntity(tilePos);
        if (tileEntity instanceof TileEntityMovingPistonBlock) {
            TileEntityMovingPistonBlock piston = (TileEntityMovingPistonBlock)tileEntity;
            float progress = piston.getProgress(0.0f);
            if (piston.isExtending()) {
                progress = 1.0f - progress;
            }
            return this.getCollisionShapeFromTileEntity(source, tilePos, piston.getMovedId(), progress, piston.getDirection());
        }
        return null;
    }

    @Override
    @NotNull
    public AABB getBoundsFromState(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        TileEntity tileEntity = source.getTileEntity(tilePos);
        if (tileEntity instanceof TileEntityMovingPistonBlock) {
            TileEntityMovingPistonBlock piston = (TileEntityMovingPistonBlock)tileEntity;
            Block<?> block = Blocks.blocksList[piston.getMovedId()];
            if (block == null || block == this.block) {
                return super.getBoundsFromState(source, tilePos);
            }
            float f = piston.getProgress(0.0f);
            if (piston.isExtending()) {
                f = 1.0f - f;
            }
            Direction direction = piston.getDirection();
            AABB otherBounds = block.getBoundsFromState(source, tilePos);
            return AABB.fromPool(otherBounds.minX - (double)((float)direction.getOffsetX() * f), otherBounds.maxX - (double)((float)direction.getOffsetX() * f), otherBounds.minY - (double)((float)direction.getOffsetY() * f), otherBounds.maxY - (double)((float)direction.getOffsetY() * f), otherBounds.minZ - (double)((float)direction.getOffsetZ() * f), otherBounds.maxZ - (double)((float)direction.getOffsetZ() * f));
        }
        return super.getBoundsFromState(source, tilePos);
    }

    public AABB getCollisionShapeFromTileEntity(@NotNull WorldSource source, @NotNull TilePos tilePos, int blockID, float directionStretch, @NotNull Direction direction) {
        if (blockID == 0 || blockID == this.block.id()) {
            return null;
        }
        AABB aabb = Blocks.blocksList[blockID].getCollisionAABB(source, tilePos);
        if (aabb == null) {
            return null;
        }
        aabb.minX -= (double)((float)direction.getOffsetX() * directionStretch);
        aabb.maxX -= (double)((float)direction.getOffsetX() * directionStretch);
        aabb.minY -= (double)((float)direction.getOffsetY() * directionStretch);
        aabb.maxY -= (double)((float)direction.getOffsetY() * directionStretch);
        aabb.minZ -= (double)((float)direction.getOffsetZ() * directionStretch);
        aabb.maxZ -= (double)((float)direction.getOffsetZ() * directionStretch);
        return aabb;
    }
}

