/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.b100.utils.StringUtils;
import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Global;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.AgedMob;
import net.minecraft.core.entity.ConsumedFood;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.SkinVariantList;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.ItemFood;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Mob
extends Entity {
    public static boolean SPAWN_NO_AI = false;
    public static final int DATA_VARIANT = 1;
    public static final int DATA_HEALTH = 2;
    @NotNull
    protected Map<ItemFood, ConsumedFood> consumedFood = new HashMap<ItemFood, ConsumedFood>();
    public int heartsHalvesLife = 20;
    public float yBodyRot = 0.0f;
    public float yBodyRotO = 0.0f;
    protected float ridingRotUnused;
    protected float prevRidingRotUnused;
    protected float unusedRotation1;
    protected float prevRotationUnused;
    protected int scoreValue = 0;
    public boolean isMultiplayerEntity = false;
    public float prevSwingProgress;
    public float swingProgress;
    public int prevHealth;
    public int bonusHealth;
    public int prevBonusHealth;
    protected int livingSoundTime;
    public int hurtTime;
    public int maxHurtTime;
    public float attackedAtYaw = 0.0f;
    public int deathTime = 0;
    public int attackTime = 0;
    public float prevCameraPitch;
    public float cameraPitch;
    protected boolean dead = false;
    public boolean noAI = false;
    public float walkAnimSpeedO;
    public float walkAnimSpeed;
    public float walkAnimPos;
    protected int newPosRotationIncrements;
    protected double newPosX;
    protected double newPosY;
    protected double newPosZ;
    protected double newRotationYaw;
    protected double newRotationPitch;
    protected int lastDamage = 0;
    protected int entityAge = 0;
    protected float moveStrafing;
    protected float moveForward;
    protected float randomYawVelocity;
    protected boolean isJumping = false;
    protected float defaultPitch = 0.0f;
    protected float moveSpeed = 0.7f;
    protected float noclipSpeed = 0.5f;
    protected float flightSmoothness = 0.5f;
    @Nullable
    private Entity currentTarget = null;
    protected int numTicksToChaseTarget = 0;
    protected double jumpHeight = 0.42;
    @NotNull
    public String nickname = "";
    public byte chatColor = 0;
    protected float lastStrafe = 0.0f;
    @NotNull
    protected String basePath = "/assets/minecraft/textures/entity/char/";
    @NotNull
    protected String defaultTexture = "/assets/minecraft/textures/entity/char/0.png";
    @NotNull
    protected String variantJsonPath = "/assets/minecraft/textures/entity/char/variant.json";
    @NotNull
    protected NamespaceID textureIdentifier = (NamespaceID)NamespaceID.fromPool("minecraft", "char").copyUnpooled();
    public boolean isSkating = false;
    @Nullable
    public Direction rotationLock = null;
    @Nullable
    public Direction rotationLockHorizontal = null;
    @Nullable
    public Direction rotationLockVertical = null;
    @NotNull
    public PlacementMode placementModeOverride = PlacementMode.FACING;
    @NotNull
    public final List<WeightedRandomLootObject> mobDrops = new ArrayList<WeightedRandomLootObject>();

    public Mob(@NotNull World world) {
        super(world);
        this.blocksBuilding = true;
        this.setPos(this.x, this.y, this.z);
        this.yRot = (float)(Math.random() * Math.PI * 2.0);
        this.footSize = 0.5f;
        int variant = this.random.nextInt(255);
        this.entityData.define(1, (byte)variant, Byte.class);
        this.entityData.define(2, this.getMaxHealth(), Integer.class);
        this.setSkinVariant(variant);
        this.speed = 0.1f;
        this.flySpeed = 0.02f;
        this.noAI = SPAWN_NO_AI;
    }

    protected final void setTextureIdentifier(@NotNull String namespace, @NotNull String id) {
        this.textureIdentifier = NamespaceID.getPermanent(namespace, id);
        this.basePath = String.format("/assets/%s/textures/entity/%s/", this.textureIdentifier.namespace(), this.textureIdentifier.value());
        this.defaultTexture = this.basePath + "0.png";
        this.variantJsonPath = this.basePath + "variants.json";
    }

    @Override
    protected void defineSynchedData() {
    }

    public boolean canEntityBeSeen(Entity entity) {
        return this.world.checkBlockCollisionBetweenPoints(Vec3.fromPool(this.x, this.y + (double)this.getHeadHeight(), this.z), Vec3.fromPool(entity.x, entity.y + (double)entity.getHeadHeight(), entity.z)) == null;
    }

    @Override
    @NotNull
    public String getEntityTexture() {
        return this.basePath + this.getTextureReference() + ".png";
    }

    public String getTextureReference() {
        SkinVariantList variantList = Global.accessor.getSkinVariantList();
        return variantList.getSkinReference(this.variantJsonPath, "0", this.getSkinVariant());
    }

    public boolean cycleVariant() {
        int skinVar = this.getSkinVariant();
        this.setSkinVariant(Global.accessor.getSkinVariantList().nextSkinVariant(this.variantJsonPath, skinVar));
        return skinVar != this.getSkinVariant();
    }

    public int getSkinVariant() {
        return Byte.toUnsignedInt(this.entityData.getByte(1));
    }

    public void setSkinVariant(int skinVariant) {
        this.entityData.set(1, (byte)skinVariant);
    }

    @NotNull
    public String getDefaultEntityTexture() {
        return this.defaultTexture;
    }

    @Override
    public boolean isPickable() {
        return !this.removed;
    }

    @Override
    public boolean isPushable() {
        return !this.removed;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    @Override
    public float getHeadHeight() {
        return this.bbHeight * 0.85f;
    }

    public int getAmbientSoundInterval() {
        return 80;
    }

    @NotNull
    public String getDisplayName() {
        return String.valueOf(TextFormatting.get(this.chatColor)) + this.nickname;
    }

    @Override
    public boolean interact(@NotNull Player player) {
        ItemStack item = player.inventory.getCurrentItem();
        if (item != null && item.itemID == Items.LABEL.id && item.hasCustomName()) {
            this.chatColor = item.hasCustomColor() ? item.getCustomColor() : (byte)0;
            this.setNickname(StringUtils.substring(item.getCustomName(), 0, 32));
            return false;
        }
        return false;
    }

    protected void onLabelled() {
    }

    public void setNickname(@NotNull String nickname) {
        this.nickname = nickname;
        this.hadNicknameSet = true;
        this.onLabelled();
    }

    protected float getPitchModifier() {
        if (this instanceof AgedMob) {
            float scale = ((AgedMob)((Object)this)).getMobAge().getAgeScale();
            return 0.8f - scale * 0.8f;
        }
        return 0.0f;
    }

    public void playLivingSound() {
        String s = this.getLivingSound();
        if (s != null && !this.world.isClientSide) {
            this.world.playSoundAtEntity(null, this, s, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f + this.getPitchModifier());
        }
    }

    public void playHurtSound() {
        this.world.playSoundAtEntity(null, this, this.getHurtSound(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f + this.getPitchModifier());
    }

    public void playDeathSound() {
        this.world.playSoundAtEntity(null, this, this.getDeathSound(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f + this.getPitchModifier());
    }

    @Override
    public void baseTick() {
        this.prevSwingProgress = this.swingProgress;
        super.baseTick();
        if (this.random.nextInt(1000) < this.livingSoundTime++) {
            this.livingSoundTime = -this.getAmbientSoundInterval();
            this.playLivingSound();
        }
        if (this.isAlive() && this.isInWall() && !this.noPhysics) {
            this.hurt(null, 1, null);
        }
        if (this.fireImmune || this.world.isClientSide) {
            this.remainingFireTicks = 0;
        }
        this.trySuffocate();
        this.prevCameraPitch = this.cameraPitch;
        if (this.attackTime > 0) {
            --this.attackTime;
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.heartsFlashTime > 0) {
            --this.heartsFlashTime;
        }
        if (this.getHealth() <= 0) {
            ++this.deathTime;
            if (this.deathTime > 20) {
                this.beforeRemove();
                this.remove();
                for (int j = 0; j < 20; ++j) {
                    double motionX = this.random.nextGaussian() * 0.02;
                    double motionY = this.random.nextGaussian() * 0.02;
                    double motionZ = this.random.nextGaussian() * 0.02;
                    this.world.spawnParticle("explode", this.x + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth, this.y + (double)(this.random.nextFloat() * this.bbHeight), this.z + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth, motionX, motionY, motionZ, 0);
                }
            }
        }
        ArrayList<ItemFood> finishedFood = new ArrayList<ItemFood>();
        for (Map.Entry<ItemFood, ConsumedFood> entry : this.consumedFood.entrySet()) {
            entry.getValue().tick();
            if (!entry.getValue().isFinished()) continue;
            finishedFood.add(entry.getKey());
        }
        for (ItemFood food : finishedFood) {
            this.consumedFood.remove(food);
        }
        this.prevRotationUnused = this.unusedRotation1;
        this.yBodyRotO = this.yBodyRot;
        this.yRotO = this.yRot;
        this.xRotO = this.xRot;
    }

    public void trySuffocate() {
        if (this.isAlive() && this.isUnderLiquid(Material.water) && !this.canBreatheUnderwater()) {
            --this.airSupply;
            if (this.airSupply == -20) {
                this.airSupply = 0;
                for (int i = 0; i < 8; ++i) {
                    double offX = this.random.nextFloat() - this.random.nextFloat();
                    double offY = this.random.nextFloat() - this.random.nextFloat();
                    double offZ = this.random.nextFloat() - this.random.nextFloat();
                    this.world.spawnParticle("bubble", this.x + offX, this.y + offY, this.z + offZ, this.xd, this.yd, this.zd, 0);
                }
                this.hurt(null, 2, DamageType.DROWN);
            }
            this.remainingFireTicks = 0;
        } else {
            this.airSupply = this.airMaxSupply;
        }
    }

    public void spawnExplosionParticle() {
        for (int i = 0; i < 20; ++i) {
            double d = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            double d3 = 10.0;
            this.world.spawnParticle("explode", this.x + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth - d * d3, this.y + (double)(this.random.nextFloat() * this.bbHeight) - d1 * d3, this.z + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth - d2 * d3, d, d1, d2, 0);
        }
    }

    @Override
    public void rideTick() {
        super.rideTick();
        this.ridingRotUnused = this.prevRidingRotUnused;
        this.prevRidingRotUnused = 0.0f;
    }

    @Override
    public void lerpTo(double x, double y, double z, float yRot, float xRot, int i) {
        this.heightOffset = 0.0f;
        this.newPosX = x;
        this.newPosY = y;
        this.newPosZ = z;
        this.newRotationYaw = yRot;
        this.newRotationPitch = xRot;
        this.newPosRotationIncrements = i;
    }

    @Override
    public void tick() {
        boolean flag;
        float f5;
        float f4;
        super.tick();
        if (this.noAI) {
            return;
        }
        this.onLivingUpdate();
        double d = this.x - this.xo;
        double d1 = this.z - this.zo;
        float f = MathHelper.sqrt(d * d + d1 * d1);
        float f1 = this.yBodyRot;
        float f2 = 0.0f;
        this.ridingRotUnused = this.prevRidingRotUnused;
        float f3 = 0.0f;
        if (f > 0.05f) {
            f3 = 1.0f;
            f2 = f * 3.0f;
            f1 = (float)Math.atan2(d1, d) * 180.0f / (float)Math.PI - 90.0f;
        }
        if (this.swingProgress > 0.0f) {
            f1 = this.yRot;
        }
        if (!this.onGround) {
            f3 = 0.0f;
        }
        this.prevRidingRotUnused += (f3 - this.prevRidingRotUnused) * 0.3f;
        for (f4 = f1 - this.yBodyRot; f4 < -180.0f; f4 += 360.0f) {
        }
        while (f4 >= 180.0f) {
            f4 -= 360.0f;
        }
        this.yBodyRot += f4 * 0.3f;
        for (f5 = this.yRot - this.yBodyRot; f5 < -180.0f; f5 += 360.0f) {
        }
        while (f5 >= 180.0f) {
            f5 -= 360.0f;
        }
        boolean bl = flag = f5 < -90.0f || f5 >= 90.0f;
        if (f5 < -75.0f) {
            f5 = -75.0f;
        }
        if (f5 >= 75.0f) {
            f5 = 75.0f;
        }
        this.yBodyRot = this.yRot - f5;
        if (f5 * f5 > 2500.0f) {
            this.yBodyRot += f5 * 0.2f;
        }
        if (flag) {
            f2 *= -1.0f;
        }
        while (this.yRot - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.yRot - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO < -180.0f) {
            this.yBodyRotO -= 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO >= 180.0f) {
            this.yBodyRotO += 360.0f;
        }
        while (this.xRot - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.xRot - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        this.unusedRotation1 += f2;
    }

    public void heal(int i) {
        if (this.getHealth() <= 0) {
            return;
        }
        this.setHealthRaw(this.getHealth() + i);
        if (this.getHealth() > this.getMaxHealth()) {
            this.setHealthRaw(this.getMaxHealth());
        }
        this.heartsFlashTime = this.heartsHalvesLife / 2;
    }

    public int getHealth() {
        return this.entityData.getInt(2);
    }

    public void setHealthRaw(int health) {
        this.entityData.set(2, health);
    }

    public int getMaxHealth() {
        return 10;
    }

    public int getTotalHealingRemaining() {
        int totalHealingRemaining = 0;
        for (ConsumedFood value : this.consumedFood.values()) {
            totalHealingRemaining += value.getHealRemaining();
        }
        return totalHealingRemaining;
    }

    public void eatFood(ItemFood food) {
        if (food == null) {
            return;
        }
        if (food.getTicksPerHeal() == 0 || this.world.getGameRuleValue(GameRules.INSTANT_HEALING).booleanValue()) {
            this.heal(food.getHealAmount());
        } else if (this.consumedFood.containsKey(food)) {
            this.consumedFood.get(food).addFood();
        } else {
            this.consumedFood.put(food, new ConsumedFood(this, food));
        }
    }

    @Override
    public boolean hurt(Entity attacker, int damage, DamageType type) {
        if (this.world.isClientSide) {
            return false;
        }
        this.entityAge = 0;
        if (this.getHealth() <= 0) {
            return false;
        }
        this.walkAnimSpeed = 1.5f;
        boolean flag = true;
        if ((float)this.heartsFlashTime > (float)this.heartsHalvesLife / 2.0f) {
            if (damage <= this.lastDamage) {
                return false;
            }
            this.damageEntity(damage - this.lastDamage, type);
            this.lastDamage = damage;
            flag = false;
        } else {
            this.lastDamage = damage;
            this.prevHealth = this.getHealth();
            this.prevBonusHealth = this.bonusHealth;
            this.heartsFlashTime = this.heartsHalvesLife;
            this.damageEntity(damage, type);
            if (damage > 0) {
                this.maxHurtTime = 10;
                this.hurtTime = 10;
            }
        }
        this.attackedAtYaw = 0.0f;
        if (flag) {
            this.markHurt();
            if (attacker != null) {
                double d = attacker.x - this.x;
                double d1 = attacker.z - this.z;
                while (d * d + d1 * d1 < 1.0E-4) {
                    d = (Math.random() - Math.random()) * 0.01;
                    d1 = (Math.random() - Math.random()) * 0.01;
                }
                this.attackedAtYaw = (float)(Math.atan2(d1, d) * 180.0 / Math.PI) - this.yRot;
                this.knockBack(attacker, damage, d, d1);
            } else {
                this.attackedAtYaw = (int)(Math.random() * 2.0) * 180;
            }
            this.world.sendTrackedEntityStatusUpdatePacket(this, (byte)2, this.attackedAtYaw);
        }
        if (this.getHealth() <= 0) {
            if (flag) {
                this.playDeathSound();
            }
            this.onDeath(attacker);
        } else if (flag && damage > 0) {
            this.playHurtSound();
        }
        return true;
    }

    @Override
    public void animateHurt() {
        this.maxHurtTime = 10;
        this.hurtTime = 10;
        this.attackedAtYaw = 0.0f;
    }

    protected void damageEntity(int i, DamageType damageType) {
        this.setHealthRaw(this.getHealth() - i);
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    @Nullable
    public String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return "random.hurt";
    }

    protected String getDeathSound() {
        return "random.hurt";
    }

    public void knockBack(Entity entity, int i, double d, double d1) {
        float f = MathHelper.sqrt(d * d + d1 * d1);
        float f1 = 0.4f;
        this.xd /= 2.0;
        this.yd /= 2.0;
        this.zd /= 2.0;
        this.xd -= d / (double)f * (double)f1;
        this.yd += (double)0.4f;
        this.zd -= d1 / (double)f * (double)f1;
        if (this.yd > (double)0.4f) {
            this.yd = 0.4f;
        }
    }

    public void onDeath(Entity entityKilledBy) {
        if (this.scoreValue >= 0 && entityKilledBy != null) {
            entityKilledBy.awardKillScore(this, this.scoreValue);
        }
        if (entityKilledBy != null) {
            entityKilledBy.killed(this);
        }
        this.dead = true;
        if (!this.world.isClientSide) {
            this.dropDeathItems();
        }
        if (this.vehicle != null) {
            this.vehicle.ejectRider();
            this.vehicle = null;
        }
        this.world.sendTrackedEntityStatusUpdatePacket(this, (byte)3);
        if (this.sendDeathMessage(entityKilledBy)) {
            this.world.sendGlobalMessage(this.getDeathMessage(entityKilledBy));
        }
    }

    public boolean sendDeathMessage(Entity entityKilledBy) {
        return !this.nickname.isEmpty();
    }

    public String getDeathMessage(Entity entityKilledBy) {
        TextFormatting deathMsgColor = TextFormatting.RED;
        TextFormatting reset = TextFormatting.RESET;
        String name = Entity.getNameFromEntity(this, true);
        if (entityKilledBy != null) {
            String murdererName = Entity.getNameFromEntity(entityKilledBy, true);
            return String.format("%s%s was killed by %s%s", name, deathMsgColor, reset, murdererName);
        }
        if (this.world.isMaterialInBB(this.bb, Material.lava)) {
            return String.format("%s%s swam in lava.", name, deathMsgColor);
        }
        if (this.world.getBlockId(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z)) == Blocks.SPIKES.id()) {
            return String.format("%s%s got impaled.", name, deathMsgColor);
        }
        if (this.fallDistance > 0.0f) {
            return String.format("%s%s broke their legs.", name, deathMsgColor);
        }
        if (this.airSupply <= 0) {
            return String.format("%s%s suffocated.", name, deathMsgColor);
        }
        if (this.remainingFireTicks > 0) {
            return String.format("%s%s was incinerated.", name, deathMsgColor);
        }
        return String.format("%s%s died", name, deathMsgColor);
    }

    protected void dropDeathItems() {
        List<WeightedRandomLootObject> drops = this.getMobDrops();
        if (drops != null) {
            for (WeightedRandomLootObject lootObject : drops) {
                ItemStack stack = lootObject.getItemStack();
                if (stack == null) continue;
                for (int i = 0; i < stack.stackSize; ++i) {
                    this.dropItem(new ItemStack(stack.itemID, 1, stack.getMetadata(), stack.getData()), 0.0f);
                }
            }
        }
    }

    protected List<WeightedRandomLootObject> getMobDrops() {
        return this.mobDrops;
    }

    @Override
    protected void causeFallDamage(float distance) {
        super.causeFallDamage(distance);
        int i = (int)Math.ceil(distance - 3.0f);
        if (i > 0) {
            int j;
            if (this.vehicle == null) {
                this.hurt(null, i, DamageType.FALL);
            }
            if ((j = this.world.getBlockId(MathHelper.floor(this.x), MathHelper.floor(this.y - 0.2 - (double)this.heightOffset), MathHelper.floor(this.z))) > 0) {
                this.world.playBlockSoundEffect(this, this.x, this.y - (double)this.heightOffset, this.z, Blocks.blocksList[j], EnumBlockSoundEffectType.ENTITY_LAND);
            }
        }
    }

    public void setFlySpeed(float f) {
        this.noclipSpeed = f;
    }

    public void setFlightSmoothness(float flightSmoothness) {
        this.flightSmoothness = flightSmoothness;
    }

    public boolean canSkate() {
        return false;
    }

    public void moveEntityWithHeading(float moveStrafing, float moveForward) {
        Block<?> floorBlock = this.world.getBlock(MathHelper.floor(this.x), MathHelper.floor(this.bb.minY) - 1, MathHelper.floor(this.z));
        Block<?> floorAboveBlock = this.world.getBlock(MathHelper.floor(this.x), MathHelper.floor(this.bb.minY), MathHelper.floor(this.z));
        this.muteStepSounds = false;
        this.isSkating = false;
        if (this.noPhysics) {
            int vertical = 0;
            if (this.isSneaking()) {
                --vertical;
            }
            if (this.isJumping) {
                ++vertical;
            }
            float adjustedSpeed = this.noclipSpeed;
            float flySpeed = MathHelper.lerp(0.5f, 0.1f, this.flightSmoothness) * 2.0f * adjustedSpeed;
            float verticalFlySpeed = MathHelper.lerp(0.3f, 0.15f, this.flightSmoothness) * 4.0f * (adjustedSpeed > 0.25f ? (adjustedSpeed - 0.25f) * 0.5f + 0.25f : 0.25f);
            this.yd += (double)(verticalFlySpeed * (float)vertical);
            this.moveRelative(moveStrafing, moveForward, flySpeed);
            this.move(this.xd, this.yd, this.zd);
            float mult = MathHelper.lerp(0.5f, 0.91f, this.flightSmoothness);
            float verticalMult = MathHelper.lerp(0.4f, 0.6f, this.flightSmoothness);
            this.xd *= (double)mult;
            this.yd *= (double)verticalMult;
            this.zd *= (double)mult;
        } else if (this.isInWater()) {
            double d = this.y;
            this.moveRelative(moveStrafing, moveForward, 0.02f);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.8;
            this.yd *= 0.8;
            this.zd *= 0.8;
            this.yd -= 0.02;
            int blockX = MathHelper.floor(this.x);
            int blockY = MathHelper.floor(this.y - (double)this.heightOffset);
            int blockZ = MathHelper.floor(this.z);
            Block<?> b = this.world.getBlock(blockX, blockY, blockZ);
            float depth = 0.6f;
            if (b != null) {
                depth = 1.0f - (float)b.getBlockBoundsFromState((WorldSource)this.world, (int)blockX, (int)blockY, (int)blockZ).maxY;
            }
            if (this.horizontalCollision && this.isFree(this.xd, this.yd + (double)depth + 0.2 - this.y + d, this.zd)) {
                this.yd = 0.3;
            }
        } else if (this.isInLava()) {
            double d1 = this.y;
            this.moveRelative(moveStrafing, moveForward, 0.02f);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.5;
            this.yd *= 0.5;
            this.zd *= 0.5;
            this.yd -= 0.02;
            if (this.horizontalCollision && this.isFree(this.xd, this.yd + 0.6 - this.y + d1, this.zd)) {
                this.yd = 0.3;
            }
        } else if (this.canSkate() && BlockTags.SKATEABLE.appliesTo(floorBlock)) {
            this.muteStepSounds = true;
            this.isSkating = true;
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.99;
            this.zd *= 0.99;
            this.yd -= 0.08;
            this.yd *= 0.98;
            double speedSquared = this.xd * this.xd + this.zd * this.zd;
            if (Math.abs(this.xd) < 0.001) {
                this.xd = 0.0;
            }
            if (Math.abs(this.zd) < 0.001) {
                this.zd = 0.0;
            }
            if (this.isSneaking()) {
                this.xd *= 0.8;
                this.zd *= 0.8;
                this.world.playSoundAtEntity(null, this, "random.skate", (float)Math.sqrt(speedSquared) * 2.0f + this.random.nextFloat() * 0.2f - 0.25f, 1.75f + (this.random.nextFloat() * 0.4f - 0.2f));
            }
            if (this.lastStrafe < 0.0f && moveStrafing > 0.0f || this.lastStrafe > 0.0f && moveStrafing < 0.0f) {
                this.moveRelative(moveStrafing * 0.1f, 0.0f, 0.125f);
                float speedBoost = 0.025f;
                float maxSpeed = 0.5f;
                float dx = MathHelper.sin(this.yRot * (float)Math.PI / 180.0f);
                float dz = MathHelper.cos(this.yRot * (float)Math.PI / 180.0f);
                double newMotionX = this.xd - (double)(speedBoost * dx);
                double newMotionZ = this.zd + (double)(speedBoost * dz);
                if (newMotionX * newMotionX + newMotionZ * newMotionZ < (double)(maxSpeed * maxSpeed)) {
                    this.xd = newMotionX;
                    this.zd = newMotionZ;
                }
                this.world.playSoundAtEntity(null, this, "random.skate", (float)Math.sqrt(speedSquared) * 0.75f + this.random.nextFloat() * 0.2f, 2.0f + (this.random.nextFloat() * 0.4f - 0.2f));
            }
            if (moveStrafing != 0.0f) {
                this.lastStrafe = moveStrafing;
            }
        } else {
            float movementScale = 0.91f;
            if (this.onGround) {
                movementScale = 0.5460001f;
                if (BlockTags.OVERRIDE_FRICTION.appliesTo(floorAboveBlock)) {
                    movementScale = floorAboveBlock.friction * 0.91f;
                } else if (floorBlock != null) {
                    movementScale = floorBlock.friction * 0.91f;
                }
            }
            float f3 = 0.1627714f / (movementScale * movementScale * movementScale);
            this.moveRelative(moveStrafing, moveForward, this.onGround ? this.speed * f3 : this.flySpeed);
            if (this.canClimb()) {
                float f4 = 0.15f;
                if (this.xd < (double)(-f4)) {
                    this.xd = -f4;
                }
                if (this.xd > (double)f4) {
                    this.xd = f4;
                }
                if (this.zd < (double)(-f4)) {
                    this.zd = -f4;
                }
                if (this.zd > (double)f4) {
                    this.zd = f4;
                }
                this.fallDistance = 0.0f;
                if (this.yd < -0.25) {
                    this.yd = -0.25;
                }
                if (this.isSneaking() && this.yd < 0.0) {
                    this.yd = 0.0;
                }
            }
            this.move(this.xd, this.yd, this.zd);
            if ((this.horizontalCollision || this.isJumping) && this.canClimb()) {
                this.yd = 0.25;
            }
            if (!this.onGround) {
                movementScale = MathHelper.lerp(movementScale, 1.0f, this.pushTime);
            }
            this.yd -= 0.08;
            this.yd *= 0.98;
            this.xd *= (double)movementScale;
            this.zd *= (double)movementScale;
        }
        this.walkAnimSpeedO = this.walkAnimSpeed;
        double d2 = this.x - this.xo;
        double d3 = this.z - this.zo;
        float f5 = MathHelper.sqrt(d2 * d2 + d3 * d3) * 4.0f;
        if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        this.walkAnimSpeed += (f5 - this.walkAnimSpeed) * 0.4f;
        this.walkAnimPos += this.walkAnimSpeed;
    }

    public boolean canClimb() {
        int k;
        int j;
        int i = MathHelper.floor(this.x);
        Block<?> block = this.world.getBlock(i, j = MathHelper.floor(this.bb.minY), k = MathHelper.floor(this.z));
        return block != null && block.isClimbable(this.world, i, j, k);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        tag.putShort("Health", (short)this.getHealth());
        tag.putShort("HurtTime", (short)this.hurtTime);
        tag.putShort("DeathTime", (short)this.deathTime);
        tag.putShort("AttackTime", (short)this.attackTime);
        tag.putString("Nickname", this.nickname);
        tag.putByte("ChatColor", this.chatColor);
        tag.putByte("SkinVariant", this.entityData.getByte(1));
        tag.putBoolean("noAI", this.noAI);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        this.setHealthRaw(tag.getShort("Health"));
        if (!tag.containsKey("Health")) {
            this.setHealthRaw(this.getMaxHealth());
        }
        this.hurtTime = tag.getShort("HurtTime");
        this.deathTime = tag.getShort("DeathTime");
        this.attackTime = tag.getShort("AttackTime");
        this.nickname = StringUtils.substring(tag.getString("Nickname"), 0, 32);
        this.chatColor = tag.getByte("ChatColor");
        this.setSkinVariant(tag.getByte("SkinVariant"));
        this.noAI = tag.getBoolean("noAI");
    }

    @Override
    public boolean isAlive() {
        return !this.removed && this.getHealth() > 0;
    }

    public boolean canBreatheUnderwater() {
        return false;
    }

    public void onLivingUpdate() {
        if (this.newPosRotationIncrements > 0) {
            double d3;
            double d = this.x + (this.newPosX - this.x) / (double)this.newPosRotationIncrements;
            double d1 = this.y + (this.newPosY - this.y) / (double)this.newPosRotationIncrements;
            double d2 = this.z + (this.newPosZ - this.z) / (double)this.newPosRotationIncrements;
            for (d3 = this.newRotationYaw - (double)this.yRot; d3 < -180.0; d3 += 360.0) {
            }
            while (d3 >= 180.0) {
                d3 -= 360.0;
            }
            this.yRot = (float)((double)this.yRot + d3 / (double)this.newPosRotationIncrements);
            this.xRot = (float)((double)this.xRot + (this.newRotationPitch - (double)this.xRot) / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.setPos(d, d1, d2);
            this.setRot(this.yRot, this.xRot);
            List<AABB> list1 = this.world.getCubes(this, this.bb.getInsetBoundingBox(0.03125, 0.0, 0.03125));
            if (!list1.isEmpty()) {
                double d4 = 0.0;
                for (int j = 0; j < list1.size(); ++j) {
                    AABB aabb = list1.get(j);
                    if (!(aabb.maxY > d4)) continue;
                    d4 = aabb.maxY;
                }
                this.setPos(d, d1 += d4 - this.bb.minY, d2);
            }
        }
        if (this.isMovementBlocked()) {
            this.isJumping = false;
            this.moveStrafing = 0.0f;
            this.moveForward = 0.0f;
            this.randomYawVelocity = 0.0f;
        } else if (!this.isMultiplayerEntity) {
            this.updateAI();
        }
        boolean inWater = this.isInWater();
        boolean inLava = this.isInLava();
        if (this.isJumping) {
            if (inWater) {
                this.yd += 0.04;
            } else if (inLava) {
                this.yd += 0.04;
            } else if (this.onGround) {
                this.jump();
            }
        }
        this.moveStrafing *= 0.98f;
        this.moveForward *= 0.98f;
        this.randomYawVelocity *= 0.9f;
        this.moveEntityWithHeading(this.moveStrafing, this.moveForward);
        List<Entity> list = this.world.getEntitiesWithinAABBExcludingEntity(this, this.bb.grow(0.2, 0.0, 0.2));
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = list.get(i);
                if (!entity.isPushable()) continue;
                entity.push(this);
            }
        }
    }

    protected boolean isMovementBlocked() {
        return this.getHealth() <= 0;
    }

    protected void jump() {
        if (this.noPhysics) {
            return;
        }
        this.yd = this.jumpHeight;
        if (this.isSprinting()) {
            float f = this.yRot * 0.01745329f;
            this.xd -= (double)(MathHelper.sin(f) * 0.2f);
            this.zd += (double)(MathHelper.cos(f) * 0.2f);
        }
    }

    protected boolean canDespawn() {
        return this.nickname.isEmpty();
    }

    public void tryToDespawn() {
        Player entityplayer = this.world.getClosestPlayerToEntity(this, -1.0);
        if (this.canDespawn() && entityplayer != null) {
            double d = entityplayer.x - this.x;
            double d1 = entityplayer.y - this.y;
            double d2 = entityplayer.z - this.z;
            double d3 = d * d + d1 * d1 + d2 * d2;
            if (d3 > 16384.0) {
                this.remove();
            }
            if (this.entityAge > 600 && this.random.nextInt(800) == 0) {
                if (d3 < 1024.0) {
                    this.entityAge = 0;
                } else {
                    this.remove();
                }
            }
        }
    }

    protected void updateAI() {
        ++this.entityAge;
        this.tryToDespawn();
        this.moveStrafing = 0.0f;
        this.moveForward = 0.0f;
        float f = 8.0f;
        if (this.random.nextFloat() < 0.02f) {
            Player entityplayer1 = this.world.getClosestPlayerToEntity(this, f);
            if (entityplayer1 != null) {
                this.currentTarget = entityplayer1;
                this.numTicksToChaseTarget = 10 + this.random.nextInt(20);
            } else {
                this.randomYawVelocity = (this.random.nextFloat() - 0.5f) * 20.0f;
            }
        }
        if (this.currentTarget != null) {
            this.lookAt(this.currentTarget, 10.0f, this.getLookingTilt());
            if (this.numTicksToChaseTarget-- <= 0 || this.currentTarget.removed || this.currentTarget.distanceToSqr(this) > (double)(f * f)) {
                this.currentTarget = null;
            }
        } else {
            if (this.random.nextFloat() < 0.05f) {
                this.randomYawVelocity = (this.random.nextFloat() - 0.5f) * 20.0f;
            }
            this.yRot += this.randomYawVelocity;
            this.xRot = this.defaultPitch;
        }
        boolean inWater = this.isInWater();
        boolean inLava = this.isInLava();
        if (inWater || inLava) {
            this.isJumping = this.random.nextFloat() < 0.8f;
        }
    }

    protected int getLookingTilt() {
        return 40;
    }

    public void lookAt(Entity entity, float yRot, float xRot) {
        double y2;
        double x = entity.x - this.x;
        double y = entity.z - this.z;
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            y2 = mob.y + (double)mob.getHeadHeight() - (this.y + (double)this.getHeadHeight());
        } else {
            y2 = (entity.bb.minY + entity.bb.maxY) / 2.0 - (this.y + (double)this.getHeadHeight());
        }
        double d3 = MathHelper.sqrt(x * x + y * y);
        float f2 = (float)(Math.atan2(y, x) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(-y2, d3) * 180.0 / Math.PI));
        this.xRot = -this.rotationLerp(this.xRot, f3, xRot);
        this.yRot = this.rotationLerp(this.yRot, f2, yRot);
    }

    public boolean hasCurrentTarget() {
        return this.currentTarget != null;
    }

    public Entity getCurrentTarget() {
        return this.currentTarget;
    }

    private float rotationLerp(float f, float f1, float f2) {
        float f3;
        for (f3 = f1 - f; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        return f + f3;
    }

    public void beforeRemove() {
    }

    public boolean canSpawnHere() {
        int blockZ;
        int blockY;
        int blockX = MathHelper.floor(this.x);
        if (Blocks.hasTag(this.world.getBlockId(blockX, blockY = MathHelper.floor(this.bb.minY), blockZ = MathHelper.floor(this.z)), BlockTags.PREVENT_MOB_SPAWNS)) {
            return false;
        }
        return this.world.checkIfAABBIsClear(this.bb) && this.world.getCubes(this, this.bb).size() == 0 && !this.world.getIsAnyLiquid(this.bb);
    }

    @Override
    public void outOfWorld() {
        this.hurt(null, 4, null);
    }

    public float getSwingProgress(float partialTick) {
        float f1 = this.swingProgress - this.prevSwingProgress;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.prevSwingProgress + f1 * partialTick;
    }

    public Vec3 getPosition(float partialTick, boolean headOffset) {
        if (partialTick == 1.0f || this.isRemoved()) {
            return Vec3.fromPool(this.x, this.y + (double)(headOffset ? this.getHeadHeight() : 0.0f), this.z);
        }
        double x = MathHelper.lerp(this.xo, this.x, (double)partialTick);
        double y = MathHelper.lerp(this.yo, this.y, (double)partialTick);
        double z = MathHelper.lerp(this.zo, this.z, (double)partialTick);
        return Vec3.fromPool(x, y + (double)(headOffset ? this.getHeadHeight() : 0.0f), z);
    }

    @Override
    public Vec3 getViewVector(float partialTick) {
        if (partialTick == 1.0f || this.isRemoved()) {
            float z = MathHelper.cos(-this.yRot * ((float)Math.PI / 180) - (float)Math.PI);
            float x = MathHelper.sin(-this.yRot * ((float)Math.PI / 180) - (float)Math.PI);
            float xzLen = -MathHelper.cos(-this.xRot * ((float)Math.PI / 180));
            float y = MathHelper.sin(-this.xRot * ((float)Math.PI / 180));
            return Vec3.fromPool(x * xzLen, y, z * xzLen);
        }
        float pitch = this.xRotO + (this.xRot - this.xRotO) * partialTick;
        float yaw = this.yRotO + (this.yRot - this.yRotO) * partialTick;
        float xzLen = -MathHelper.cos(-pitch * ((float)Math.PI / 180));
        float x = MathHelper.sin(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float y = MathHelper.sin(-pitch * ((float)Math.PI / 180));
        float z = MathHelper.cos(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        return Vec3.fromPool(x * xzLen, y, z * xzLen);
    }

    @Nullable
    public HitResult rayCast(double distance, float partialTick, boolean collideWithFluids, boolean ignoreNonColliderBlocks, boolean useSelectorBoxes) {
        Vec3 head = this.getPosition(partialTick, true);
        Vec3 viewDirection = this.getViewVector(partialTick);
        Vec3 furthestPoint = head.add(viewDirection.x * distance, viewDirection.y * distance, viewDirection.z * distance);
        return this.world.checkBlockCollisionBetweenPoints(head, furthestPoint, collideWithFluids, ignoreNonColliderBlocks, useSelectorBoxes);
    }

    public int getMaxSpawnedInChunk() {
        return 4;
    }

    @Override
    public void handleEntityEvent(byte byte0, float attackedAtYaw) {
        if (byte0 == 2) {
            this.walkAnimSpeed = 1.5f;
            this.heartsFlashTime = this.heartsHalvesLife;
            this.maxHurtTime = 10;
            this.hurtTime = 10;
            this.attackedAtYaw = attackedAtYaw;
            this.hurt(null, 0, null);
        } else if (byte0 == 3) {
            this.setHealthRaw(0);
            this.onDeath(null);
        } else {
            super.handleEntityEvent(byte0, attackedAtYaw);
        }
    }

    public boolean isPlayerSleeping() {
        return false;
    }

    @NotNull
    public Direction getHorizontalPlacementDirection(Side side) {
        return this.getHorizontalPlacementDirection(side, PlacementMode.FACING);
    }

    @NotNull
    public Direction getHorizontalPlacementDirection(Side side, PlacementMode mode) {
        if (this.rotationLockHorizontal != null && this.rotationLockHorizontal != Direction.NONE) {
            return this.rotationLockHorizontal;
        }
        if (this.placementModeOverride != PlacementMode.DEFAULT) {
            mode = this.placementModeOverride;
        }
        if (mode == PlacementMode.SIDE && side != null && side.isHorizontal()) {
            return side.getDirection().getOpposite();
        }
        return Direction.getHorizontalDirection(this);
    }

    @NotNull
    public Direction getPlacementDirection(@NotNull Side side) {
        return this.getPlacementDirection(side, PlacementMode.FACING);
    }

    @NotNull
    public Direction getPlacementDirection(@Nullable Side side, @NotNull PlacementMode mode) {
        if (this.rotationLock != null && this.rotationLock != Direction.NONE) {
            return this.rotationLock;
        }
        if (this.placementModeOverride != PlacementMode.DEFAULT) {
            mode = this.placementModeOverride;
        }
        if (mode == PlacementMode.SIDE && side != null) {
            return side.getDirection();
        }
        return Direction.getDirection(this);
    }

    public Direction getVerticalPlacementDirection(Side side, double sideHeight) {
        return this.getVerticalPlacementDirection(side, sideHeight, PlacementMode.SIDE);
    }

    public Direction getVerticalPlacementDirection(Side side, double sideHeight, PlacementMode mode) {
        if (this.rotationLockVertical != null && this.rotationLockVertical != Direction.NONE) {
            return this.rotationLockVertical;
        }
        if (this.placementModeOverride != PlacementMode.DEFAULT) {
            mode = this.placementModeOverride;
        }
        if (mode == PlacementMode.SIDE) {
            if (side.isVertical()) {
                return side.getDirection().getOpposite();
            }
            return sideHeight > 0.5 ? Direction.UP : Direction.DOWN;
        }
        return this.xRot < 0.0f ? Direction.UP : Direction.DOWN;
    }
}

