/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import com.b100.utils.StringUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemLabel
extends Item {
    protected ItemLabel(@NotNull String name, @NotNull String namespaceId, int id) {
        super(name, namespaceId, id);
        this.setMaxStackSize(1);
    }

    @Override
    @Nullable
    public ItemStack onUse(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        if (selfStack.hasCustomName()) {
            return selfStack;
        }
        int slot = -1;
        for (int i = 0; i < player.inventory.mainInventory.length; ++i) {
            if (player.inventory.mainInventory[i] != selfStack) continue;
            slot = i;
            break;
        }
        if (slot != -1) {
            player.displayLabelEditorScreen(selfStack, slot);
        }
        return selfStack;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePos blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        String customName = selfStack.getCustomName();
        if (customName == null) {
            return;
        }
        blockPos = (TilePos)blockPos.add(direction);
        AABB box = AABB.fromPool(blockPos.x, blockPos.y, blockPos.z, blockPos.x + 1, blockPos.y + 1, blockPos.z + 1);
        List<Entity> entities = world.getEntitiesWithinAABBExcludingEntity(null, box);
        for (Entity entity : entities) {
            if (entity instanceof Player || !(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            if (entity.hadNicknameSet) continue;
            if (selfStack.hasCustomColor()) {
                mob.chatColor = selfStack.getCustomColor();
            }
            mob.setNickname(StringUtils.substring(customName, 0, 32));
            break;
        }
    }
}

