/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStatue
extends Item {
    @NotNull
    protected final Block<?> statueBlockBottom;
    @NotNull
    protected final Block<?> statueBlockTop;

    public ItemStatue(@NotNull String name, @NotNull String namespaceId, int id, @NotNull Block<?> statueBlockBottom, @NotNull Block<?> statueBlockTop) {
        super(name, namespaceId, id);
        this.maxStackSize = 64;
        this.statueBlockBottom = statueBlockBottom;
        this.statueBlockTop = statueBlockTop;
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePos blockPos, @NotNull Side side, double xHit, double yHit) {
        if (!world.canPlaceInsideBlock(blockPos)) {
            blockPos = (TilePos)blockPos.add(side.getDirection());
        }
        if (!this.statueBlockBottom.canPlaceAt(world, blockPos)) {
            return false;
        }
        world.noNeighborUpdate = true;
        world.setBlockIdDataNotify(blockPos, this.statueBlockBottom.id(), MathHelper.floor((double)((player.yRot + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF);
        world.setBlockIdDataNotify((TilePos)blockPos.up(), this.statueBlockTop.id(), MathHelper.floor((double)((player.yRot + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF);
        world.noNeighborUpdate = false;
        world.notifyBlocksOfNeighborChange(blockPos, this.statueBlockBottom.id());
        world.notifyBlocksOfNeighborChange((TilePos)blockPos.up(), this.statueBlockTop.id());
        world.playBlockSoundEffect(player, (float)blockPos.x + 0.5f, (float)blockPos.y + 0.5f, (float)blockPos.z + 0.5f, this.statueBlockBottom, EnumBlockSoundEffectType.PLACE);
        this.statueBlockBottom.onPlacedByMob(world, blockPos, side, player, xHit, yHit);
        this.statueBlockTop.onPlacedByMob(world, (TilePos)blockPos.up(), side, player, xHit, yHit);
        selfStack.consumeItem(player);
        return true;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePos blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        if (!world.canPlaceInsideBlock(blockPos)) {
            blockPos = (TilePos)blockPos.add(direction);
        }
        if (!this.statueBlockBottom.canPlaceAt(world, blockPos)) {
            return;
        }
        world.noNeighborUpdate = true;
        world.setBlockIdNotify(blockPos, this.statueBlockBottom.id());
        world.setBlockIdNotify((TilePos)blockPos.up(), this.statueBlockTop.id());
        world.noNeighborUpdate = false;
        world.notifyBlocksOfNeighborChange(blockPos, this.statueBlockBottom.id());
        world.notifyBlocksOfNeighborChange((TilePos)blockPos.up(), this.statueBlockTop.id());
        world.playBlockSoundEffect(null, (float)blockPos.x + 0.5f, (float)blockPos.y + 0.5f, (float)blockPos.z + 0.5f, this.statueBlockBottom, EnumBlockSoundEffectType.PLACE);
        this.statueBlockBottom.onPlacedOnSide(world, blockPos, direction.getSide(), 0.5, 0.5);
        this.statueBlockTop.onPlacedOnSide(world, (TilePos)blockPos.up(), direction.getSide(), 0.5, 0.5);
        selfStack.consumeItem(null);
    }
}

