/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.EmptyChunk;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.ChunkTilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayChunk
extends EmptyChunk {
    public static int displayBlockId = 0;
    public static int displayBlockMeta = 0;
    public static int displayBlockPosX = 0;
    public static int displayBlockPosY = 0;
    public static int displayBlockPosZ = 0;
    @Nullable
    public static TileEntity displayTileEntity = null;

    public DisplayChunk(@NotNull World world, @NotNull ChunkPos chunkPos) {
        super(world, chunkPos);
    }

    @Deprecated
    public DisplayChunk(@NotNull World world, int x, int z) {
        this(world, new ChunkPos(x, z));
    }

    @Override
    public int getBlockId(@NotNull ChunkTilePos tilePos) {
        if (tilePos.x == displayBlockPosX && tilePos.y == displayBlockPosY && tilePos.z == displayBlockPosZ) {
            return displayBlockId;
        }
        return 0;
    }

    @Override
    public int getBlockData(@NotNull ChunkTilePos tilePos) {
        if (tilePos.x == displayBlockPosX && tilePos.y == displayBlockPosY && tilePos.z == displayBlockPosZ) {
            return displayBlockMeta;
        }
        return 0;
    }

    @Override
    public int getBrightness(@NotNull LightLayer lightLayer, @NotNull ChunkTilePos tilePos) {
        return 15;
    }

    @Override
    public boolean setTileEntity(@NotNull ChunkTilePos tilePos, @NotNull TileEntity tileEntity) {
        if (tilePos.x == displayBlockPosX && tilePos.y == displayBlockPosY && tilePos.z == displayBlockPosZ) {
            displayTileEntity = tileEntity;
            DisplayChunk.displayTileEntity.worldObj = this.world;
            DisplayChunk.displayTileEntity.x = tilePos.x;
            DisplayChunk.displayTileEntity.y = tilePos.y;
            DisplayChunk.displayTileEntity.z = tilePos.z;
        }
        return true;
    }

    @Override
    public void removeTileEntity(@NotNull ChunkTilePos tilePos) {
        if (tilePos.x == displayBlockPosX && tilePos.y == displayBlockPosY && tilePos.z == displayBlockPosZ) {
            displayTileEntity = null;
        }
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(@NotNull ChunkTilePos tilePos) {
        if (tilePos.x == displayBlockPosX && tilePos.y == displayBlockPosY && tilePos.z == displayBlockPosZ) {
            return displayTileEntity;
        }
        return null;
    }

    public static void setDisplayTileEntity(World world, TileEntity entity) {
        displayTileEntity = entity;
        if (displayTileEntity != null) {
            DisplayChunk.displayTileEntity.worldObj = world;
            DisplayChunk.displayTileEntity.x = displayBlockPosX;
            DisplayChunk.displayTileEntity.y = displayBlockPosY;
            DisplayChunk.displayTileEntity.z = displayBlockPosZ;
        }
    }

    @Override
    public double getBlockHumidity(@NotNull ChunkTilePos tilePos) {
        return 0.5;
    }

    @Override
    public double getBlockTemperature(@NotNull ChunkTilePos tilePos) {
        return 0.5;
    }

    @Override
    public double getBlockVariety(@NotNull ChunkTilePos tilePos) {
        return 0.5;
    }
}

