/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk.provider;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.pos.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ChunkProviderThreaded
implements IChunkProvider {
    protected static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    protected static final ChunkPos MIN_POS = new ChunkPos(Integer.MIN_VALUE, Integer.MIN_VALUE);
    @NotNull
    protected final Chunk empty;
    @NotNull
    protected final World world;
    @NotNull
    protected final IChunkLoader chunkLoader;
    @NotNull
    protected final ChunkGenerator chunkGenerator;
    @NotNull
    protected final ChunkGenThread genThread;
    @NotNull
    protected final @NotNull Map<@NotNull ChunkPos, @NotNull Chunk> loadedChunks = new Object2ObjectOpenHashMap<ChunkPos, Chunk>();
    @NotNull
    protected final @NotNull Map<@NotNull ChunkPos, @NotNull Chunk> preparedUndecoratedChunks = new Object2ObjectOpenHashMap<ChunkPos, Chunk>();
    @NotNull
    protected final @NotNull Set<@NotNull Chunk> positionsToCheckIfCanDecorate = new ObjectOpenHashSet<Chunk>();
    @NotNull
    protected final @NotNull Set<@NotNull Chunk> positionsToCheckIfCanDecorateCopy = new ObjectOpenHashSet<Chunk>();
    @Nullable
    protected ChunkPos chunkOver;
    @NotNull
    protected Chunk lastQueriedChunk;
    @NotNull
    protected ChunkPos lastQueriedChunkPos = MIN_POS;
    protected int tickCount = 0;

    public ChunkProviderThreaded(@NotNull World world, @NotNull IChunkLoader chunkLoader, @NotNull ChunkGenerator chunkGenerator) {
        this.world = world;
        this.chunkLoader = chunkLoader;
        this.chunkGenerator = chunkGenerator;
        this.lastQueriedChunk = this.empty = new Chunk(world, new ChunkPos(0, 0));
        this.genThread = new ChunkGenThread(this);
        this.genThread.setName("Chunk Gen Thread");
        this.genThread.setDaemon(true);
        this.genThread.setPriority(Math.max(Thread.currentThread().getPriority() - 1, 1));
        this.genThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChunkLoaded(@NotNull ChunkPos chunkPos) {
        boolean isLoaded;
        if (chunkPos.equals(this.lastQueriedChunkPos)) {
            return true;
        }
        Map<ChunkPos, Chunk> map = this.loadedChunks;
        synchronized (map) {
            isLoaded = this.loadedChunks.containsKey(chunkPos);
        }
        if (isLoaded) {
            this.lastQueriedChunkPos = new ChunkPos(chunkPos);
            this.lastQueriedChunk = this.loadedChunks.get(chunkPos);
        }
        return isLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Chunk provideChunk(@NotNull ChunkPos chunkPos, boolean priority) {
        Chunk chunk;
        if (chunkPos.equals(this.lastQueriedChunkPos)) {
            return this.lastQueriedChunk;
        }
        Map<ChunkPos, Chunk> map = this.loadedChunks;
        synchronized (map) {
            chunk = this.loadedChunks.get(chunkPos);
        }
        if (chunk != null) {
            this.lastQueriedChunkPos = chunkPos;
            this.lastQueriedChunk = chunk;
            if (!chunk.isTerrainPopulated) {
                this.handleDecoration(chunk);
            }
            return chunk;
        }
        if (this.isChunkValid(chunkPos) || this.world.findingSpawnPoint) {
            if (priority || this.world.findingSpawnPoint) {
                Chunk c = this.loadChunk(chunkPos);
                this.addChunk(c);
                return c;
            }
            this.genThread.queueChunk(chunkPos);
        }
        return this.empty;
    }

    @Override
    @NotNull
    public Chunk prepareChunk(@NotNull ChunkPos chunkPos, boolean priority) {
        return this.provideChunk(chunkPos, priority);
    }

    @Override
    public void regenerateChunk(@NotNull ChunkPos chunkPos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void populate(@NotNull ChunkPos chunkPos) {
        Chunk chunk = this.provideChunk(chunkPos, true);
        this.decorate(chunk);
    }

    public void decorate(@NotNull Chunk chunk) {
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            this.chunkGenerator.decorate(chunk);
            chunk.setChunkModified();
            if (this.world.getCurrentWeather() != null) {
                this.world.getCurrentWeather().doChunkLoadEffect(this.world, chunk);
            }
        }
    }

    @Override
    public void setCurrentChunkOver(@NotNull ChunkPos chunkPos) {
        this.chunkOver = chunkPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveChunks(boolean saveImmediately, @Nullable ProgressListener progressListener) {
        Map<ChunkPos, Chunk> map = this.loadedChunks;
        synchronized (map) {
            Collection<Chunk> chunks = this.loadedChunks.values();
            int totalNeedSaving = 0;
            for (Chunk chunk : chunks) {
                if (!chunk.needsSaving(saveImmediately)) continue;
                ++totalNeedSaving;
            }
            int chunksSaved = 0;
            for (Chunk chunk : chunks) {
                if (!chunk.needsSaving(saveImmediately)) continue;
                this.saveChunk(chunk);
                if (++chunksSaved > 6 && !saveImmediately) {
                    return false;
                }
                if (progressListener == null || chunksSaved % 10 != 0) continue;
                progressListener.progressStagePercentage(chunksSaved * 100 / totalNeedSaving);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tick() {
        ++this.tickCount;
        Object object = this.preparedUndecoratedChunks;
        synchronized (object) {
            if (!this.preparedUndecoratedChunks.isEmpty()) {
                int count = 0;
                Iterator<Chunk> iterator2 = this.preparedUndecoratedChunks.values().iterator();
                while (iterator2.hasNext()) {
                    Chunk chunk = iterator2.next();
                    this.addChunk(chunk);
                    iterator2.remove();
                    if (count++ <= 4) continue;
                    break;
                }
            }
        }
        object = this.positionsToCheckIfCanDecorate;
        synchronized (object) {
            Set<Chunk> count = this.positionsToCheckIfCanDecorateCopy;
            synchronized (count) {
                this.positionsToCheckIfCanDecorateCopy.clear();
                this.positionsToCheckIfCanDecorateCopy.addAll(this.positionsToCheckIfCanDecorate);
                this.positionsToCheckIfCanDecorate.clear();
            }
        }
        object = this.positionsToCheckIfCanDecorateCopy;
        synchronized (object) {
            if (!this.positionsToCheckIfCanDecorateCopy.isEmpty()) {
                for (Chunk chunk : this.positionsToCheckIfCanDecorateCopy) {
                    this.handleDecoration(chunk);
                }
                this.positionsToCheckIfCanDecorateCopy.clear();
            }
        }
        object = this.loadedChunks;
        synchronized (object) {
            Iterator<Map.Entry<ChunkPos, Chunk>> itr = this.loadedChunks.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<ChunkPos, Chunk> entry = itr.next();
                ChunkPos pos = entry.getKey();
                Chunk chunk = entry.getValue();
                if (this.isChunkValid(pos)) continue;
                this.saveChunk(chunk);
                chunk.onUnload();
                itr.remove();
                if (!this.lastQueriedChunkPos.equals(pos)) continue;
                this.lastQueriedChunkPos = MIN_POS;
                this.lastQueriedChunk = this.empty;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChunk(@NotNull Chunk chunk) {
        Map<ChunkPos, Chunk> map = this.loadedChunks;
        synchronized (map) {
            if (this.loadedChunks.containsKey(chunk.pos)) {
                return;
            }
            this.loadedChunks.put(chunk.pos, chunk);
        }
        chunk.checkForLightGaps();
        chunk.lastSaveTime = this.world.getWorldTime();
        chunk.onLoad();
        if (!chunk.isTerrainPopulated) {
            this.handleDecoration(chunk);
        }
        this.checkForNeighborDecorations(chunk.pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleDecoration(@NotNull Chunk chunk) {
        ChunkPos pos = chunk.pos;
        if (!chunk.isTerrainPopulated && this.isChunkValid(pos)) {
            Map<ChunkPos, Chunk> map = this.loadedChunks;
            synchronized (map) {
                ChunkPos northPos = pos.add(0, -1);
                ChunkPos northEastPos = pos.add(1, -1);
                ChunkPos eastPos = pos.add(1, 0);
                ChunkPos southEastPos = pos.add(1, 1);
                ChunkPos southPos = pos.add(0, 1);
                ChunkPos southWestPos = pos.add(-1, 1);
                ChunkPos westPos = pos.add(-1, 0);
                ChunkPos northWestPos = pos.add(-1, -1);
                boolean northLoaded = this.loadedChunks.containsKey(northPos);
                boolean northEastLoaded = this.loadedChunks.containsKey(northEastPos);
                boolean eastLoaded = this.loadedChunks.containsKey(eastPos);
                boolean southEastLoaded = this.loadedChunks.containsKey(southEastPos);
                boolean southLoaded = this.loadedChunks.containsKey(southPos);
                boolean southWestLoaded = this.loadedChunks.containsKey(southWestPos);
                boolean westLoaded = this.loadedChunks.containsKey(westPos);
                boolean northWestLoaded = this.loadedChunks.containsKey(northWestPos);
                if (northLoaded && northEastLoaded && eastLoaded && southEastLoaded && southLoaded && southWestLoaded && westLoaded && northWestLoaded) {
                    this.decorate(chunk);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForNeighborDecorations(@NotNull ChunkPos chunkPos) {
        ChunkPos northPos = chunkPos.add(0, -1);
        ChunkPos northEastPos = chunkPos.add(1, -1);
        ChunkPos eastPos = chunkPos.add(1, 0);
        ChunkPos southEastPos = chunkPos.add(1, 1);
        ChunkPos southPos = chunkPos.add(0, 1);
        ChunkPos southWestPos = chunkPos.add(-1, 1);
        ChunkPos westPos = chunkPos.add(-1, 0);
        ChunkPos northWestPos = chunkPos.add(-1, -1);
        Set<Chunk> set = this.positionsToCheckIfCanDecorate;
        synchronized (set) {
            Chunk c = this.loadedChunks.get(northPos);
            if (c != null && !c.isTerrainPopulated) {
                this.positionsToCheckIfCanDecorate.add(c);
            }
            if ((c = this.loadedChunks.get(northEastPos)) != null && !c.isTerrainPopulated) {
                this.positionsToCheckIfCanDecorate.add(c);
            }
            if ((c = this.loadedChunks.get(eastPos)) != null && !c.isTerrainPopulated) {
                this.positionsToCheckIfCanDecorate.add(c);
            }
            if ((c = this.loadedChunks.get(southEastPos)) != null && !c.isTerrainPopulated) {
                this.positionsToCheckIfCanDecorate.add(c);
            }
            if ((c = this.loadedChunks.get(southPos)) != null && !c.isTerrainPopulated) {
                this.positionsToCheckIfCanDecorate.add(c);
            }
            if ((c = this.loadedChunks.get(southWestPos)) != null && !c.isTerrainPopulated) {
                this.positionsToCheckIfCanDecorate.add(c);
            }
            if ((c = this.loadedChunks.get(westPos)) != null && !c.isTerrainPopulated) {
                this.positionsToCheckIfCanDecorate.add(c);
            }
            if ((c = this.loadedChunks.get(northWestPos)) != null && !c.isTerrainPopulated) {
                this.positionsToCheckIfCanDecorate.add(c);
            }
        }
    }

    @Override
    public boolean canSave() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isChunkValid(@NotNull ChunkPos chunkPos) {
        int rd = this.world.renderDistance() + 1;
        if (this.chunkOver != null) {
            int dx = this.chunkOver.x - chunkPos.x;
            int dz = this.chunkOver.z - chunkPos.z;
            if (dx <= 2 && dx >= -2 && dz <= 2 && dz >= -2) {
                return true;
            }
        }
        List<Player> list = this.world.players;
        synchronized (list) {
            @NotNull List<@NotNull Player> players = this.world.players;
            int size = players.size();
            for (int i = 0; i < size; ++i) {
                Player player = players.get(i);
                int pCX = (int)player.x >> 4;
                int pCZ = (int)player.z >> 4;
                int dx = pCX - chunkPos.x;
                int dz = pCZ - chunkPos.z;
                if (dx > rd || dx < -rd || dz > rd || dz < -rd) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private Chunk loadChunk(@NotNull ChunkPos chunkPos) {
        try {
            Chunk chunk = this.chunkLoader.loadChunk(this.world, chunkPos.x, chunkPos.z);
            if (chunk == null) {
                chunk = this.chunkGenerator.generate(chunkPos.x, chunkPos.z);
                chunk.fixMissingBlocks();
            }
            return chunk;
        }
        catch (Exception exception) {
            LOGGER.error("Error loading chunk at X:{}, Z:{}", chunkPos.x, chunkPos.z, exception);
            return this.empty;
        }
    }

    private void saveChunk(@NotNull Chunk chunk) {
        try {
            chunk.lastSaveTime = this.world.getWorldTime();
            this.chunkLoader.saveChunk(this.world, chunk);
            chunk.isModified = false;
        }
        catch (IOException e) {
            LOGGER.error("Error saving chunk at X:{}, Z:{}", chunk.pos.x, chunk.pos.x, e);
        }
    }

    @Override
    @NotNull
    public String getInfoString() {
        return String.format("Loaded: %s, Queued: %s, Undecorated: %s", this.loadedChunks.size(), this.preparedUndecoratedChunks.size(), this.positionsToCheckIfCanDecorate.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadAllChunks() {
        Map<ChunkPos, Chunk> map = this.loadedChunks;
        synchronized (map) {
            for (Chunk chunk : this.loadedChunks.values()) {
                chunk.onUnload();
            }
            this.loadedChunks.clear();
        }
        map = this.preparedUndecoratedChunks;
        synchronized (map) {
            this.preparedUndecoratedChunks.clear();
        }
        System.gc();
    }

    @Override
    public void close() {
        this.genThread.close();
    }

    public static class ChunkGenThread
    extends Thread {
        private boolean running = true;
        private final AtomicBoolean sleeping = new AtomicBoolean(false);
        @NotNull
        private final ArrayList<ChunkPos> chunkQueueSet = new ArrayList();
        @NotNull
        private final ChunkProviderThreaded chunkProvider;

        public ChunkGenThread(@NotNull ChunkProviderThreaded chunkProvider) {
            this.chunkProvider = chunkProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                try {
                    boolean hasWork;
                    this.sleeping.set(false);
                    ArrayList<ChunkPos> arrayList = this.chunkQueueSet;
                    synchronized (arrayList) {
                        hasWork = !this.chunkQueueSet.isEmpty();
                    }
                    if (!hasWork) {
                        try {
                            this.sleeping.set(true);
                            Thread.sleep(Integer.MAX_VALUE);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    ChunkPos first = null;
                    ArrayList<ChunkPos> arrayList2 = this.chunkQueueSet;
                    synchronized (arrayList2) {
                        this.chunkQueueSet.removeIf(this.chunkProvider::isChunkLoaded);
                        if (!this.chunkQueueSet.isEmpty()) {
                            first = this.chunkQueueSet.remove(0);
                        }
                    }
                    if (first == null) continue;
                    Chunk chunk = this.chunkProvider.loadChunk(first);
                    Map<ChunkPos, Chunk> map = this.chunkProvider.preparedUndecoratedChunks;
                    synchronized (map) {
                        this.chunkProvider.preparedUndecoratedChunks.put(chunk.pos, chunk);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error in chunk gen thread!", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueChunk(@NotNull ChunkPos chunkPos) {
            Object object = this.chunkProvider.preparedUndecoratedChunks;
            synchronized (object) {
                if (this.chunkProvider.preparedUndecoratedChunks.containsKey(chunkPos)) {
                    return;
                }
            }
            object = this.chunkQueueSet;
            synchronized (object) {
                if (this.chunkQueueSet.contains(chunkPos)) {
                    return;
                }
                this.chunkQueueSet.add(chunkPos);
            }
            if (this.sleeping.get()) {
                this.interrupt();
            }
        }

        public void close() {
            this.running = false;
            if (this.sleeping.get()) {
                this.interrupt();
            }
        }
    }
}

