/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.indev;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkGeneratorResult;
import net.minecraft.core.world.generate.chunk.indev.IndevWorldTheme;
import net.minecraft.core.world.generate.chunk.indev.IndevWorldType;
import net.minecraft.core.world.noise.CombinedPerlinNoise;
import net.minecraft.core.world.noise.RetroPerlinNoise;
import org.jetbrains.annotations.NotNull;

public final class LevelGenerator {
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    @NotNull
    private final IndevWorldType worldType;
    @NotNull
    private final IndevWorldTheme worldTheme;

    public LevelGenerator(int sizeX, int sizeY, int sizeZ, @NotNull IndevWorldType worldType, @NotNull IndevWorldTheme worldTheme) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.worldType = worldType;
        this.worldTheme = worldTheme;
    }

    public void generate(World world, ChunkGeneratorResult result, int xOffset, int zOffset) {
        int waterLevel = world.getWorldType().getOceanY();
        long seed = world.getRandomSeed();
        int layers = 1;
        if (this.worldType == IndevWorldType.FLOATING) {
            layers = (this.sizeY - 64) / 48 + 1;
        }
        for (int layer = 0; layer < layers; ++layer) {
            int height;
            int[] heightMap = new int[256];
            if (this.worldType == IndevWorldType.FLAT) {
                for (int i = 0; i < heightMap.length; ++i) {
                    heightMap[i] = 0;
                }
            } else {
                int z;
                CombinedPerlinNoise heightNoiseGeneratorA = new CombinedPerlinNoise(new RetroPerlinNoise(seed, 8, 0), new RetroPerlinNoise(seed, 8, 8));
                CombinedPerlinNoise heightNoiseGeneratorB = new CombinedPerlinNoise(new RetroPerlinNoise(seed, 8, 16), new RetroPerlinNoise(seed, 8, 24));
                RetroPerlinNoise heightNoiseGeneratorSelector = new RetroPerlinNoise(seed, 6, 32);
                RetroPerlinNoise edgeNoiseGenerator = new RetroPerlinNoise(seed, 2, 38);
                for (int x = 0; x < 16; ++x) {
                    double xDistanceFromCenter = Math.abs(((double)(x + xOffset) / ((double)this.sizeX - 1.0) - 0.5) * 2.0);
                    for (z = 0; z < 16; ++z) {
                        double zDistanceFromCenter = Math.abs(((double)(z + zOffset) / ((double)this.sizeZ - 1.0) - 0.5) * 2.0);
                        double heightNoiseA = heightNoiseGeneratorA.get((float)(x + xOffset) * 1.3f, (float)(z + zOffset) * 1.3f) / 6.0 + -4.0;
                        double heightNoiseB = heightNoiseGeneratorB.get((float)(x + xOffset) * 1.3f, (float)(z + zOffset) * 1.3f) / 5.0 + 10.0 + -4.0;
                        double heightNoiseToUse = heightNoiseGeneratorSelector.get(x + xOffset, z + zOffset) / 8.0;
                        if (heightNoiseToUse > 0.0) {
                            heightNoiseB = heightNoiseA;
                        }
                        double height2 = Math.max(heightNoiseA, heightNoiseB) / 2.0;
                        if (this.worldType == IndevWorldType.ISLAND) {
                            double distanceFromCenter = Math.sqrt(xDistanceFromCenter * xDistanceFromCenter + zDistanceFromCenter * zDistanceFromCenter) * (double)1.2f;
                            double edgeNoise = edgeNoiseGenerator.get((float)(x + xOffset) * 0.05f, (float)(z + zOffset) * 0.05f) / 4.0 + 1.0;
                            distanceFromCenter = Math.min(distanceFromCenter, edgeNoise);
                            if ((distanceFromCenter = Math.max(distanceFromCenter, Math.max(xDistanceFromCenter, zDistanceFromCenter))) > 1.0) {
                                distanceFromCenter = 1.0;
                            }
                            if (distanceFromCenter < 0.0) {
                                distanceFromCenter = 0.0;
                            }
                            if ((height2 = height2 * (1.0 - (distanceFromCenter *= distanceFromCenter)) - distanceFromCenter * 10.0 + 5.0) < 0.0) {
                                height2 -= height2 * height2 * (double)0.2f;
                            }
                        } else if (height2 < 0.0) {
                            height2 *= 0.8;
                        }
                        heightMap[x + z * 16] = (int)height2;
                    }
                }
                CombinedPerlinNoise erosionPowerNoiseGenerator = new CombinedPerlinNoise(new RetroPerlinNoise(seed, 8, 40), new RetroPerlinNoise(seed, 8, 48));
                CombinedPerlinNoise erosionAmountNoiseGenerator = new CombinedPerlinNoise(new RetroPerlinNoise(seed, 8, 56), new RetroPerlinNoise(seed, 8, 64));
                for (int x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        int erosionAmount;
                        double erosionPower = erosionPowerNoiseGenerator.get(x + xOffset << 1, z + zOffset << 1) / 8.0;
                        int n = erosionAmount = erosionAmountNoiseGenerator.get(x + xOffset << 1, z + zOffset << 1) > 0.0 ? 1 : 0;
                        if (!(erosionPower > 2.0)) continue;
                        height = heightMap[x + z * 16];
                        heightMap[x + z * 16] = height = ((height - erosionAmount) / 2 << 1) + erosionAmount;
                    }
                }
            }
            RetroPerlinNoise soilNoiseGenerator = new RetroPerlinNoise(seed, 8, 72);
            RetroPerlinNoise floatingLayerNoiseGenerator = new RetroPerlinNoise(seed, 8, 80);
            for (int x = 0; x < 16; ++x) {
                double xDistanceFromCenter = Math.abs(((double)(x + xOffset) / ((double)this.sizeX - 1.0) - 0.5) * 2.0);
                for (int z = 0; z < 16; ++z) {
                    double zDistanceFromCenter = Math.abs(((double)(z + zOffset) / ((double)this.sizeZ - 1.0) - 0.5) * 2.0);
                    double distanceFromCenter = Math.max(xDistanceFromCenter, zDistanceFromCenter);
                    distanceFromCenter = distanceFromCenter * distanceFromCenter * distanceFromCenter;
                    int soilNoise = (int)(soilNoiseGenerator.get(x + xOffset, z + zOffset) / 24.0) - 4;
                    height = heightMap[x + z * 16] + waterLevel;
                    int soilHeight = height + soilNoise;
                    heightMap[x + z * 16] = Math.max(height, soilHeight);
                    if (heightMap[x + z * 16] > this.sizeY - 2) {
                        heightMap[x + z * 16] = this.sizeY - 2;
                    }
                    if (heightMap[x + z * 16] <= 0) {
                        heightMap[x + z * 16] = 1;
                    }
                    double floatingLayerNoise = floatingLayerNoiseGenerator.get((double)(x + xOffset) * 2.3, (double)(z + zOffset) * 2.3) / 24.0;
                    int floatingLayerMinY = (int)(Math.sqrt(Math.abs(floatingLayerNoise)) * Math.signum(floatingLayerNoise) * 20.0) + waterLevel;
                    if ((floatingLayerMinY = (int)((double)floatingLayerMinY * (1.0 - distanceFromCenter) + distanceFromCenter * (double)this.sizeY)) > waterLevel) {
                        floatingLayerMinY = this.sizeY;
                    }
                    for (int y = 0; y < this.sizeY; ++y) {
                        int id = 0;
                        if (y <= height) {
                            id = Blocks.STONE.id();
                        }
                        if (this.worldType == IndevWorldType.FLOATING && y < floatingLayerMinY) {
                            id = 0;
                        }
                        if (result.getBlock(x, y, z) != 0) continue;
                        result.setBlock(x, y, z, id);
                    }
                }
            }
            RetroPerlinNoise sandNoiseGenerator = new RetroPerlinNoise(seed, 8, 88);
            RetroPerlinNoise gravelNoiseGenerator = new RetroPerlinNoise(seed, 8, 96);
            int beachHeight = waterLevel - 1;
            if (this.worldTheme == IndevWorldTheme.PARADISE) {
                beachHeight += 2;
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int height3;
                    int topBlock;
                    boolean isGravel;
                    boolean isSand = sandNoiseGenerator.get(x + xOffset, z + zOffset) > 8.0;
                    boolean bl = isGravel = gravelNoiseGenerator.get(x + xOffset, z + zOffset) > 12.0;
                    if (this.worldType == IndevWorldType.ISLAND) {
                        boolean bl2 = isSand = sandNoiseGenerator.get(x + xOffset, z + zOffset) > -8.0;
                    }
                    if (this.worldTheme == IndevWorldTheme.PARADISE) {
                        boolean bl3 = isSand = sandNoiseGenerator.get(x + xOffset, z + zOffset) > -32.0;
                    }
                    if (this.worldTheme == IndevWorldTheme.HELL || this.worldTheme == IndevWorldTheme.WOODS) {
                        boolean bl4 = isSand = sandNoiseGenerator.get(x + xOffset, z + zOffset) > -8.0;
                    }
                    if (((topBlock = result.getBlock(x, (height3 = heightMap[x + z * 16]) + 1, z)) == Blocks.FLUID_WATER_FLOWING.id() || topBlock == Blocks.FLUID_WATER_STILL.id() || topBlock == 0) && height3 <= waterLevel - 1 && isGravel) {
                        result.setBlock(x, height3, z, Blocks.GRAVEL.id());
                    }
                    if (topBlock != 0) continue;
                    int id = -1;
                    if (height3 <= beachHeight && isSand) {
                        id = Blocks.SAND.id();
                        if (this.worldTheme == IndevWorldTheme.HELL) {
                            id = Blocks.GRASS.id();
                        }
                    }
                    if (result.getBlock(x, height3, z) == 0 || id <= 0) continue;
                    result.setBlock(x, height3, z, id);
                }
            }
        }
        if (this.worldType != IndevWorldType.FLOATING) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < this.sizeY; ++y) {
                        int i = Chunk.makeBlockIndex(x, y, z);
                        int id = result.getBlock(x, y, z);
                        if (id != 0 || y >= waterLevel) continue;
                        result.setBlock(x, y, z, Blocks.FLUID_WATER_STILL.id());
                    }
                }
            }
        }
    }

    public static void generateHouse(@NotNull World world) {
        int xSpawn = world.getLevelData().getSpawnX();
        int ySpawn = world.getLevelData().getSpawnY();
        int zSpawn = world.getLevelData().getSpawnZ();
        for (int x = xSpawn - 3; x <= xSpawn + 3; ++x) {
            for (int y = ySpawn - 2; y <= ySpawn + 2; ++y) {
                for (int z = zSpawn - 3; z <= zSpawn + 3; ++z) {
                    int id;
                    int n = id = y < ySpawn - 1 ? Blocks.OBSIDIAN.id() : 0;
                    if (x == xSpawn - 3 || z == zSpawn - 3 || x == xSpawn + 3 || z == zSpawn + 3 || y == ySpawn - 2 || y == ySpawn + 2) {
                        id = Blocks.STONE.id();
                        if (y >= ySpawn - 1) {
                            id = Blocks.PLANKS_OAK.id();
                        }
                    }
                    if (z == zSpawn - 3 && x == xSpawn && y >= ySpawn - 1 && y <= ySpawn) {
                        id = 0;
                    }
                    world.setBlockWithNotify(x, y + 2, z, id);
                }
            }
        }
        world.setBlockWithNotify(xSpawn - 3 + 1, ySpawn + 2, zSpawn, Blocks.TORCH_COAL.id());
        world.setBlockWithNotify(xSpawn + 3 - 1, ySpawn + 2, zSpawn, Blocks.TORCH_COAL.id());
    }
}

