/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.pos;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.Into;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public interface Pos3i<T extends Pos3i<T>>
extends Into<Vec3> {
    @Override
    @NotNull
    default public Vec3 into() {
        return Vec3.fromPool(this.x(), this.y(), this.z());
    }

    public int x();

    public int y();

    public int z();

    @NotNull
    public T add(int var1, int var2, int var3);

    @NotNull
    default public T add(@NotNull T other) {
        return this.add(other.x(), other.y(), other.z());
    }

    @NotNull
    default public T add(@NotNull Direction direction, int distance) {
        return this.add(direction.getOffsetX() * distance, direction.getOffsetY() * distance, direction.getOffsetZ() * distance);
    }

    @NotNull
    default public T add(@NotNull Direction direction) {
        return this.add(direction, 1);
    }

    @NotNull
    default public T north() {
        return this.add(Direction.NORTH);
    }

    @NotNull
    default public T east() {
        return this.add(Direction.EAST);
    }

    @NotNull
    default public T south() {
        return this.add(Direction.SOUTH);
    }

    @NotNull
    default public T west() {
        return this.add(Direction.WEST);
    }

    @NotNull
    default public T up() {
        return this.add(Direction.UP);
    }

    @NotNull
    default public T down() {
        return this.add(Direction.DOWN);
    }

    @NotNull
    default public T sub(int x, int y, int z) {
        return this.add(-x, -y, -z);
    }

    @NotNull
    default public T sub(@NotNull T other) {
        return this.sub(other.x(), other.y(), other.z());
    }

    @NotNull
    default public T sub(@NotNull Direction direction, int distance) {
        return this.add(direction, -distance);
    }

    @NotNull
    default public T sub(@NotNull Direction direction) {
        return this.sub(direction, 1);
    }

    default public double distToSq(@NotNull Pos3i<?> pos) {
        return this.distToSq(pos.x(), pos.y(), pos.z());
    }

    default public double distToSq(@NotNull Vec3 pos) {
        return this.distToSq(pos.x, pos.y, pos.z);
    }

    default public double distToSq(@NotNull Entity entity) {
        return this.distToSq(entity.x, entity.y, entity.z);
    }

    default public double distToSq(int x, int y, int z) {
        double dx = this.x() - x;
        double dy = this.y() - y;
        double dz = this.z() - z;
        return dx * dx + dy * dy + dz * dz;
    }

    default public double distToSq(float x, float y, float z) {
        double dx = (float)this.x() - x;
        double dy = (float)this.y() - y;
        double dz = (float)this.z() - z;
        return dx * dx + dy * dy + dz * dz;
    }

    default public double distToSq(double x, double y, double z) {
        double dx = (double)this.x() - x;
        double dy = (double)this.y() - y;
        double dz = (double)this.z() - z;
        return dx * dx + dy * dy + dz * dz;
    }

    default public double distTo(@NotNull Pos3i<?> pos) {
        return Math.sqrt(this.distTo(pos));
    }

    default public double distTo(@NotNull Vec3 pos) {
        return Math.sqrt(this.distTo(pos));
    }

    default public double distTo(@NotNull Entity entity) {
        return Math.sqrt(this.distTo(entity));
    }

    default public double distTo(int x, int y, int z) {
        return Math.sqrt(this.distTo(x, y, z));
    }

    default public double distTo(float x, float y, float z) {
        return Math.sqrt(this.distTo(x, y, z));
    }

    default public double distTo(double x, double y, double z) {
        return Math.sqrt(this.distTo(x, y, z));
    }
}

