/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.BlockInterface;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicSupplier;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.sound.BlockSound;
import net.minecraft.core.sound.BlockSounds;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.BoundingVolume;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public final class Block<T extends BlockLogic>
implements ITaggable<Block<?>>,
IItemConvertible,
BlockInterface {
    public static boolean disableNormalEntityLogic = false;
    private final int id;
    @NotNull
    private final String key;
    @NotNull
    private final NamespaceID namespaceID;
    @NotNull
    private final BlockLogicSupplier<T> logicSupplier;
    @NotNull
    private T logic;
    public float blockHardness;
    public float blastResistance;
    public boolean enableStats;
    public boolean isLitInteriorSurface;
    public float blockParticleGravity;
    public float friction;
    public int emission;
    @Nullable
    public Integer lightBlock = null;
    public boolean immovable = false;
    public boolean isEntityTile = false;
    public boolean disabledNeighborMetaNotify = false;
    public boolean shouldTick = false;
    public @Nullable Supplier<@NotNull TileEntity> entitySupplier;
    @Nullable
    public MaterialColor overrideColor;
    @NotNull
    private BlockSound blockSound = BlockSounds.DEFAULT;
    @NotNull
    public @NotNull Supplier<@NotNull Item> blockItemSupplier = () -> new ItemBlock(this);
    @Nullable Supplier<@NotNull IItemConvertible> statParent = null;

    Block(int id, @NotNull String translationKey, @NotNull String namespaceId, @NotNull BlockLogicSupplier<T> logicSupplier) {
        this.namespaceID = this.setupNamespaceId(namespaceId).makePermanent();
        this.key = this.setupTranslationKey(translationKey);
        this.id = this.setupNumericId(id);
        this.logicSupplier = Objects.requireNonNull(logicSupplier);
        this.enableStats = true;
        this.blockParticleGravity = 1.0f;
        this.friction = 0.6f;
        this.immovable = false;
    }

    private int setupNumericId(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("Numeric id of block '" + String.valueOf(this.namespaceID) + "' must not be negative!");
        }
        if (id >= Blocks.blocksList.length) {
            throw new IllegalArgumentException("Numeric id of block '" + String.valueOf(this.namespaceID) + "' must not be greater than '" + (Blocks.blocksList.length - 1) + "'!");
        }
        return id;
    }

    @NotNull
    private String setupTranslationKey(String translationKey) {
        if (translationKey == null) {
            throw new NullPointerException("Translation key of block '" + String.valueOf(this.namespaceID) + "' must not be null!");
        }
        if (!((String)translationKey).startsWith("tile.")) {
            translationKey = "tile." + (String)translationKey;
        }
        return translationKey;
    }

    @NotNull
    private NamespaceID setupNamespaceId(String namespaceId) {
        if (namespaceId == null) {
            throw new NullPointerException("NamespaceId must not be null!");
        }
        if (!((String)namespaceId).contains(":")) {
            namespaceId = "minecraft:" + (String)namespaceId;
        }
        try {
            return (NamespaceID)NamespaceID.fromPool((String)namespaceId).copyUnpooled();
        }
        catch (HardIllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public T getLogic() {
        return this.logic;
    }

    public Block<T> withEntity(@Nullable Supplier<TileEntity> entitySupplier) {
        this.isEntityTile = true;
        this.entitySupplier = entitySupplier;
        return this;
    }

    public Block<T> withDisabledNeighborNotifyOnMetadataChange() {
        this.disabledNeighborMetaNotify = true;
        return this;
    }

    public Block<T> withLightBlock(int blockAmount) {
        this.lightBlock = blockAmount;
        return this;
    }

    public Block<T> withLightEmission(float lightEmission) {
        this.emission = (int)(15.0f * lightEmission);
        return this;
    }

    public Block<T> withLightEmission(int lightEmission) {
        this.emission = lightEmission & 0xF;
        return this;
    }

    public Block<T> withImmovableFlagSet() {
        this.immovable = true;
        return this;
    }

    public Block<T> withBlastResistance(float blastResistance) {
        this.blastResistance = blastResistance * 3.0f;
        return this;
    }

    public Block<T> withSound(BlockSound sound) {
        this.blockSound = sound;
        return this;
    }

    public Block<T> withHardness(float blockHardness) {
        this.blockHardness = blockHardness;
        if (this.blastResistance < blockHardness * 5.0f) {
            this.blastResistance = blockHardness * 5.0f;
        }
        return this;
    }

    public Block<T> withLitInteriorSurface(boolean isLit) {
        this.isLitInteriorSurface = isLit;
        return this;
    }

    public Block<T> withSetUnbreakable() {
        this.withHardness(-1.0f);
        return this;
    }

    public Block<T> setBlockItem(@NotNull Supplier<Item> itemSupplier) {
        this.blockItemSupplier = itemSupplier;
        return this;
    }

    public Block<T> setBlockItem(@NotNull Function<Block<T>, Item> itemSupplier) {
        this.blockItemSupplier = () -> (Item)itemSupplier.apply(this);
        return this;
    }

    public Block<T> withOverrideColor(MaterialColor color) {
        this.overrideColor = color;
        return this;
    }

    public Block<T> setStatParent(@NotNull @NotNull Supplier<@NotNull IItemConvertible> icon) {
        this.statParent = icon;
        return this;
    }

    public Block<T> withDisabledStats() {
        this.enableStats = false;
        return this;
    }

    public Block<T> setTicking(boolean tick) {
        this.shouldTick = tick;
        return this;
    }

    public BlockSound getSound() {
        return this.blockSound;
    }

    public Material getMaterial() {
        return ((BlockLogic)this.logic).getMaterial();
    }

    public float getHardness() {
        return this.blockHardness;
    }

    public boolean getEnableStats() {
        return this.enableStats && this.getHardness() >= 0.0f;
    }

    @Nullable
    public Stat getStat(String statID) {
        return this.asItem().getStat(statID);
    }

    public MaterialColor getMaterialColor() {
        if (this.overrideColor != null) {
            return this.overrideColor;
        }
        return ((BlockLogic)this.logic).getMaterialColor();
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public NamespaceID namespaceId() {
        return this.namespaceID;
    }

    public void init() {
        this.logic = this.logicSupplier.get(this);
    }

    @Override
    public boolean isIn(Tag<Block<?>> tag) {
        return tag.appliesTo(this);
    }

    @Override
    @NotNull
    public Item asItem() {
        return Item.itemsList[this.id];
    }

    @Override
    @NotNull
    public ItemStack getDefaultStack() {
        return new ItemStack(this);
    }

    public static boolean getIsLitInteriorSurface(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        @Nullable Block<?> block = source.getBlock(tilePos);
        return block != null && block.isLitInteriorSurface;
    }

    @Deprecated
    public static boolean getIsLitInteriorSurface(@NotNull WorldSource source, int x, int y, int z) {
        return Block.getIsLitInteriorSurface(source, new TilePos(x, y, z));
    }

    @SafeVarargs
    public final Block<T> withTags(Tag<Block<?>> ... tags) {
        for (Tag<Block<?>> tag : tags) {
            tag.tag(this);
        }
        return this;
    }

    public boolean hasTag(Tag<Block<?>> tag) {
        return tag.appliesTo(this);
    }

    @Override
    public boolean isCubeShaped() {
        return ((BlockLogic)this.logic).isCubeShaped();
    }

    @Override
    public boolean canPlaceOnSurface() {
        return ((BlockLogic)this.logic).canPlaceOnSurface();
    }

    @Override
    public boolean canPlaceOnSurfaceOnCondition(@NotNull World world, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).canPlaceOnSurfaceOnCondition(world, tilePos);
    }

    @Override
    public boolean renderAsNormalBlockOnCondition(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).renderAsNormalBlockOnCondition(source, tilePos);
    }

    @Override
    public boolean canPlaceOnSurface(@NotNull World world, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).canPlaceOnSurface(world, tilePos);
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, @NotNull TilePosc tilePos, int data, @Nullable TileEntity tileEntity) {
        return ((BlockLogic)this.logic).getBreakResult(world, dropCause, tilePos, data, tileEntity);
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return ((BlockLogic)this.logic).getBreakResult(world, dropCause, data, tileEntity);
    }

    @Override
    @NotNull
    public AABBdc getBounds() {
        return ((BlockLogic)this.logic).getBounds();
    }

    @Override
    @NotNull
    public AABBd getBoundsRaw() {
        return ((BlockLogic)this.logic).getBoundsRaw();
    }

    @Override
    public float getBrightness(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).getBrightness(source, tilePos);
    }

    @Override
    public int getLightmapCoord(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).getLightmapCoord(source, tilePos);
    }

    @Override
    public float getAmbientOcclusionStrength(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).getAmbientOcclusionStrength(source, tilePos);
    }

    @Override
    @NotNull
    public AABBdc getSelectionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).getSelectionAABB(source, tilePos);
    }

    @Override
    @Nullable
    public BoundingVolume getBoundingVolume(@NotNull World world, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).getBoundingVolume(world, tilePos);
    }

    @Override
    public void getCollisionAABBs(@NotNull World world, @NotNull TilePosc tilePos, @NotNull AABBdc aabb, @NotNull @NotNull List<@NotNull AABBdc> aabbList) {
        ((BlockLogic)this.logic).getCollisionAABBs(world, tilePos, aabb, aabbList);
    }

    @Override
    public boolean collidesWithEntity(@NotNull Entity entity, @NotNull World world, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).collidesWithEntity(entity, world, tilePos);
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).getCollisionAABB(source, tilePos);
    }

    @Override
    public boolean isSolidRender() {
        return ((BlockLogic)this.logic).isSolidRender();
    }

    @Override
    public boolean blocksLight() {
        return ((BlockLogic)this.logic).blocksLight();
    }

    @Override
    public boolean canCollideCheck(int data, boolean shouldCollideWithFluids) {
        return ((BlockLogic)this.logic).canCollideCheck(data, shouldCollideWithFluids);
    }

    @Override
    public boolean isCollidable() {
        return ((BlockLogic)this.logic).isCollidable();
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        ((BlockLogic)this.logic).updateTick(world, tilePos, rand, false);
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        ((BlockLogic)this.logic).animationTick(world, tilePos, rand);
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, int id) {
        ((BlockLogic)this.logic).onNeighborChanged(world, tilePos, id);
    }

    @Override
    public int tickDelay() {
        return ((BlockLogic)this.logic).tickDelay();
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        if (this.isEntityTile && !disableNormalEntityLogic && this.entitySupplier != null) {
            world.setTileEntity(tilePos, this.entitySupplier.get());
        }
        ((BlockLogic)this.logic).onPlacedByWorld(world, tilePos);
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        ((BlockLogic)this.logic).onRemoved(world, tilePos, data);
        if (this.isEntityTile && !disableNormalEntityLogic) {
            TileEntity tileEntity;
            if (!world.isClientSide && (tileEntity = world.getTileEntity(tilePos)) != null) {
                tileEntity.dropContents(world, tilePos.x(), tilePos.y(), tilePos.z());
            }
            world.removeTileEntity(tilePos);
        }
    }

    @Override
    public void onDestroyedByPlayer(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, int data, @NotNull Player player, @Nullable Item item) {
        ((BlockLogic)this.logic).onDestroyedByPlayer(world, tilePos, side, data, player, item);
    }

    @Override
    public float getStrength(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, @NotNull Player player) {
        return ((BlockLogic)this.logic).getStrength(world, tilePos, side, player);
    }

    @Override
    public boolean getImmovable() {
        return ((BlockLogic)this.logic).getImmovable();
    }

    @Override
    public float getBlastResistance(@Nullable Entity entity) {
        return ((BlockLogic)this.logic).getBlastResistance(entity);
    }

    @Override
    @Nullable
    public HitResult collisionRayTrace(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Vector3dc start, @NotNull Vector3dc end, boolean useSelectionAABB) {
        return ((BlockLogic)this.logic).collisionRayTrace(world, tilePos, start, end, useSelectionAABB);
    }

    @Override
    public void onDestroyedByExplosion(@NotNull World world, @NotNull TilePosc tilePos) {
        ((BlockLogic)this.logic).onDestroyedByExplosion(world, tilePos);
    }

    @Override
    public boolean canPlaceOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return ((BlockLogic)this.logic).canPlaceOnSide(world, tilePos, side);
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).canPlaceAt(world, tilePos);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        return ((BlockLogic)this.logic).onInteracted(world, tilePos, player, side, xHit, yHit);
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        ((BlockLogic)this.logic).onActivatorInteracted(world, tilePos, activator, direction);
    }

    @Override
    public void onEntityWalkedOn(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Entity walker) {
        ((BlockLogic)this.logic).onEntityWalkedOn(world, tilePos, walker);
    }

    @Override
    public void onAttacked(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @NotNull Side side, double xHit, double yHit) {
        ((BlockLogic)this.logic).onAttacked(world, tilePos, player, side, xHit, yHit);
    }

    @Override
    public void onEntityInside(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Entity entity, @NotNull Vector3d velocityDirection) {
        ((BlockLogic)this.logic).onEntityInside(world, tilePos, entity, velocityDirection);
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).getBoundsFromState(source, tilePos);
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        return ((BlockLogic)this.logic).isEmittingSignal(source, tilePos, side);
    }

    @Override
    public boolean isSignalSource() {
        return ((BlockLogic)this.logic).isSignalSource();
    }

    @Override
    public void onEntityCollision(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Entity entity) {
        ((BlockLogic)this.logic).onEntityCollision(world, tilePos, entity);
    }

    @Override
    public boolean isEmittingDirectSignal(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return ((BlockLogic)this.logic).isEmittingDirectSignal(world, tilePos, side);
    }

    @Override
    public void onHarvest(@NotNull World world, @NotNull Player player, @NotNull TilePosc tilePos, int data, @Nullable TileEntity tileEntity) {
        ((BlockLogic)this.logic).onHarvest(world, player, tilePos, data, tileEntity);
    }

    @Override
    public void dropWithCause(@NotNull World world, @NotNull EnumDropCause dropCause, @NotNull TilePosc tilePos, int data, @Nullable TileEntity tileEntity, @Nullable Player player) {
        ((BlockLogic)this.logic).dropWithCause(world, dropCause, tilePos, data, tileEntity, player);
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return ((BlockLogic)this.logic).getSupport(world, tilePos, side);
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).canStay(world, tilePos);
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        ((BlockLogic)this.logic).onPlacedByMob(world, tilePos, side, mob, xHit, yHit);
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        ((BlockLogic)this.logic).onPlacedOnSide(world, tilePos, side, xHit, yHit);
    }

    @Override
    @NotNull
    public String getLanguageKey(int data) {
        return ((BlockLogic)this.logic).getLanguageKey(data);
    }

    @Override
    public void triggerEvent(@NotNull World world, @NotNull TilePosc tilePos, int index, int data) {
        ((BlockLogic)this.logic).triggerEvent(world, tilePos, index, data);
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).getPistonPushReaction(world, tilePos);
    }

    @Override
    public int getPlacedData(@Nullable Player player, @NotNull ItemStack itemStack, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        return ((BlockLogic)this.logic).getPlacedData(player, itemStack, world, tilePos, side, xHit, yHit);
    }

    @Override
    public boolean isClimbable(@NotNull World world, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).isClimbable(world, tilePos);
    }

    @Override
    public boolean isEquivalent(@NotNull World world, @NotNull TilePosc thisPos, @NotNull TilePosc thatPos) {
        return ((BlockLogic)this.logic).isEquivalent(world, thisPos, thatPos);
    }

    @Override
    @NotNull
    public Side getAttachedSide(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return ((BlockLogic)this.logic).getAttachedSide(source, tilePos);
    }

    public static boolean hasLogicClass(@Nullable Block<?> block, @NotNull Class<?> logicClass) {
        return block != null && logicClass.isAssignableFrom(block.getLogic().getClass());
    }

    @Nullable
    public static BlockLogic getLogicClass(@Nullable Block<?> block) {
        return block == null ? null : (BlockLogic)block.getLogic();
    }
}

