/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLeavesBase;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.wind.WindProvider;
import org.jetbrains.annotations.NotNull;

public class BlockLogicLeavesOak
extends BlockLogicLeavesBase {
    public BlockLogicLeavesOak(@NotNull Block<?> block) {
        super(block, Materials.LEAVES, Blocks.SAPLING_OAK);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        super.updateTick(world, tilePos, rand, isRandomTick);
        if (rand.nextInt(128) == 0 && world.getSeasonManager().getCurrentSeason() != null && world.getSeasonManager().getCurrentSeason().hasFallingLeaves) {
            int id;
            TilePos queryPos = new TilePos();
            for (int q = -1; q > -16 && (id = world.getBlockId(tilePos.add(0, q, 0, queryPos))) == 0; --q) {
                if (Blocks.LAYER_LEAVES_OAK.canPlaceAt(world, tilePos.add(0, q, 0, queryPos)) && Blocks.blocksList[world.getBlockId(tilePos.add(0, q - 1, 0, queryPos))].getMaterial().blocksMotion()) {
                    world.setBlockIdNotify(tilePos.add(0, q, 0, queryPos), Blocks.LAYER_LEAVES_OAK.id());
                    break;
                }
                if (world.getBlockId(tilePos.add(0, q, 0, queryPos)) != Blocks.LAYER_LEAVES_OAK.id()) continue;
                Blocks.LAYER_LEAVES_OAK.getLogic().accumulate(world, queryPos);
                break;
            }
        }
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        WindProvider wind;
        float windIntensity;
        if (world.getSeasonManager().getCurrentSeason() != null && world.getSeasonManager().getCurrentSeason().hasFallingLeaves && rand.nextInt((int)(40.0f + 200.0f * (1.0f - (windIntensity = (wind = world.getWorldType().getWindManager()).getWindIntensity(world, tilePos.x(), tilePos.y(), tilePos.z()))))) == 0) {
            world.spawnParticle("fallingleaf", tilePos.x(), (double)tilePos.y() - (double)0.1f, tilePos.z(), 0.0, 0.0, 0.0, 0);
        }
    }
}

