/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicPathDirt
extends BlockLogic {
    public BlockLogicPathDirt(@NotNull Block<?> block) {
        super(block, Materials.DIRT);
        block.setTicking(true);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
        block.withLightBlock(255);
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return new AABBd(tilePos.x(), tilePos.y(), tilePos.z(), tilePos.x() + 1, tilePos.y() + 1, tilePos.z() + 1);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, int id) {
        super.onNeighborChanged(world, tilePos, id);
        TilePos up = tilePos.up(new TilePos());
        Material material = world.getBlockMaterial(up);
        Block<?> b = world.getBlock(up);
        if (material.isSolid() && b != Blocks.FENCE_GATE_PLANKS_OAK && b != Blocks.FENCE_GATE_PLANKS_OAK_PAINTED && b != Blocks.SIGN_WALL_PLANKS_OAK) {
            world.setBlockIdNotify(tilePos, Blocks.DIRT.id());
        }
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this);
                break;
            }
            default: {
                ItemStack[] itemStackArray3 = new ItemStack[1];
                itemStackArray = itemStackArray3;
                itemStackArray3[0] = new ItemStack(Blocks.DIRT);
            }
        }
        return itemStackArray;
    }
}

