/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicStairs;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockLogicStairsPainted
extends BlockLogicStairs
implements IPainted {
    public BlockLogicStairsPainted(@NotNull Block<?> block, @NotNull Block<?> modelBlock) {
        super(block, modelBlock);
    }

    @Override
    @NotNull
    public DyeColor fromMetadata(int meta) {
        return DyeColor.colorFromBlockMeta((meta & 0xF0) >> 4);
    }

    @Override
    public int toMetadata(@NotNull DyeColor color) {
        return color.blockMeta << 4;
    }

    @Override
    public int stripColorFromMetadata(int meta) {
        return meta & 0xF;
    }

    @Override
    public void removeDye(@NotNull World world, @NotNull TilePosc tilePos) {
        int meta = world.getBlockData(tilePos);
        world.setBlockIdDataNotify(tilePos, Blocks.STAIRS_PLANKS_OAK.id(), this.stripColorFromMetadata(meta));
    }

    @Override
    public void setColor(@NotNull World world, @NotNull TilePosc tilePos, @NotNull DyeColor color) {
        IPainted.super.setColor(world, tilePos, color);
    }
}

