/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.enums.IArmorShape;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemArmor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorBag<T extends IArmorShape> {
    @NotNull
    private final @NotNull List<@NotNull ArmorBagEntry> entries = new ArrayList<ArmorBagEntry>();
    @NotNull
    private final T armorShape;

    public ArmorBag(@NotNull T armorShape) {
        this.armorShape = armorShape;
    }

    @NotNull
    public T getArmorShape() {
        return this.armorShape;
    }

    @NotNull
    public ArmorBag<T> addEntry(@Nullable Item item, int chance, float maxHeight) {
        if (item != null && !(item instanceof ItemArmor)) {
            throw new IllegalArgumentException("Illegal non-armor item for bag!");
        }
        @Nullable ItemArmor armorItem = (ItemArmor)item;
        if (armorItem != null && this.armorShape != armorItem.getArmorShape()) {
            throw new IllegalArgumentException("Illegal armor item shape for bag!");
        }
        if (chance == 0) {
            throw new IllegalArgumentException("Item chance cannot be 0!");
        }
        if (maxHeight == 0.0f) {
            throw new IllegalArgumentException("Max height for item cannot be 0!");
        }
        this.entries.add(new ArmorBagEntry(armorItem, chance, maxHeight));
        return this;
    }

    @Nullable
    public ItemArmor<T> getRandomItem(@NotNull Random rand, int worldHeight, int mobHeight) {
        if (this.entries.isEmpty()) {
            throw new RuntimeException("Tried to pull armor item from empty bag!");
        }
        float mobHeightPercentage = (float)mobHeight / (float)worldHeight;
        int sum = 0;
        for (ArmorBagEntry entry : this.entries) {
            if (!(mobHeightPercentage < entry.maxHeight)) continue;
            sum += entry.chance;
        }
        if (sum == 0) {
            return null;
        }
        int randVal = rand.nextInt(sum);
        int randSum = 0;
        for (ArmorBagEntry entry : this.entries) {
            if (!(mobHeightPercentage < entry.maxHeight) || randVal >= (randSum += entry.chance)) continue;
            return entry.armorItem;
        }
        throw new IllegalStateException("Should never not find an item in the bag!");
    }

    private class ArmorBagEntry {
        @Nullable
        public final ItemArmor<T> armorItem;
        public final int chance;
        public final float maxHeight;

        public ArmorBagEntry(ItemArmor<T> armorItem, int chance, float maxHeight) {
            this.armorItem = armorItem;
            this.chance = chance;
            this.maxHeight = maxHeight;
        }
    }
}

