/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicDoor;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemDoor
extends Item {
    @NotNull
    protected final Block<? extends BlockLogicDoor> doorBlockBottom;
    @NotNull
    protected final Block<? extends BlockLogicDoor> doorBlockTop;

    public ItemDoor(@NotNull String name, @NotNull String namespaceId, int id, @NotNull Block<? extends BlockLogicDoor> doorBlockBottom, @NotNull Block<? extends BlockLogicDoor> doorBlockTop) {
        super(name, namespaceId, id);
        this.maxStackSize = 64;
        this.doorBlockBottom = doorBlockBottom;
        this.doorBlockTop = doorBlockTop;
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        if (player == null) {
            return false;
        }
        if (!world.canPlaceInsideBlock(blockPos)) {
            blockPos = blockPos.add(side.getDirection(), new TilePos());
        }
        Direction leftDir = player.getHorizontalPlacementDirection(side).rotate(3);
        int meta = leftDir.getHorizontalIndex();
        int isSolidBlockLeft = (this.isSupported(world, blockPos, leftDir, false) ? 1 : 0) + (this.isSupported(world, blockPos.up(new TilePos()), leftDir, false) ? 1 : 0);
        int isSolidBlockRight = (this.isSupported(world, blockPos, leftDir.getOpposite(), true) ? 1 : 0) + (this.isSupported(world, blockPos.up(new TilePos()), leftDir.getOpposite(), true) ? 1 : 0);
        boolean isDoorLeft = world.getBlockId(blockPos.add(leftDir, new TilePos())) == this.doorBlockBottom.id() || world.getBlockId(blockPos.add(leftDir, new TilePos()).up(new TilePos())) == this.doorBlockTop.id();
        boolean isDoorRight = world.getBlockId(blockPos.sub(leftDir, new TilePos())) == this.doorBlockBottom.id() || world.getBlockId(blockPos.sub(leftDir, new TilePos()).up(new TilePos())) == this.doorBlockTop.id();
        boolean isMirrored = false;
        if (isDoorLeft && !isDoorRight) {
            isMirrored = (world.getBlockData(blockPos.add(leftDir, new TilePos())) & 8) == 0;
        } else if (isSolidBlockLeft <= 0 || side.getDirection() != leftDir.getOpposite()) {
            if (isSolidBlockRight > 0 && side.getDirection() == leftDir) {
                isMirrored = true;
            } else if (isSolidBlockRight > isSolidBlockLeft) {
                isMirrored = true;
            }
        }
        if (isMirrored) {
            meta = meta - 1 & 3;
            meta |= 4;
            meta |= 8;
        }
        if (!this.doorBlockBottom.getLogic().canPlaceAt(world, blockPos, meta |= DyeColor.colorFromItemMeta((int)selfStack.getMetadata()).blockMeta << 4 & 0xF0)) {
            return false;
        }
        world.noNeighborUpdate = true;
        world.setBlockIdDataNotify(blockPos, this.doorBlockBottom.id(), meta);
        world.setBlockIdDataNotify(blockPos.up(new TilePos()), this.doorBlockTop.id(), meta);
        world.noNeighborUpdate = false;
        world.notifyBlocksOfNeighborChange(blockPos, this.doorBlockBottom.id());
        world.notifyBlocksOfNeighborChange(blockPos.up(new TilePos()), this.doorBlockTop.id());
        world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, this.doorBlockBottom, EnumBlockSoundEffectType.PLACE);
        this.doorBlockBottom.onPlacedByMob(world, blockPos, side, player, xHit, yHit);
        this.doorBlockTop.onPlacedByMob(world, blockPos.up(new TilePos()), side, player, xHit, yHit);
        selfStack.consumeItem(player);
        return true;
    }

    public boolean isSupported(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Direction direction, boolean mirrored) {
        ISupport support = world.getSupport(tilePos.add(direction, new TilePos()), direction.getSide().getOpposite());
        return support.canSupport(mirrored ? PartialSupport.INSTANCE.right() : PartialSupport.INSTANCE.left(), direction.getSide());
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        if (!world.canPlaceInsideBlock(blockPos)) {
            blockPos = blockPos.add(direction, new TilePos());
        }
        if (!direction.isHorizontal()) {
            direction = Direction.NORTH;
        }
        Direction lefDir = direction.rotate(3);
        int meta = lefDir.getHorizontalIndex();
        int isSolidBlockLeft = (this.isSupported(world, blockPos, lefDir, false) ? 1 : 0) + (this.isSupported(world, blockPos.up(new TilePos()), lefDir, false) ? 1 : 0);
        int isSolidBlockRight = (this.isSupported(world, blockPos, lefDir.getOpposite(), true) ? 1 : 0) + (this.isSupported(world, blockPos.up(new TilePos()), lefDir.getOpposite(), true) ? 1 : 0);
        boolean isDoorLeft = world.getBlockId(blockPos.add(lefDir, new TilePos())) == this.doorBlockBottom.id() || world.getBlockId(blockPos.add(lefDir, new TilePos()).up(new TilePos())) == this.doorBlockTop.id();
        boolean isDoorRight = world.getBlockId(blockPos.sub(lefDir, new TilePos())) == this.doorBlockBottom.id() || world.getBlockId(blockPos.sub(lefDir, new TilePos()).up(new TilePos())) == this.doorBlockTop.id();
        boolean isMirrored = false;
        if (isDoorLeft && !isDoorRight) {
            isMirrored = (world.getBlockData(blockPos.add(lefDir, new TilePos())) & 8) == 0;
        } else if (isSolidBlockLeft <= 0 || direction != lefDir.getOpposite()) {
            if (isSolidBlockRight > 0 && direction == lefDir) {
                isMirrored = true;
            } else if (isSolidBlockRight > isSolidBlockLeft) {
                isMirrored = true;
            }
        }
        if (isMirrored) {
            meta = meta - 1 & 3;
            meta |= 4;
            meta |= 8;
        }
        if (!this.doorBlockBottom.getLogic().canPlaceAt(world, blockPos, meta |= DyeColor.colorFromItemMeta((int)selfStack.getMetadata()).blockMeta << 4 & 0xF0)) {
            return;
        }
        world.noNeighborUpdate = true;
        world.setBlockIdDataNotify(blockPos, this.doorBlockBottom.id(), meta);
        world.setBlockIdDataNotify(blockPos.up(new TilePos()), this.doorBlockTop.id(), meta);
        world.noNeighborUpdate = false;
        world.notifyBlocksOfNeighborChange(blockPos, this.doorBlockBottom.id());
        world.notifyBlocksOfNeighborChange(blockPos.up(new TilePos()), this.doorBlockTop.id());
        world.playBlockSoundEffect(null, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, this.doorBlockBottom, EnumBlockSoundEffectType.PLACE);
        this.doorBlockBottom.onPlacedOnSide(world, blockPos, direction.getSide(), 0.5, 0.5);
        this.doorBlockTop.onPlacedOnSide(world, blockPos.up(new TilePos()), direction.getSide(), 0.5, 0.5);
        selfStack.consumeItem(null);
    }
}

