/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLayerBase;
import net.minecraft.core.block.BlockLogicLayerLeaves;
import net.minecraft.core.block.BlockLogicLeavesBase;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;

public class ItemBlockLayerLeaves<T extends BlockLogicLayerLeaves>
extends ItemBlock<T> {
    public ItemBlockLayerLeaves(@NotNull Block<T> block) {
        super(block);
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        Block<?> targetBlock = world.getBlock(blockPos);
        int meta = world.getBlockData(blockPos);
        if (targetBlock != this.block && targetBlock != null && targetBlock.hasTag(BlockTags.PLACE_OVERWRITES)) {
            targetBlock = null;
            meta = 0;
        }
        if (selfStack.stackSize <= 0 || blockPos.y() == world.getHeightBlocks() - 1 && this.block.getMaterial().isSolid()) {
            return false;
        }
        if (targetBlock == this.block && side == Side.TOP) {
            BlockLogicLayerBase blockLayer = (BlockLogicLayerBase)this.block.getLogic();
            int newMeta = meta + 1;
            AABBd bbBox = new AABBd(blockPos.x(), blockPos.y(), blockPos.z(), (float)blockPos.x() + 1.0f, (float)blockPos.y() + (float)(2 * (newMeta + 1)) / 16.0f, (float)blockPos.z() + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            if ((newMeta & 0xF) < 7) {
                world.setBlockIdDataNotify(blockPos, this.block.id(), BlockLogicLayerLeaves.setPermanent(newMeta, true));
            } else if (blockLayer.fullBlock != null) {
                world.setBlockIdDataNotify(blockPos, blockLayer.fullBlock.id(), BlockLogicLeavesBase.setPermanent(0, true));
            } else {
                world.setBlockIdDataNotify(blockPos.up(new TilePos()), this.block.id(), BlockLogicLayerLeaves.setPermanent(0, true));
            }
            world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
            selfStack.consumeItem(player);
            return true;
        }
        if (targetBlock != null) {
            blockPos = blockPos.add(side.getDirection(), new TilePos());
            targetBlock = world.getBlock(blockPos);
            meta = world.getBlockData(blockPos);
        }
        if (targetBlock == this.block) {
            BlockLogicLayerBase blockLayer = (BlockLogicLayerBase)this.block.getLogic();
            int newMeta = meta + 1;
            AABBd bbBox = new AABBd(blockPos.x(), blockPos.y(), blockPos.z(), (float)blockPos.x() + 1.0f, (float)blockPos.y() + (float)(2 * (newMeta + 1)) / 16.0f, (float)blockPos.z() + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            if ((newMeta & 0xF) < 7) {
                world.setBlockIdDataNotify(blockPos, this.block.id(), BlockLogicLayerLeaves.setPermanent(newMeta, true));
            } else if (blockLayer.fullBlock != null) {
                world.setBlockIdDataNotify(blockPos, blockLayer.fullBlock.id(), BlockLogicLeavesBase.setPermanent(0, true));
            } else {
                world.setBlockIdDataNotify(blockPos.up(new TilePos()), this.block.id(), BlockLogicLayerLeaves.setPermanent(0, true));
            }
            world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
            selfStack.consumeItem(player);
            return true;
        }
        if (world.canBlockIdBePlacedAt(this.block.id(), blockPos, false, side)) {
            int placeMeta = this.getPlacedData(selfStack, world, player, blockPos, side, xHit, yHit);
            if (world.setBlockIdDataNotify(blockPos, this.block.id(), placeMeta)) {
                if (player == null) {
                    this.block.onPlacedOnSide(world, blockPos, side, xHit, yHit);
                } else {
                    this.block.onPlacedByMob(world, blockPos, side, player, xHit, yHit);
                }
                world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
                selfStack.consumeItem(player);
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPlacedData(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        return 128;
    }
}

