/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.helper;

import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class MathHelper {
    private static final float[] SIN_TABLE;
    public static final float PI = (float)Math.PI;
    public static final float DEG_TO_RAD;
    public static final float RAD_TO_DEG;

    public static float sin(float f) {
        return SIN_TABLE[(int)(f * 10430.38f) & 0xFFFF];
    }

    public static float cos(float f) {
        return SIN_TABLE[(int)(f * 10430.38f + 16384.0f) & 0xFFFF];
    }

    public static float sqrt_float(float f) {
        return (float)Math.sqrt(f);
    }

    public static float sqrt(double d) {
        return (float)Math.sqrt(d);
    }

    public static int floor_float(float f) {
        int i = (int)f;
        return f >= (float)i ? i : i - 1;
    }

    public static int floor(double d) {
        int truncated = (int)d;
        return d >= (double)truncated ? truncated : truncated - 1;
    }

    public static int ceil(double d) {
        int truncated = (int)d;
        return d == (double)truncated ? truncated : truncated + 1;
    }

    public static int round(double d) {
        int truncated = (int)d;
        return d <= (double)truncated + 0.5 ? truncated : truncated + 1;
    }

    public static float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    public static double abs_max(double d, double d1) {
        if (d < 0.0) {
            d = -d;
        }
        if (d1 < 0.0) {
            d1 = -d1;
        }
        return Math.max(d, d1);
    }

    public static int bucketInt(int value, int bucket) {
        if (value < 0) {
            return -((-value - 1) / bucket) - 1;
        }
        return value / bucket;
    }

    public static double clamp(double value, double min, double max) {
        if (value > max) {
            return max;
        }
        return Math.max(value, min);
    }

    public static float clamp(float value, float min, float max) {
        if (value > max) {
            return max;
        }
        return Math.max(value, min);
    }

    public static int clamp(int value, int min, int max) {
        if (value > max) {
            return max;
        }
        return Math.max(value, min);
    }

    public static byte clamp(byte value, byte min, byte max) {
        if (value > max) {
            return max;
        }
        return (byte)Math.max(value, min);
    }

    public static float lerp(float a, float b, float amount) {
        return a + (b - a) * amount;
    }

    public static double lerp(double a, double b, double amount) {
        return a + (b - a) * amount;
    }

    public static float unlerp(float a, float b, float value) {
        return (value - a) / (b - a);
    }

    public static double unlerp(double a, double b, double value) {
        return (value - a) / (b - a);
    }

    public static float getInterpolate(float[] array, float index) {
        int index0 = (int)index;
        if ((float)index0 == index) {
            return array[index0];
        }
        int index1 = index0 + 1;
        float val0 = array[index0];
        float val1 = array[index1];
        return MathHelper.lerp(val0, val1, index - (float)index0);
    }

    public static boolean stringNullOrLengthZero(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    public static int ceilInt(int num, int denom) {
        return (int)Math.ceil((float)num / (float)denom);
    }

    public static double normalizeRotation(double rotation) {
        double rotNorm = MathHelper.unsignedMod(rotation, 360.0);
        if (rotNorm < 180.0) {
            return rotNorm;
        }
        return rotNorm - 360.0;
    }

    public static float normalizeRotation(float rotation) {
        float rotNorm = (float)MathHelper.unsignedMod(rotation, 360.0);
        if (rotNorm < 180.0f) {
            return rotNorm;
        }
        return rotNorm - 360.0f;
    }

    public static double deltaAngle(double a, double b) {
        return MathHelper.unsignedMod(a - b + 180.0, 360.0) - 180.0;
    }

    public static double unsignedMod(double value, double n) {
        return value - Math.floor(value / n) * n;
    }

    public static float smoothstep(float value, float min, float max) {
        float v = MathHelper.clamp((value - min) / (max - min), 0.0f, 1.0f);
        return v * v * (3.0f - 2.0f * v);
    }

    public static float smootherstep(float value, float min, float max) {
        float v = MathHelper.clamp((value - min) / (max - min), 0.0f, 1.0f);
        return v * v * v * (v * (6.0f * v - 15.0f) + 10.0f);
    }

    public static int cantor(int a, int b) {
        return (a + b) * (a + b + 1) / 2 + b;
    }

    public static float toRadians(float angleDegrees) {
        return angleDegrees * DEG_TO_RAD;
    }

    public static float toDegrees(float angleRadians) {
        return angleRadians * RAD_TO_DEG;
    }

    public static int maxAbs(int a, int b) {
        return Math.abs(a) > Math.abs(b) ? a : b;
    }

    @Nullable
    public static Vector3d vecClipX(@NotNull Vector3dc self, @NotNull Vector3dc other, double d, @NotNull Vector3d dest) {
        double diffX = other.x() - self.x();
        double diffY = other.y() - self.y();
        double diffZ = other.z() - self.z();
        if (diffX * diffX < 1.0E-7) {
            return null;
        }
        double d4 = (d - self.x()) / diffX;
        if (d4 < 0.0 || d4 > 1.0) {
            return null;
        }
        return dest.set(self.x() + diffX * d4, self.y() + diffY * d4, self.z() + diffZ * d4);
    }

    @Nullable
    public static Vector3d vecClipY(@NotNull Vector3dc self, @NotNull Vector3dc other, double d, @NotNull Vector3d dest) {
        double diffX = other.x() - self.x();
        double diffY = other.y() - self.y();
        double diffZ = other.z() - self.z();
        if (diffY * diffY < (double)1.0E-7f) {
            return null;
        }
        double d4 = (d - self.y()) / diffY;
        if (d4 < 0.0 || d4 > 1.0) {
            return null;
        }
        return dest.set(self.x() + diffX * d4, self.y() + diffY * d4, self.z() + diffZ * d4);
    }

    @Nullable
    public static Vector3d vecClipZ(@NotNull Vector3dc self, @NotNull Vector3dc other, double d, @NotNull Vector3d dest) {
        double diffX = other.x() - self.x();
        double diffY = other.y() - self.y();
        double diffZ = other.z() - self.z();
        if (diffZ * diffZ < (double)1.0E-7f) {
            return null;
        }
        double d4 = (d - self.z()) / diffZ;
        if (d4 < 0.0 || d4 > 1.0) {
            return null;
        }
        return dest.set(self.x() + diffX * d4, self.y() + diffY * d4, self.z() + diffZ * d4);
    }

    public static double getAABBSize(@NotNull AABBdc self) {
        double dx = self.maxX() - self.minX();
        double dy = self.maxY() - self.minY();
        double dz = self.maxZ() - self.minZ();
        return (dx + dy + dz) / 3.0;
    }

    @NotNull
    public static AABBd aabbExpand(@NotNull AABBdc self, double stretchX, double stretchY, double stretchZ, @NotNull AABBd dest) {
        double minX = self.minX();
        double minY = self.minY();
        double minZ = self.minZ();
        double maxX = self.maxX();
        double maxY = self.maxY();
        double maxZ = self.maxZ();
        if (stretchX < 0.0) {
            minX += stretchX;
        }
        if (stretchX > 0.0) {
            maxX += stretchX;
        }
        if (stretchY < 0.0) {
            minY += stretchY;
        }
        if (stretchY > 0.0) {
            maxY += stretchY;
        }
        if (stretchZ < 0.0) {
            minZ += stretchZ;
        }
        if (stretchZ > 0.0) {
            maxZ += stretchZ;
        }
        return dest.setMin(minX, minY, minZ).setMax(maxX, maxY, maxZ);
    }

    @NotNull
    public static AABBd aabbShrink(@NotNull AABBdc self, double shrinkX, double shrinkY, double shrinkZ, @NotNull AABBd dest) {
        double minX = self.minX();
        double minY = self.minY();
        double minZ = self.minZ();
        double maxX = self.maxX();
        double maxY = self.maxY();
        double maxZ = self.maxZ();
        if (shrinkX < 0.0) {
            minX -= shrinkX;
        }
        if (shrinkX > 0.0) {
            maxX -= shrinkX;
        }
        if (shrinkY < 0.0) {
            minY -= shrinkY;
        }
        if (shrinkY > 0.0) {
            maxY -= shrinkY;
        }
        if (shrinkZ < 0.0) {
            minZ -= shrinkZ;
        }
        if (shrinkZ > 0.0) {
            maxZ -= shrinkZ;
        }
        return dest.setMin(minX, minY, minZ).setMax(maxX, maxY, maxZ);
    }

    @NotNull
    public static AABBd aabbGrow(@NotNull AABBdc self, double x, double y, double z, @NotNull AABBd dest) {
        double minX = self.minX() - x;
        double minY = self.minY() - y;
        double minZ = self.minZ() - z;
        double maxX = self.maxX() + x;
        double maxY = self.maxY() + y;
        double maxZ = self.maxZ() + z;
        return dest.setMin(minX, minY, minZ).setMax(maxX, maxY, maxZ);
    }

    @NotNull
    public static AABBd aabbInsetBoundingBox(@NotNull AABBdc self, double x, double y, double z, @NotNull AABBd dest) {
        double minX = self.minX() + x;
        double minY = self.minY() + y;
        double minZ = self.minZ() + z;
        double maxX = self.maxX() - x;
        double maxY = self.maxY() - y;
        double maxZ = self.maxZ() - z;
        return dest.setMin(minX, minY, minZ).setMax(maxX, maxY, maxZ);
    }

    public static double aabbClipXCollide(@NotNull AABBdc self, @NotNull AABBdc other, double d) {
        double d2;
        double d1;
        if (other.maxY() <= self.minY() || other.minY() >= self.maxY()) {
            return d;
        }
        if (other.maxZ() <= self.minZ() || other.minZ() >= self.maxZ()) {
            return d;
        }
        if (d > 0.0 && other.maxX() <= self.minX() && (d1 = self.minX() - other.maxX()) < d) {
            d = d1;
        }
        if (d < 0.0 && other.minX() >= self.maxX() && (d2 = self.maxX() - other.minX()) > d) {
            d = d2;
        }
        return d;
    }

    public static double aabbClipYCollide(@NotNull AABBdc self, @NotNull AABBdc aabb, double d) {
        double d2;
        double d1;
        if (aabb.maxX() <= self.minX() || aabb.minX() >= self.maxX()) {
            return d;
        }
        if (aabb.maxZ() <= self.minZ() || aabb.minZ() >= self.maxZ()) {
            return d;
        }
        if (d > 0.0 && aabb.maxY() <= self.minY() && (d1 = self.minY() - aabb.maxY()) < d) {
            d = d1;
        }
        if (d < 0.0 && aabb.minY() >= self.maxY() && (d2 = self.maxY() - aabb.minY()) > d) {
            d = d2;
        }
        return d;
    }

    public static double aabbClipZCollide(@NotNull AABBdc self, @NotNull AABBdc aabb, double d) {
        double d2;
        double d1;
        if (aabb.maxX() <= self.minX() || aabb.minX() >= self.maxX()) {
            return d;
        }
        if (aabb.maxY() <= self.minY() || aabb.minY() >= self.maxY()) {
            return d;
        }
        if (d > 0.0 && aabb.maxZ() <= self.minZ() && (d1 = self.minZ() - aabb.maxZ()) < d) {
            d = d1;
        }
        if (d < 0.0 && aabb.minZ() >= self.maxZ() && (d2 = self.maxZ() - aabb.minZ()) > d) {
            d = d2;
        }
        return d;
    }

    @Nullable
    public static HitResult.Clip aabbClip(@NotNull AABBdc self, @NotNull Vector3dc start, @NotNull Vector3dc end) {
        Vector3d vMinX = MathHelper.vecClipX(start, end, self.minX(), new Vector3d());
        Vector3d vMaxX = MathHelper.vecClipX(start, end, self.maxX(), new Vector3d());
        Vector3d vMinY = MathHelper.vecClipY(start, end, self.minY(), new Vector3d());
        Vector3d vMaxY = MathHelper.vecClipY(start, end, self.maxY(), new Vector3d());
        Vector3d vMinZ = MathHelper.vecClipZ(start, end, self.minZ(), new Vector3d());
        Vector3d vMaxZ = MathHelper.vecClipZ(start, end, self.maxZ(), new Vector3d());
        if (!MathHelper.aabbContainsX(self, vMinX)) {
            vMinX = null;
        }
        if (!MathHelper.aabbContainsX(self, vMaxX)) {
            vMaxX = null;
        }
        if (!MathHelper.aabbContainsY(self, vMinY)) {
            vMinY = null;
        }
        if (!MathHelper.aabbContainsY(self, vMaxY)) {
            vMaxY = null;
        }
        if (!MathHelper.aabbContainsZ(self, vMinZ)) {
            vMinZ = null;
        }
        if (!MathHelper.aabbContainsZ(self, vMaxZ)) {
            vMaxZ = null;
        }
        Vector3d clipPos = null;
        if (vMinX != null) {
            clipPos = vMinX;
        }
        if (vMaxX != null && (clipPos == null || start.distanceSquared(vMaxX) < start.distanceSquared(clipPos))) {
            clipPos = vMaxX;
        }
        if (vMinY != null && (clipPos == null || start.distanceSquared(vMinY) < start.distanceSquared(clipPos))) {
            clipPos = vMinY;
        }
        if (vMaxY != null && (clipPos == null || start.distanceSquared(vMaxY) < start.distanceSquared(clipPos))) {
            clipPos = vMaxY;
        }
        if (vMinZ != null && (clipPos == null || start.distanceSquared(vMinZ) < start.distanceSquared(clipPos))) {
            clipPos = vMinZ;
        }
        if (vMaxZ != null && (clipPos == null || start.distanceSquared(vMaxZ) < start.distanceSquared(clipPos))) {
            clipPos = vMaxZ;
        }
        if (clipPos == null) {
            return null;
        }
        Side side = Side.NONE;
        if (clipPos == vMinX) {
            side = Side.WEST;
        }
        if (clipPos == vMaxX) {
            side = Side.EAST;
        }
        if (clipPos == vMinY) {
            side = Side.BOTTOM;
        }
        if (clipPos == vMaxY) {
            side = Side.TOP;
        }
        if (clipPos == vMinZ) {
            side = Side.NORTH;
        }
        if (clipPos == vMaxZ) {
            side = Side.SOUTH;
        }
        return new HitResult.Clip(side, clipPos);
    }

    private static boolean aabbContainsX(@NotNull AABBdc self, @Nullable Vector3dc vec3) {
        if (vec3 == null) {
            return false;
        }
        return vec3.y() >= self.minY() && vec3.y() <= self.maxY() && vec3.z() >= self.minZ() && vec3.z() <= self.maxZ();
    }

    private static boolean aabbContainsY(@NotNull AABBdc self, @Nullable Vector3dc vec3) {
        if (vec3 == null) {
            return false;
        }
        return vec3.x() >= self.minX() && vec3.x() <= self.maxX() && vec3.z() >= self.minZ() && vec3.z() <= self.maxZ();
    }

    private static boolean aabbContainsZ(@NotNull AABBdc self, @Nullable Vector3dc vec3) {
        if (vec3 == null) {
            return false;
        }
        return vec3.x() >= self.minX() && vec3.x() <= self.maxX() && vec3.y() >= self.minY() && vec3.y() <= self.maxY();
    }

    static {
        DEG_TO_RAD = (float)Math.toRadians(1.0);
        RAD_TO_DEG = (float)Math.toDegrees(1.0);
        SIN_TABLE = new float[65536];
        for (int i = 0; i < 65536; ++i) {
            MathHelper.SIN_TABLE[i] = (float)Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
    }
}

