/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicOreRedstone
extends BlockLogic {
    public static Int2IntArrayMap variantMap = new Int2IntArrayMap();
    private final boolean illuminated;
    @NotNull
    private final Block<?> normalBlock;
    @NotNull
    private final Block<?> illuminatedBlock;

    public BlockLogicOreRedstone(@NotNull Block<?> block, @Nullable Block<?> parentBlock, @NotNull Material material, boolean illuminated, @NotNull Block<?> normalBlock, @NotNull Block<?> illuminatedBlock) {
        super(block, material);
        this.illuminated = illuminated;
        this.normalBlock = normalBlock;
        this.illuminatedBlock = illuminatedBlock;
        if (parentBlock != null) {
            variantMap.put(parentBlock.id(), block.id());
        }
    }

    @Override
    public int tickDelay() {
        return 30;
    }

    @Override
    public void onAttacked(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @NotNull Side side, double xHit, double yHit) {
        this.lightRedstone(world, tilePos);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        this.lightRedstone(world, tilePos);
        return false;
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        this.lightRedstone(world, tilePos);
    }

    @Override
    public void onEntityWalkedOn(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Entity walker) {
        this.lightRedstone(world, tilePos);
    }

    private void lightRedstone(@NotNull World world, @NotNull TilePosc tilePos) {
        this.spawnParticles(world, tilePos);
        if (!this.illuminated) {
            world.scheduleBlockUpdate(tilePos, this.illuminatedBlock.id(), 20 + world.rand.nextInt(180));
            world.setBlockIdNotify(tilePos, this.illuminatedBlock.id());
        }
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (this.illuminated) {
            world.setBlockIdNotify(tilePos, this.normalBlock.id());
        }
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        return this.illuminated;
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this.normalBlock);
                break;
            }
            case EXPLOSION: 
            case PROPER_TOOL: 
            case PISTON_CRUSH: {
                ItemStack[] itemStackArray3 = new ItemStack[1];
                itemStackArray = itemStackArray3;
                itemStackArray3[0] = new ItemStack(Items.DUST_REDSTONE, 4 + world.rand.nextInt(2));
                break;
            }
            default: {
                itemStackArray = null;
            }
        }
        return itemStackArray;
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        if (this.illuminated) {
            this.spawnParticles(world, tilePos);
        }
    }

    private void spawnParticles(@NotNull World world, @NotNull TilePosc tilePos) {
        Random random = world.rand;
        int brightness = 10;
        double d = 0.0625;
        TilePos queryPos = new TilePos();
        for (int i = 0; i < Direction.directions.length; ++i) {
            Direction dir = Direction.directions[i];
            double px = (double)tilePos.x() + (double)random.nextFloat();
            double py = (double)tilePos.y() + (double)random.nextFloat();
            double pz = (double)tilePos.z() + (double)random.nextFloat();
            if (!world.isBlockOpaqueCube(tilePos.add(dir, queryPos))) {
                switch (dir) {
                    case UP: {
                        py = (double)(tilePos.y() + 1) + 0.0625;
                        break;
                    }
                    case DOWN: {
                        py = (double)tilePos.y() - 0.0625;
                        break;
                    }
                    case SOUTH: {
                        pz = (double)(tilePos.z() + 1) + 0.0625;
                        break;
                    }
                    case NORTH: {
                        pz = (double)tilePos.z() - 0.0625;
                        break;
                    }
                    case EAST: {
                        px = (double)(tilePos.x() + 1) + 0.0625;
                        break;
                    }
                    case WEST: {
                        px = (double)tilePos.x() - 0.0625;
                    }
                }
            }
            if (!(px < (double)tilePos.x() || px > (double)(tilePos.x() + 1) || py < 0.0 || py > (double)(tilePos.y() + 1) || pz < (double)tilePos.z()) && !(pz > (double)(tilePos.z() + 1))) continue;
            world.spawnParticle("reddust", px, py, pz, 0.0, 0.0, 0.0, 10);
        }
    }
}

