/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicAxisAligned;
import net.minecraft.core.block.BlockLogicRepeater;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.ISupportable;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.current.util.BlockState;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBdc;

public class BlockLogicWireRedstone
extends BlockLogic
implements ISupportable {
    public static final int SIGNAL_MIN = 0;
    public static final int SIGNAL_MAX = 15;
    public static final int SIGNAL_STEP = 1;
    public static final int MASK_DIRECTION = 240;
    public static final int MASK_POWER = 15;
    private boolean shouldSignal = true;
    private final Set<TilePos> toUpdate = new HashSet<TilePos>();

    public BlockLogicWireRedstone(@NotNull Block<?> block) {
        super(block, Materials.DECORATION);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        return this.isSupported(world, tilePos, Side.BOTTOM);
    }

    private void updatePowerStrength(@NotNull World world, @NotNull TilePosc tilePos) {
        this.updatePowerStrength(world, tilePos, tilePos);
        ArrayList<TilePos> toUpdate = new ArrayList<TilePos>(this.toUpdate);
        this.toUpdate.clear();
        for (TilePos pos : toUpdate) {
            world.notifyBlocksOfNeighborChange(pos, this.id());
        }
    }

    private void updatePowerStrength(@NotNull World world, @NotNull TilePosc curPos, @NotNull TilePosc lastPos) {
        int strength = world.getBlockData(curPos);
        int newStrength = 0;
        this.shouldSignal = false;
        boolean hasNeighborSignal = world.hasNeighborSignal(curPos);
        this.shouldSignal = true;
        TilePos queryPos = new TilePos();
        if (hasNeighborSignal) {
            newStrength = 15;
        } else {
            for (int i = 0; i < 4; ++i) {
                int checkX = curPos.x();
                int checkY = curPos.y();
                int checkZ = curPos.z();
                switch (i) {
                    case 0: {
                        --checkX;
                        break;
                    }
                    case 1: {
                        ++checkX;
                        break;
                    }
                    case 2: {
                        --checkZ;
                        break;
                    }
                    case 3: {
                        ++checkZ;
                    }
                }
                if (!lastPos.equals(checkX, checkY, checkZ)) {
                    newStrength = this.checkTarget(world, queryPos.set(checkX, checkY, checkZ), newStrength);
                }
                if (world.isBlockNormalCube(queryPos.set(checkX, checkY, checkZ)) && !world.isBlockNormalCube(curPos.up(queryPos))) {
                    if (queryPos.set(checkX, checkY + 1, checkZ).equals(lastPos)) continue;
                    newStrength = this.checkTarget(world, queryPos.set(checkX, checkY + 1, checkZ), newStrength);
                    continue;
                }
                if (world.isBlockNormalCube(queryPos.set(checkX, checkY, checkZ)) || lastPos.equals(checkX, checkY - 1, checkZ)) continue;
                newStrength = this.checkTarget(world, queryPos.set(checkX, checkY - 1, checkZ), newStrength);
            }
            newStrength = newStrength > 0 ? --newStrength : 0;
        }
        if (strength != newStrength) {
            int blockId = world.getBlockId(curPos);
            if (blockId == this.id() || blockId == Blocks.FLUID_LAVA_STILL.id() || blockId == Blocks.FLUID_LAVA_FLOWING.id()) {
                world.noNeighborUpdate = true;
                world.setBlockDataNotify(curPos, newStrength | world.getBlockData(curPos) & 0xF0);
                world.markBlocksDirty(curPos, curPos);
                world.noNeighborUpdate = false;
            }
            for (int i = 0; i < 4; ++i) {
                int checkX = curPos.x();
                int checkY = curPos.y() - 1;
                int checkZ = curPos.z();
                switch (i) {
                    case 0: {
                        --checkX;
                        break;
                    }
                    case 1: {
                        ++checkX;
                        break;
                    }
                    case 2: {
                        --checkZ;
                        break;
                    }
                    case 3: {
                        ++checkZ;
                    }
                }
                if (world.isBlockNormalCube(queryPos.set(checkX, curPos.y(), checkZ))) {
                    checkY += 2;
                }
                int targetStrength = this.checkTarget(world, queryPos.set(checkX, curPos.y(), checkZ), -1);
                newStrength = world.getBlockData(curPos) & 0xF;
                if (newStrength > 0) {
                    --newStrength;
                }
                if (targetStrength >= 0 && targetStrength != newStrength) {
                    this.updatePowerStrength(world, queryPos.set(checkX, curPos.y(), checkZ), curPos);
                }
                targetStrength = this.checkTarget(world, queryPos.set(checkX, checkY, checkZ), -1);
                newStrength = world.getBlockData(curPos) & 0xF;
                if (newStrength > 0) {
                    --newStrength;
                }
                if (targetStrength < 0 || targetStrength == newStrength) continue;
                this.updatePowerStrength(world, queryPos.set(checkX, checkY, checkZ), curPos);
            }
            if (strength == 0 || newStrength == 0) {
                this.toUpdate.add(new TilePos(curPos));
                this.toUpdate.add(curPos.west(new TilePos()));
                this.toUpdate.add(curPos.east(new TilePos()));
                this.toUpdate.add(curPos.down(new TilePos()));
                this.toUpdate.add(curPos.up(new TilePos()));
                this.toUpdate.add(curPos.north(new TilePos()));
                this.toUpdate.add(curPos.south(new TilePos()));
            }
        }
    }

    private void checkCornerChangeAt(@NotNull World world, @NotNull TilePosc tilePos) {
        if (world.getBlockId(tilePos) == this.id()) {
            TilePos queryPos = new TilePos();
            world.notifyBlocksOfNeighborChange(tilePos, this.id());
            world.notifyBlocksOfNeighborChange(tilePos.west(queryPos), this.id());
            world.notifyBlocksOfNeighborChange(tilePos.east(queryPos), this.id());
            world.notifyBlocksOfNeighborChange(tilePos.north(queryPos), this.id());
            world.notifyBlocksOfNeighborChange(tilePos.south(queryPos), this.id());
            world.notifyBlocksOfNeighborChange(tilePos.up(queryPos), this.id());
            world.notifyBlocksOfNeighborChange(tilePos.down(queryPos), this.id());
        }
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        super.onPlacedByWorld(world, tilePos);
        if (world.isClientSide) {
            return;
        }
        TilePos queryPos = new TilePos();
        world.getWireHandler().onWireAdded(tilePos);
        world.notifyBlocksOfNeighborChange(tilePos.up(queryPos), this.id());
        world.notifyBlocksOfNeighborChange(tilePos.down(queryPos), this.id());
        this.checkCornerChangeAt(world, tilePos.west(queryPos));
        this.checkCornerChangeAt(world, tilePos.east(queryPos));
        this.checkCornerChangeAt(world, tilePos.north(queryPos));
        this.checkCornerChangeAt(world, tilePos.south(queryPos));
        if (world.isBlockNormalCube(tilePos.west(queryPos))) {
            this.checkCornerChangeAt(world, tilePos.west(queryPos).up(queryPos));
        } else {
            this.checkCornerChangeAt(world, tilePos.west(queryPos).down(queryPos));
        }
        if (world.isBlockNormalCube(tilePos.east(queryPos))) {
            this.checkCornerChangeAt(world, tilePos.east(queryPos).up(queryPos));
        } else {
            this.checkCornerChangeAt(world, tilePos.east(queryPos).down(queryPos));
        }
        if (world.isBlockNormalCube(tilePos.north(queryPos))) {
            this.checkCornerChangeAt(world, tilePos.north(queryPos).up(queryPos));
        } else {
            this.checkCornerChangeAt(world, tilePos.north(queryPos).down(queryPos));
        }
        if (world.isBlockNormalCube(tilePos.south(queryPos))) {
            this.checkCornerChangeAt(world, tilePos.south(queryPos).up(queryPos));
        } else {
            this.checkCornerChangeAt(world, tilePos.south(queryPos).down(queryPos));
        }
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        super.onRemoved(world, tilePos, data);
        if (world.isClientSide) {
            return;
        }
        TilePos queryPos = new TilePos();
        world.notifyBlocksOfNeighborChange(tilePos.up(queryPos), this.id());
        world.notifyBlocksOfNeighborChange(tilePos.down(queryPos), this.id());
        world.getWireHandler().onWireRemoved(tilePos, new BlockState(this.id(), world.getBlockData(tilePos)));
        this.checkCornerChangeAt(world, tilePos.west(queryPos));
        this.checkCornerChangeAt(world, tilePos.east(queryPos));
        this.checkCornerChangeAt(world, tilePos.north(queryPos));
        this.checkCornerChangeAt(world, tilePos.south(queryPos));
        if (world.isBlockNormalCube(tilePos.west(queryPos))) {
            this.checkCornerChangeAt(world, tilePos.west(queryPos).up(queryPos));
        } else {
            this.checkCornerChangeAt(world, tilePos.west(queryPos).down(queryPos));
        }
        if (world.isBlockNormalCube(tilePos.east(queryPos))) {
            this.checkCornerChangeAt(world, tilePos.east(queryPos).up(queryPos));
        } else {
            this.checkCornerChangeAt(world, tilePos.east(queryPos).down(queryPos));
        }
        if (world.isBlockNormalCube(tilePos.north(queryPos))) {
            this.checkCornerChangeAt(world, tilePos.north(queryPos).up(queryPos));
        } else {
            this.checkCornerChangeAt(world, tilePos.north(queryPos).down(queryPos));
        }
        if (world.isBlockNormalCube(tilePos.south(queryPos))) {
            this.checkCornerChangeAt(world, tilePos.south(queryPos).up(queryPos));
        } else {
            this.checkCornerChangeAt(world, tilePos.south(queryPos).down(queryPos));
        }
    }

    private int checkTarget(@NotNull World world, @NotNull TilePos tilePos, int sourceStrength) {
        if (world.getBlockId(tilePos) != this.id()) {
            return sourceStrength;
        }
        int targetStrength = world.getBlockData(tilePos) & 0xF;
        return Math.max(targetStrength, sourceStrength);
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, int id) {
        if (world.isClientSide || world.getWireHandler().onWireUpdated(tilePos)) {
            return;
        }
        int strength = world.getBlockData(tilePos);
        if (!this.canPlaceAt(world, tilePos)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, strength, null, null);
            world.setBlockIdNotify(tilePos, 0);
        } else {
            this.updatePowerStrength(world, tilePos);
        }
        super.onNeighborChanged(world, tilePos, id);
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Items.DUST_REDSTONE)};
    }

    @Override
    public boolean isEmittingDirectSignal(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return this.shouldSignal && this.isEmittingSignal(world, tilePos, side);
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        boolean posZShouldConnectTo;
        if (!this.shouldSignal) {
            return false;
        }
        int data = source.getBlockData(tilePos);
        if ((data & 0xF) == 0) {
            return false;
        }
        if (side == Side.TOP) {
            return true;
        }
        TilePos queryPos = new TilePos();
        boolean negXShouldConnectTo = BlockLogicWireRedstone.shouldConnectTo(source, tilePos.add(-1, 0, 0, queryPos), Side.WEST) || !source.isBlockNormalCube(tilePos.add(-1, 0, 0, queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(-1, -1, 0, queryPos), Side.NONE, Side.BOTTOM);
        boolean posXShouldConnectTo = BlockLogicWireRedstone.shouldConnectTo(source, tilePos.add(1, 0, 0, queryPos), Side.EAST) || !source.isBlockNormalCube(tilePos.add(1, 0, 0, queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(1, -1, 0, queryPos), Side.NONE, Side.BOTTOM);
        boolean negZShouldConnectTo = BlockLogicWireRedstone.shouldConnectTo(source, tilePos.add(0, 0, -1, queryPos), Side.NORTH) || !source.isBlockNormalCube(tilePos.add(0, 0, -1, queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(0, -1, -1, queryPos), Side.NONE, Side.BOTTOM);
        boolean bl = posZShouldConnectTo = BlockLogicWireRedstone.shouldConnectTo(source, tilePos.add(0, 0, 1, queryPos), Side.SOUTH) || !source.isBlockNormalCube(tilePos.add(0, 0, 1, queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(0, -1, 1, queryPos), Side.NONE, Side.BOTTOM);
        if (!source.isBlockNormalCube(tilePos.up(queryPos))) {
            if (source.isBlockNormalCube(tilePos.add(-1, 0, 0, queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(-1, 1, 0, queryPos), Side.NONE, Side.TOP)) {
                negXShouldConnectTo = true;
            }
            if (source.isBlockNormalCube(tilePos.add(1, 0, 0, queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(-1, 1, 0, queryPos), Side.NONE, Side.TOP)) {
                posXShouldConnectTo = true;
            }
            if (source.isBlockNormalCube(tilePos.add(0, 0, -1, queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(-1, 1, 0, queryPos), Side.NONE, Side.TOP)) {
                negZShouldConnectTo = true;
            }
            if (source.isBlockNormalCube(tilePos.add(0, 0, 1, queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(-1, 1, 0, queryPos), Side.NONE, Side.TOP)) {
                posZShouldConnectTo = true;
            }
        }
        if (source instanceof World) {
            int newDirectionEast;
            int newDirectionWest;
            int newDirectionSouth;
            World world = (World)source;
            int direction = (data & 0xF0) >> 4;
            int newDirectionNorth = negZShouldConnectTo ? 1 : 0;
            int newDirection = newDirectionNorth | (newDirectionSouth = (posZShouldConnectTo ? 1 : 0) << 1) | (newDirectionWest = (negXShouldConnectTo ? 1 : 0) << 2) | (newDirectionEast = (posXShouldConnectTo ? 1 : 0) << 3);
            if (direction != newDirection) {
                data &= 0xFFFFFF0F;
                world.setBlockData(tilePos, data |= newDirection << 4);
            }
        }
        boolean isXConnected = posXShouldConnectTo || negXShouldConnectTo;
        boolean isZConnected = posZShouldConnectTo || negZShouldConnectTo;
        return !isZConnected && !isXConnected && side.getAxis() != Axis.Y || side == Side.SOUTH && negZShouldConnectTo || side == Side.NORTH && posZShouldConnectTo || side == Side.EAST && negXShouldConnectTo || side == Side.WEST && posXShouldConnectTo || side == Side.NORTH && negZShouldConnectTo && !isXConnected || side == Side.SOUTH && posZShouldConnectTo && !isXConnected || side == Side.WEST && negXShouldConnectTo && !isZConnected || side == Side.EAST && posXShouldConnectTo && !isZConnected;
    }

    @Override
    public boolean isSignalSource() {
        return this.shouldSignal;
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        int meta = world.getBlockData(tilePos) & 0xF;
        if (meta == 0) {
            return;
        }
        double px = (double)tilePos.x() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double py = (double)tilePos.y() + 0.0625;
        double pz = (double)tilePos.z() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        int redstoneBrightness = meta & 0xF;
        world.spawnParticle("reddust", px, py, pz, 0.0, 0.0, 0.0, redstoneBrightness);
    }

    @Deprecated
    public static boolean shouldConnectTo(@NotNull WorldSource worldSource, int x, int y, int z, @NotNull Side side) {
        return BlockLogicWireRedstone.shouldConnectTo(worldSource, new TilePos(x, y, z), side);
    }

    public static boolean shouldConnectTo(@NotNull WorldSource source, @NotNull TilePos tilePos, @NotNull Side side) {
        Block<?> block = source.getBlock(tilePos);
        if (block == null) {
            return false;
        }
        if (block == Blocks.WIRE_REDSTONE) {
            return true;
        }
        if (block == Blocks.PUMPKIN_REDSTONE) {
            if (side == Side.NONE || side.isVertical()) {
                return false;
            }
            return Side.getSideById(source.getBlockData(tilePos)).getOpposite() == side;
        }
        if (block == Blocks.MATCHER || block == Blocks.MATCHER_ACTIVE) {
            return BlockLogicAxisAligned.metaToAxis(source.getBlockData(tilePos)) != side.getAxis();
        }
        if (block == Blocks.REPEATER_IDLE || block == Blocks.REPEATER_ACTIVE) {
            Side direction = BlockLogicRepeater.getSideFromMeta(source.getBlockData(tilePos));
            return side == direction || side == direction.getOpposite();
        }
        return block.isSignalSource();
    }

    @Deprecated
    public static boolean shouldConnectToDiagonal(@NotNull WorldSource worldSource, int x, int y, int z, @NotNull Side side1, @NotNull Side side2) {
        return BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, new TilePos(x, y, z), side1, side2);
    }

    public static boolean shouldConnectToDiagonal(@NotNull WorldSource worldSource, @NotNull TilePos tilePos, @NotNull Side side1, @NotNull Side side2) {
        if (side2 != Side.TOP && side2 != Side.BOTTOM) {
            return false;
        }
        int blockId = worldSource.getBlockId(tilePos);
        return blockId == Blocks.WIRE_REDSTONE.id();
    }

    @Override
    @NotNull
    public ISupport getSupportConstraint(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return side == Side.BOTTOM ? PartialSupport.INSTANCE.center() : PartialSupport.INSTANCE;
    }
}

