/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.piston.BlockLogicPistonBase;
import net.minecraft.core.block.piston.BlockLogicPistonHead;
import net.minecraft.core.block.piston.BlockLogicPistonMoving;
import net.minecraft.core.block.piston.TileEntityMovingPistonBlock;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockLogicPistonBaseSticky
extends BlockLogicPistonBase {
    public BlockLogicPistonBaseSticky(@NotNull Block<?> block, int maxPushedBlocks) {
        super(block, maxPushedBlocks);
    }

    @Override
    public void retractEvent(@NotNull World world, @NotNull TilePosc tilePos, int data, @NotNull Direction direction) {
        TileEntityMovingPistonBlock movingPistonBlock;
        TileEntity tileEntity;
        TilePos posDir = tilePos.add(direction, new TilePos());
        TileEntity tileEntity2 = world.getTileEntity(posDir);
        if (tileEntity2 instanceof TileEntityMovingPistonBlock) {
            TileEntityMovingPistonBlock moving = (TileEntityMovingPistonBlock)tileEntity2;
            if (!moving.isExtending()) {
                moving.finalTick();
            } else {
                world.setBlockId(posDir, 0);
            }
        }
        world.setBlockIdData(tilePos, Blocks.PISTON_MOVING.id(), direction.getId());
        world.replaceTileEntity(tilePos, BlockLogicPistonMoving.createTileEntity(this.block.id(), direction.getId(), null, direction, false, true));
        TilePos pos1 = new TilePos(tilePos.x() + direction.getOffsetX() * 2, tilePos.y() + direction.getOffsetY() * 2, tilePos.z() + direction.getOffsetZ() * 2);
        int retractId = world.getBlockId(pos1);
        int retactMeta = world.getBlockData(pos1);
        TileEntity retractEntity = world.getTileEntity(pos1);
        boolean pulledMoving = false;
        if (retractId == Blocks.PISTON_MOVING.id() && (tileEntity = world.getTileEntity(pos1)) instanceof TileEntityMovingPistonBlock && (movingPistonBlock = (TileEntityMovingPistonBlock)tileEntity).getDirection() == direction && movingPistonBlock.isExtending()) {
            movingPistonBlock.finalTick();
            retractId = movingPistonBlock.getMovedId();
            retactMeta = movingPistonBlock.getMovedData();
            retractEntity = movingPistonBlock.getMovedEntity();
            pulledMoving = true;
        }
        Block<?> retractedBlock = Blocks.getBlock(retractId);
        TilePos pos2 = new TilePos(tilePos);
        if (!pulledMoving && retractedBlock != null && this.isPushable(retractId, world, pos1, false) && (retractedBlock.getPistonPushReaction(world, pos1) == 0 || retractedBlock.getLogic() instanceof BlockLogicPistonBase)) {
            if (!(retractEntity instanceof TileEntityMovingPistonBlock)) {
                world.removeTileEntity(pos1);
            }
            world.setBlockId(pos1, 0);
            pos2.x += direction.getOffsetX();
            pos2.y += direction.getOffsetY();
            pos2.z += direction.getOffsetZ();
            world.setBlockIdData(pos2, Blocks.PISTON_MOVING.id(), retactMeta);
            world.replaceTileEntity(pos2, BlockLogicPistonMoving.createTileEntity(retractId, retactMeta, retractEntity, direction, false, false));
            world.notifyBlockChange(pos1, 0);
        } else if (!pulledMoving) {
            world.setBlockIdNotify(posDir, 0);
        }
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)pos2.x + 0.5, (double)pos2.y + 0.5, (double)pos2.z + 0.5, "tile.piston.in", 0.5f, world.rand.nextFloat() * 0.15f + 0.6f);
    }

    @Override
    public void createPistonHeadAt(@NotNull World world, @NotNull TilePos tilePos, int data, @NotNull Direction direction) {
        world.setBlockIdData(tilePos, Blocks.PISTON_MOVING.id(), BlockLogicPistonHead.setPistonType(1, direction.getId()));
        world.replaceTileEntity(tilePos, BlockLogicPistonMoving.createTileEntity(Blocks.PISTON_HEAD.id(), BlockLogicPistonHead.setPistonType(1, direction.getId()), null, direction, true, false));
    }
}

