/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome.provider;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.world.biome.Biome;
import org.slf4j.Logger;

public abstract class BiomeProvider {
    private static final Logger LOGGER = LogUtils.getLogger();

    public Biome getBiome(int x, int y, int z) {
        Biome[] out = this.getBiomes(null, x, y, z, 1, 1, 1);
        return out[0];
    }

    public double getTemperature(int x, int z) {
        double[] out = this.getTemperatures(null, x, z, 1, 1);
        return out[0];
    }

    public double getHumidity(int x, int z) {
        double[] out = this.getHumidities(null, x, z, 1, 1);
        return out[0];
    }

    public double getVariety(int x, int z) {
        double[] out = this.getVarieties(null, x, z, 1, 1);
        return out[0];
    }

    public double getBiomeness(int x, int y, int z) {
        double[] out = this.getBiomenesses(null, x, y, z, 1, 1, 1);
        return out[0];
    }

    public Biome[] getBiomes(Biome[] biomes, int x, int y, int z, int xSize, int ySize, int zSize) {
        return this.getBiomes(biomes, null, null, null, x, y, z, xSize, ySize, zSize);
    }

    public abstract Biome[] getBiomes(Biome[] var1, double[] var2, double[] var3, double[] var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public abstract double[] getTemperatures(double[] var1, int var2, int var3, int var4, int var5);

    public abstract double[] getHumidities(double[] var1, int var2, int var3, int var4, int var5);

    public abstract double[] getVarieties(double[] var1, int var2, int var3, int var4, int var5);

    public abstract double[] getBiomenesses(double[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract Biome lookupBiome(double var1, double var3, double var5, double var7);

    protected void generateBiomeDistributionStats() {
        int lastReport = 0;
        int sizeChunks = 2048;
        int chunksSampled = 0;
        Object2IntArrayMap<Biome> biomeOccurrenceMap = new Object2IntArrayMap<Biome>();
        double tempAcc = 0.0;
        double humAcc = 0.0;
        LOGGER.info("Sampling 4194304 chunks for biome test...");
        for (int x = -1024; x < 1024; ++x) {
            for (int z = -1024; z < 1024; ++z) {
                int pctg = (int)((float)chunksSampled / 4194304.0f * 100.0f);
                if (pctg != lastReport) {
                    LOGGER.info("{}% complete...", (Object)pctg);
                    lastReport = pctg;
                }
                tempAcc += this.getTemperature(x * 16, z * 16);
                humAcc += this.getHumidity(x * 16, z * 16);
                Biome biome = this.getBiome(x * 16, 64, z * 16);
                biomeOccurrenceMap.put(biome, biomeOccurrenceMap.getOrDefault((Object)biome, 0) + 1);
                ++chunksSampled;
            }
        }
        LOGGER.info("Seed analysis sampling 4194304 chunks:");
        LOGGER.info("    Average temperature: {}", (Object)String.format("%.2f", tempAcc / 4194304.0));
        LOGGER.info("    Average humidity: {}", (Object)String.format("%.2f", humAcc / 4194304.0));
        LOGGER.info("    Biome distribution:");
        for (Biome biome : Registries.BIOMES) {
            float pctg;
            if (biomeOccurrenceMap.containsKey(biome)) {
                pctg = (float)biomeOccurrenceMap.getInt(biome) / 4194304.0f;
                pctg *= 100.0f;
            } else {
                pctg = 0.0f;
            }
            LOGGER.info("        {}: {}%", (Object)Registries.BIOMES.getKey(biome), (Object)String.format("%.2f", Float.valueOf(pctg)));
        }
    }
}

