/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicFlowerStackable;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBdc;

public class BlockLogicFlower
extends BlockLogic
implements IBonemealable {
    public static final int MASK_PERMANENT = 128;
    public boolean killedByWeather = false;
    public boolean canBeBonemealed = false;

    public BlockLogicFlower(@NotNull Block<?> block) {
        super(block, Materials.PLANT);
        block.setTicking(true);
        float f = 0.2f;
        this.setBlockBounds(0.3f, 0.0, 0.3f, 0.7f, 0.6f, 0.7f);
    }

    @NotNull
    public final BlockLogicFlower setKilledByWeather() {
        this.killedByWeather = true;
        return this;
    }

    @NotNull
    public final BlockLogicFlower setBonemealable() {
        this.canBeBonemealed = true;
        return this;
    }

    @Override
    public int getPlacedData(@Nullable Player player, @NotNull ItemStack itemStack, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        return 128;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        return super.canPlaceAt(world, tilePos) && this.mayPlaceOn(world.getBlockId(tilePos.down(new TilePos())));
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    protected boolean mayPlaceOn(int blockId) {
        @Nullable Block<?> block = Blocks.getBlock(blockId);
        return block != null && block.hasTag(BlockTags.GROWS_FLOWERS);
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, int id) {
        super.onNeighborChanged(world, tilePos, id);
        this.checkAlive(world, tilePos);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        this.checkAlive(world, tilePos);
        if (world.getGameRuleValue(GameRules.DO_SEASONAL_GROWTH).booleanValue() && world.getSeasonManager().getCurrentSeason() != null && !BlockLogicFlower.isPermanent(world.getBlockData(tilePos)) && world.getSeasonManager().getCurrentSeason().killFlowers && this.killedByWeather && rand.nextInt(256) == 0) {
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    protected final void checkAlive(@NotNull World world, @NotNull TilePosc tilePos) {
        if (!this.canStay(world, tilePos)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePosc tilePos) {
        return (world.getFullBlockLightValue(tilePos) >= 8 || world.canBlockSeeSky(tilePos)) && this.mayPlaceOn(world.getBlockId(tilePos.down(new TilePos())));
    }

    public static boolean isPermanent(int metadata) {
        return (metadata & 0x80) > 0;
    }

    public static int setPermanent(int metadata, boolean permanent) {
        return metadata & 0xFFFFFF7F | (permanent ? 128 : 0);
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean onBonemealUsed(@NotNull ItemStack itemStack, @Nullable Player player, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        Random rand = world.rand;
        if (!world.isClientSide && this.canBeBonemealed && itemStack.consumeItem(player)) {
            int meta;
            if (Block.hasLogicClass(world.getBlock(tilePos), BlockLogicFlowerStackable.class) && BlockLogicFlowerStackable.getStackCount(meta = world.getBlockData(tilePos)) < 3) {
                world.setBlockDataNotify(tilePos, BlockLogicFlowerStackable.setStackCount(meta, BlockLogicFlowerStackable.getStackCount(meta) + 1));
            }
            TilePos queryPos = new TilePos();
            block0: for (int i = 0; i < 128; ++i) {
                int checkX = tilePos.x();
                int checkY = tilePos.y();
                int checkZ = tilePos.z();
                for (int j = 0; j < i / 16; ++j) {
                    int blockId = world.getBlockId(queryPos.set(checkX += rand.nextInt(3) - 1, (checkY += (rand.nextInt(3) - 1) * rand.nextInt(3) / 2) - 1, checkZ += rand.nextInt(3) - 1));
                    if (!this.mayPlaceOn(blockId)) continue block0;
                }
                @Nullable Block<?> b = world.getBlock(queryPos.set(checkX, checkY, checkZ));
                if (Block.hasLogicClass(b, BlockLogicFlowerStackable.class)) {
                    int meta2 = world.getBlockData(queryPos.set(checkX, checkY, checkZ));
                    if (BlockLogicFlowerStackable.getStackCount(meta2) >= 3) continue;
                    world.setBlockDataNotify(queryPos.set(checkX, checkY, checkZ), BlockLogicFlowerStackable.setStackCount(meta2, BlockLogicFlowerStackable.getStackCount(meta2) + 1));
                    continue;
                }
                if (b != null || !((double)rand.nextFloat() > 0.75)) continue;
                world.setBlockIdNotify(queryPos.set(checkX, checkY, checkZ), this.block.id());
            }
            return true;
        }
        return this.canBeBonemealed;
    }
}

