/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLeavesBase;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.season.Seasons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicLeavesCacao
extends BlockLogicLeavesBase
implements IBonemealable {
    public static final int MASK_GROWTH_DATA = 240;
    public static final int MAX_GROWTH_STATE = 4;
    static final int BEAN_GROWTH_RATE = 50;

    public BlockLogicLeavesCacao(@NotNull Block<?> block) {
        super(block, Materials.LEAVES, Blocks.SAPLING_CACAO);
        block.setTicking(true);
    }

    public boolean canBeansGrow(@NotNull World world, @NotNull TilePosc tilePos) {
        TilePos queryPos = new TilePos(tilePos);
        for (int x = tilePos.x() - 1; x < tilePos.x() + 1; ++x) {
            for (int z = tilePos.z() - 1; z < tilePos.z() + 1; ++z) {
                if (world.getBlock(queryPos.set(x, tilePos.y(), z)) != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        if (dropCause == EnumDropCause.PICK_BLOCK || dropCause == EnumDropCause.SILK_TOUCH) {
            return new ItemStack[]{new ItemStack(this)};
        }
        int growthRate = BlockLogicLeavesCacao.getGrowthRate(data);
        if (growthRate > 1) {
            return new ItemStack[]{new ItemStack(Items.DYE, MathHelper.ceil((double)growthRate / 2.0), DyeColor.BROWN.itemMeta)};
        }
        return super.getBreakResult(world, dropCause, data, tileEntity);
    }

    @Override
    public void onAttacked(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @NotNull Side side, double xHit, double yHit) {
        this.onInteracted(world, tilePos, player, side, xHit, yHit);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        return this.harvest(world, tilePos, player);
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        this.harvest(world, tilePos, null);
    }

    public boolean harvest(@NotNull World world, @NotNull TilePosc tilePos, @Nullable Player player) {
        int meta = world.getBlockData(tilePos);
        int growthRate = BlockLogicLeavesCacao.getGrowthRate(meta);
        if (growthRate > 0) {
            if (player != null) {
                world.playSoundAtEntity(player, player, "item.pickup", 1.0f, 1.0f);
            }
            if (!world.isClientSide) {
                this.dropWithCause(world, EnumDropCause.WORLD, tilePos, meta, null, null);
            }
            world.setBlockDataNotify(tilePos, BlockLogicLeavesCacao.setGrowthRate(meta, 0));
            world.scheduleBlockUpdate(tilePos, Blocks.LEAVES_CACAO.id(), this.tickDelay());
            return true;
        }
        return false;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        super.updateTick(world, tilePos, rand, isRandomTick);
        int meta = world.getBlockData(tilePos);
        int growthRate = BlockLogicLeavesCacao.getGrowthRate(meta);
        if (rand.nextInt(50) == 0) {
            if (world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_SUMMER) {
                if (this.canBeansGrow(world, tilePos) && growthRate < 4) {
                    world.setBlockDataNotify(tilePos, BlockLogicLeavesCacao.setGrowthRate(meta, ++growthRate));
                    world.scheduleBlockUpdate(tilePos, Blocks.LEAVES_CACAO.id(), this.tickDelay());
                }
            } else if (growthRate > 0) {
                world.setBlockDataNotify(tilePos, BlockLogicLeavesCacao.setGrowthRate(meta, 0));
                world.scheduleBlockUpdate(tilePos, Blocks.LEAVES_CACAO.id(), this.tickDelay());
            }
        }
    }

    @Override
    public boolean onBonemealUsed(@NotNull ItemStack itemStack, @Nullable Player player, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        int meta = world.getBlockData(tilePos);
        if (BlockLogicLeavesCacao.getGrowthRate(meta) < 4) {
            if (!world.isClientSide) {
                if (world.getSeasonManager().getCurrentSeason() != Seasons.OVERWORLD_SUMMER) {
                    return true;
                }
                world.setBlockDataNotify(tilePos, BlockLogicLeavesCacao.setGrowthRate(meta, 4));
                if (player == null || player.getGamemode().consumeBlocks()) {
                    --itemStack.stackSize;
                }
            }
            return true;
        }
        return false;
    }

    public static int getGrowthRate(int meta) {
        return (meta & 0xF0) >> 4;
    }

    public static int setGrowthRate(int meta, int growthRate) {
        return meta & 0xFFFFFF0F | growthRate << 4 & 0xF0;
    }
}

