/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.season.SeasonManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface WorldSource {
    public int getHeightBlocks();

    public int getBlockId(@NotNull TilePosc var1);

    @Deprecated
    default public int getBlockId(int x, int y, int z) {
        return this.getBlockId(new TilePos(x, y, z));
    }

    @Nullable
    public Block<?> getBlock(@NotNull TilePosc var1);

    @Deprecated
    @Nullable
    default public Block<?> getBlock(int x, int y, int z) {
        return this.getBlock(new TilePos(x, y, z));
    }

    @Nullable
    public TileEntity getTileEntity(@NotNull TilePosc var1);

    @Deprecated
    @Nullable
    default public TileEntity getTileEntity(int x, int y, int z) {
        return this.getTileEntity(new TilePos(x, y, z));
    }

    @Nullable
    default public <T> T getBlockLogic(@NotNull TilePosc tilePos, @NotNull Class<T> logicClass) {
        @Nullable Block<?> block = this.getBlock(tilePos);
        if (block == null) {
            return null;
        }
        @NotNull ? logic = block.getLogic();
        if (logicClass.isAssignableFrom(logic.getClass())) {
            return logicClass.cast(logic);
        }
        return null;
    }

    @Deprecated
    @Nullable
    default public <T> T getBlockLogic(int x, int y, int z, @NotNull Class<T> logicClass) {
        return this.getBlockLogic(new TilePos(x, y, z), logicClass);
    }

    public float getBrightness(@NotNull TilePosc var1, int var2);

    @Deprecated
    default public float getBrightness(int x, int y, int z, int lightEmission) {
        return this.getBrightness(new TilePos(x, y, z), lightEmission);
    }

    public int getLightmapCoord(@NotNull TilePosc var1, int var2);

    @Deprecated
    default public int getLightmapCoord(int x, int y, int z, int lightEmission) {
        return this.getLightmapCoord(new TilePos(x, y, z), lightEmission);
    }

    public int getLightmapCoord(int var1, int var2);

    public float getLightBrightness(@NotNull TilePosc var1);

    @Deprecated
    default public float getLightBrightness(int x, int y, int z) {
        return this.getLightBrightness(new TilePos(x, y, z));
    }

    public int getBlockData(@NotNull TilePosc var1);

    @Deprecated
    default public int getBlockMetadata(int x, int y, int z) {
        return this.getBlockData(new TilePos(x, y, z));
    }

    @NotNull
    public Material getBlockMaterial(@NotNull TilePosc var1);

    @Deprecated
    @NotNull
    default public Material getBlockMaterial(int x, int y, int z) {
        return this.getBlockMaterial(new TilePos(x, y, z));
    }

    public boolean isBlockOpaqueCube(@NotNull TilePosc var1);

    @Deprecated
    default public boolean isBlockOpaqueCube(int x, int y, int z) {
        return this.isBlockOpaqueCube(new TilePos(x, y, z));
    }

    public boolean isBlockNormalCube(@NotNull TilePosc var1);

    @Deprecated
    default public boolean isBlockNormalCube(int x, int y, int z) {
        return this.isBlockNormalCube(new TilePos(x, y, z));
    }

    public double getBlockTemperature(@NotNull TilePosc var1);

    @Deprecated
    default public double getBlockTemperature(int x, int z) {
        return this.getBlockTemperature(new TilePos(x, 0, z));
    }

    public double getBlockHumidity(@NotNull TilePosc var1);

    @Deprecated
    default public double getBlockHumidity(int x, int z) {
        return this.getBlockHumidity(new TilePos(x, 0, z));
    }

    public double getBlockVariety(@NotNull TilePosc var1);

    @Deprecated
    default public double getBlockVariety(int x, int z) {
        return this.getBlockVariety(new TilePos(x, 0, z));
    }

    @NotNull
    public SeasonManager getSeasonManager();

    @NotNull
    public Biome getBlockBiome(@NotNull TilePosc var1);

    @Deprecated
    @Nullable
    default public Biome getBlockBiome(int x, int y, int z) {
        return this.getBlockBiome(new TilePos(x, y, z));
    }

    public int getSavedLightValue(@NotNull LightLayer var1, @NotNull TilePosc var2);

    @Deprecated
    default public int getSavedLightValue(@NotNull LightLayer layer, int x, int y, int z) {
        return this.getSavedLightValue(layer, new TilePos(x, y, z));
    }

    public boolean isRetro();
}

