/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.ChunkTilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBdc;

public class EmptyChunk
extends Chunk {
    public EmptyChunk(@NotNull World world, @NotNull ChunkPos chunkPos) {
        super(world, chunkPos);
        this.neverSave = true;
    }

    @Deprecated
    public EmptyChunk(@NotNull World world, int x, int z) {
        this(world, new ChunkPos(x, z));
    }

    @Override
    public int getHeightValue(int x, int z) {
        return 0;
    }

    @Override
    public void recalcHeightmapOnly() {
    }

    @Override
    public void recalcHeightmapAndLightmap() {
    }

    @Override
    public int getBlockId(@NotNull ChunkTilePosc tilePos) {
        return 0;
    }

    @Override
    public boolean setBlockIdData(@NotNull ChunkTilePosc tilePos, int id, int data) {
        return true;
    }

    @Override
    public boolean setBlockId(@NotNull ChunkTilePosc tilePos, int id) {
        return true;
    }

    @Override
    public int getBlockData(@NotNull ChunkTilePosc tilePos) {
        return 0;
    }

    @Override
    public boolean setBlockData(@NotNull ChunkTilePosc tilePos, int value) {
        return true;
    }

    @Override
    public int getBrightness(@NotNull LightLayer lightLayer, @NotNull ChunkTilePosc tilePos) {
        return 0;
    }

    @Override
    public void setBrightness(@NotNull LightLayer lightLayer, @NotNull ChunkTilePosc tilePos, int value) {
    }

    @Override
    public int getRawBrightness(@NotNull ChunkTilePosc tilePos, int subtractedSkyLight) {
        return 0;
    }

    @Override
    public void addEntity(@NotNull Entity entity) {
    }

    @Override
    public void removeEntity(@NotNull Entity entity) {
    }

    @Override
    public void removeEntityAtIndex(@NotNull Entity entity, int index) {
    }

    @Override
    public boolean canBlockSeeSky(@NotNull ChunkTilePosc tilePos) {
        return false;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(@NotNull ChunkTilePosc tilePos) {
        return null;
    }

    @Override
    public void addTileEntity(@NotNull TileEntity tileEntity) {
    }

    @Override
    public boolean setTileEntity(@NotNull ChunkTilePosc tilePos, @NotNull TileEntity tileEntity) {
        return false;
    }

    @Override
    public void removeTileEntity(@NotNull ChunkTilePosc tilePos) {
    }

    @Override
    public void onLoad() {
    }

    @Override
    public void onUnload() {
    }

    @Override
    public void setChunkModified() {
    }

    @Override
    public void getEntitiesWithin(@Nullable Entity toExclude, @NotNull AABBdc aabb, @NotNull @NotNull List<@NotNull Entity> entities) {
    }

    @Override
    public <T extends Entity> void getEntitiesWithin(@NotNull Class<T> ofClass, @NotNull AABBdc aabb, @NotNull List<T> entities) {
    }

    @Override
    public boolean needsSaving(boolean saveImmediately) {
        return false;
    }

    @Override
    public int setChunkData(byte @NotNull [] data, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int startIndex) {
        int dx = maxX - minX;
        int dy = maxY - minY;
        int dz = maxZ - minZ;
        int chunkSizeBlocks = dx * dy * dz;
        return chunkSizeBlocks * 2 + chunkSizeBlocks + chunkSizeBlocks / 2 * 2;
    }

    @Override
    public int getChunkData(byte @NotNull [] data, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int startIndex) {
        int dx = maxX - minX;
        int dy = maxY - minY;
        int dz = maxZ - minZ;
        int chunkSizeBlocks = dx * dy * dz;
        int dataSize = chunkSizeBlocks * 2 + chunkSizeBlocks + chunkSizeBlocks / 2 * 2;
        Arrays.fill(data, startIndex, startIndex + dataSize, (byte)0);
        return dataSize;
    }

    @Override
    @NotNull
    public Random getChunkRandom(long xor) {
        return new Random(this.world.getRandomSeed() + (long)this.pos.x * (long)this.pos.x * 4987142L + (long)this.pos.x * 5947611L + (long)this.pos.z * (long)this.pos.z * 4392871L + (long)this.pos.z * 389711L ^ xor);
    }

    @Override
    public boolean isChunkEmpty() {
        return true;
    }
}

