/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.world.noise.ImprovedNoise;
import net.minecraft.core.world.noise.LegacyNoiseType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerlinNoise {
    private static final double MAX_2D = Math.sqrt(0.5);
    @NotNull
    private final @NotNull ImprovedNoise @NotNull [] octaves;
    private final int numOctaves;
    final double maxValue;

    public PerlinNoise(long seed, int numOctaves) {
        this(seed, numOctaves, LegacyNoiseType.DEFAULT);
    }

    public PerlinNoise(long seed, int numOctaves, int preOctaves) {
        this(seed, numOctaves, preOctaves, LegacyNoiseType.DEFAULT);
    }

    public PerlinNoise(long seed, int numOctaves, @NotNull LegacyNoiseType legacyNoiseType) {
        this(seed, numOctaves, 0, legacyNoiseType);
    }

    public PerlinNoise(long seed, int numOctaves, int preOctaves, @NotNull LegacyNoiseType legacyNoiseType) {
        int i;
        @NotNull Random random = new Random(seed);
        for (i = 0; i < preOctaves; ++i) {
            random.nextDouble();
            random.nextDouble();
            random.nextDouble();
            for (int j = 0; j < 256; ++j) {
                random.nextInt(256 - j);
            }
        }
        this.numOctaves = numOctaves;
        this.octaves = new ImprovedNoise[numOctaves];
        for (i = 0; i < numOctaves; ++i) {
            this.octaves[i] = new ImprovedNoise(random, legacyNoiseType);
        }
        double maxValue = 0.0;
        double levelScale = 1.0;
        for (int i2 = 0; i2 < this.numOctaves; ++i2) {
            maxValue += MAX_2D / levelScale;
            levelScale /= 2.0;
        }
        this.maxValue = maxValue;
    }

    public double getValue(double x, double y) {
        double lacunarity = 0.5;
        double persistence = 2.0;
        double out = 0.0;
        double frequency = 1.0;
        double amplitude = 1.0;
        for (int i = 0; i < this.numOctaves; ++i) {
            out += this.octaves[i].getValue(x * frequency, y * frequency) * amplitude;
            frequency *= 0.5;
            amplitude *= 2.0;
        }
        return out;
    }

    public double getValue(double x, double y, double z) {
        double lacunarity = 0.5;
        double persistence = 2.0;
        double out = 0.0;
        double frequency = 1.0;
        double amplitude = 1.0;
        for (int i = 0; i < this.numOctaves; ++i) {
            out += this.octaves[i].getValue(x * frequency, y * frequency, z * frequency) * amplitude;
            frequency *= 0.5;
            amplitude *= 2.0;
        }
        return out;
    }

    public double getNormalized(double x, double y) {
        double value = this.getValue(x, y);
        double workingValue = value / this.maxValue;
        workingValue = 0.5 + workingValue / 2.0;
        return workingValue;
    }

    public double @NotNull [] getRegion(double @Nullable [] densityArray, double x, double z, int xSize, int zSize, double scaleX, double scaleZ) {
        return this.getRegion(densityArray, x, 0.0, z, xSize, 1, zSize, scaleX, 1.0, scaleZ);
    }

    public double @NotNull [] getRegion(double @Nullable [] noiseArray, double x, double y, double z, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale) {
        if (noiseArray == null) {
            noiseArray = new double[xSize * ySize * zSize];
        } else {
            Arrays.fill(noiseArray, 0.0);
        }
        double lacunarity = 0.5;
        double persistence = 2.0;
        double frequency = 1.0;
        double amplitude = 1.0;
        for (int i = 0; i < this.numOctaves; ++i) {
            this.octaves[i].add(noiseArray, x, y, z, xSize, ySize, zSize, xScale * frequency, yScale * frequency, zScale * frequency, amplitude);
            frequency *= 0.5;
            amplitude *= 2.0;
        }
        return noiseArray;
    }
}

