/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.world.noise.SimplexNoise;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerlinSimplexNoise {
    @NotNull
    private final @NotNull SimplexNoise @NotNull [] octaves;
    private final int numOctaves;

    public PerlinSimplexNoise(@NotNull Random random, int numOctaves) {
        this.numOctaves = numOctaves;
        this.octaves = new SimplexNoise[numOctaves];
        for (int i = 0; i < numOctaves; ++i) {
            this.octaves[i] = new SimplexNoise(random);
        }
    }

    public double @NotNull [] getRegion(double @Nullable [] out, double x, double z, int xSize, int zSize, double xScale, double zScale, double lacunarity) {
        return this.getRegion(out, x, z, xSize, zSize, xScale, zScale, lacunarity, 0.5);
    }

    public double @NotNull [] getRegion(double @Nullable [] out, double x, double z, int xSize, int zSize, double xScale, double zScale, double lacunarity, double persistence) {
        xScale /= 1.5;
        zScale /= 1.5;
        if (out == null || out.length < xSize * zSize) {
            out = new double[xSize * zSize];
        } else {
            Arrays.fill(out, 0.0);
        }
        double frequency = 1.0;
        double amplitude = 1.0;
        for (int l = 0; l < this.numOctaves; ++l) {
            this.octaves[l].add(out, x, z, xSize, zSize, xScale * frequency, zScale * frequency, 0.55 / amplitude);
            frequency *= lacunarity;
            amplitude *= persistence;
        }
        return out;
    }
}

