/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.ISupportable;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicTorch
extends BlockLogic
implements ISupportable {
    public static final int MASK_DIRECTION = 7;
    public static final int SIDE_NONE = 0;
    public static final int SIDE_WEST = 1;
    public static final int SIDE_EAST = 2;
    public static final int SIDE_NORTH = 3;
    public static final int SIDE_SOUTH = 4;
    public static final int SIDE_BOTTOM = 5;
    public static final int SIDE_TOP = 6;

    public BlockLogicTorch(@NotNull Block<?> block) {
        super(block, Materials.DECORATION);
        block.setTicking(true);
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return null;
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource world, @NotNull TilePosc tilePos) {
        float f = 0.15f;
        int side = world.getBlockData(tilePos) & 7;
        return switch (side) {
            case 1 -> new AABBd(0.0, 0.2f, 0.5f - f, f * 2.0f, 0.8f, 0.5f + f);
            case 2 -> new AABBd(1.0f - f * 2.0f, 0.2f, 0.5f - f, 1.0, 0.8f, 0.5f + f);
            case 3 -> new AABBd(0.5f - f, 0.2f, 0.0, 0.5f + f, 0.8f, f * 2.0f);
            case 4 -> new AABBd(0.5f - f, 0.2f, 1.0f - f * 2.0f, 0.5f + f, 0.8f, 1.0);
            default -> {
                float f1 = 0.1f;
                yield new AABBd(0.4f, 0.0, 0.4f, 0.6f, 0.6f, 0.6f);
            }
        };
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        return this.isSupported(world, tilePos, Side.BOTTOM) || this.isSupported(world, tilePos, Side.NORTH) || this.isSupported(world, tilePos, Side.SOUTH) || this.isSupported(world, tilePos, Side.WEST) || this.isSupported(world, tilePos, Side.EAST);
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        if (side.isHorizontal()) {
            side = side.getOpposite();
        }
        this.onPlacedOnSide(world, tilePos, side, xHit, yHit);
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        int orientation = 0;
        if (side.isHorizontal()) {
            side = side.getOpposite();
        }
        switch (side) {
            case TOP: {
                if (!this.isSupported(world, tilePos, Side.BOTTOM)) break;
                orientation = 5;
                break;
            }
            case NORTH: {
                if (!this.isSupported(world, tilePos, Side.SOUTH)) break;
                orientation = 4;
                break;
            }
            case SOUTH: {
                if (!this.isSupported(world, tilePos, Side.NORTH)) break;
                orientation = 3;
                break;
            }
            case WEST: {
                if (!this.isSupported(world, tilePos, Side.EAST)) break;
                orientation = 2;
                break;
            }
            case EAST: {
                if (!this.isSupported(world, tilePos, Side.WEST)) break;
                orientation = 1;
            }
        }
        if (orientation == 0) {
            orientation = this.getDefaultOrientation(world, tilePos);
        }
        world.setBlockDataNotify(tilePos, orientation);
        this.dropTorchIfCantStay(world, tilePos);
    }

    public int getDefaultOrientation(@NotNull World world, @NotNull TilePosc tilePos) {
        if (this.isSupported(world, tilePos, Side.BOTTOM)) {
            return 5;
        }
        if (this.isSupported(world, tilePos, Side.WEST)) {
            return 1;
        }
        if (this.isSupported(world, tilePos, Side.EAST)) {
            return 2;
        }
        if (this.isSupported(world, tilePos, Side.NORTH)) {
            return 3;
        }
        if (this.isSupported(world, tilePos, Side.SOUTH)) {
            return 4;
        }
        return 0;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        super.updateTick(world, tilePos, rand, isRandomTick);
        if (world.getBlockData(tilePos) == 0) {
            this.onPlacedByWorld(world, tilePos);
        }
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        int orientation = this.getDefaultOrientation(world, tilePos);
        if (orientation != 0) {
            world.setBlockDataNotify(tilePos, orientation);
        }
        this.dropTorchIfCantStay(world, tilePos);
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, int id) {
        boolean invalid;
        int side = world.getBlockData(tilePos) & 7;
        switch (side) {
            case 1: {
                boolean bl;
                if (!this.isSupported(world, tilePos, Side.WEST)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl;
                if (!this.isSupported(world, tilePos, Side.EAST)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                boolean bl;
                if (!this.isSupported(world, tilePos, Side.NORTH)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                boolean bl;
                if (!this.isSupported(world, tilePos, Side.SOUTH)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 5: {
                boolean bl;
                if (!this.isSupported(world, tilePos, Side.BOTTOM)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = invalid = true;
            }
        }
        if (invalid) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, side, null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    private void dropTorchIfCantStay(@NotNull World world, @NotNull TilePosc tilePos) {
        if (!this.canPlaceAt(world, tilePos)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        double xPos = (double)tilePos.x() + 0.5;
        double yPos = (double)tilePos.y() + 0.7;
        double zPos = (double)tilePos.z() + 0.5;
        double d3 = 0.22;
        double d4 = 0.27;
        int side = world.getBlockData(tilePos) & 7;
        switch (side) {
            case 1: {
                world.spawnParticle("smoke", xPos - d4, yPos + d3, zPos, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("flame", xPos - d4, yPos + d3, zPos, 0.0, 0.0, 0.0, 0);
                break;
            }
            case 2: {
                world.spawnParticle("smoke", xPos + d4, yPos + d3, zPos, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("flame", xPos + d4, yPos + d3, zPos, 0.0, 0.0, 0.0, 0);
                break;
            }
            case 3: {
                world.spawnParticle("smoke", xPos, yPos + d3, zPos - d4, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("flame", xPos, yPos + d3, zPos - d4, 0.0, 0.0, 0.0, 0);
                break;
            }
            case 4: {
                world.spawnParticle("smoke", xPos, yPos + d3, zPos + d4, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("flame", xPos, yPos + d3, zPos + d4, 0.0, 0.0, 0.0, 0);
                break;
            }
            case 5: {
                world.spawnParticle("smoke", xPos, yPos, zPos, 0.0, 0.0, 0.0, 0);
                world.spawnParticle("flame", xPos, yPos, zPos, 0.0, 0.0, 0.0, 0);
            }
        }
    }

    @Override
    public int getLightmapCoord(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return source.getLightmapCoord(tilePos, this.block.emission > 0 ? 15 : 0);
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    @NotNull
    public ISupport getSupportConstraint(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return switch (side) {
            case Side.NORTH, Side.SOUTH, Side.WEST, Side.EAST, Side.BOTTOM -> PartialSupport.INSTANCE.center();
            default -> PartialSupport.INSTANCE;
        };
    }
}

